/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Thomas Timbul - adaptation to Kenya Plugin
 *******************************************************************************/
package kenya.eclipse.multieditor.util;


import kenya.eclipse.KenyaPlugin;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/**
 * Manager for colors used in the Java editor
 */
public class DefaultSyntaxColorProvider {

	public static final RGB MULTI_LINE_COMMENT= new RGB(63, 127, 95); //#3F7F5F
	public static final RGB SINGLE_LINE_COMMENT= new RGB(63, 127, 95); //#3F7F5F
	public static final RGB KEYWORD= new RGB(127, 0, 85); //#7F0055
	public static final RGB TYPE= new RGB(127, 0, 85); //#7F0055
	public static final RGB STRING= new RGB(42, 0, 255); //#2A00FF
	public static final RGB DEFAULT= new RGB(0, 0, 0);
	
	/**
	 * Return the Color that is stored in the Color table as rgb.
	 */
	public Color getColor(RGB rgb) {
		return KenyaPlugin.getDefault().getKenyaColourManager().getColor(rgb);
	}
}
