package kenya.eclipse.preferences;

import kenya.eclipse.KenyaPlugin;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class KenyaPreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
	/*
	 * add one static field for each preference
	 */
	public static final String P_PATH = "pathPreference";
	public static final String P_BOOLEAN = "booleanPreference";
	public static final String P_CHOICE = "choicePreference";
	public static final String P_STRING = "stringPreference";

	public KenyaPreferencePage() {
		super(GRID);
		setPreferenceStore(KenyaPlugin.getDefault().getPreferenceStore());
		setDescription("This will soon hold the Kenya preferences.");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setDefault(P_BOOLEAN, true);
		store.setDefault(P_CHOICE, "choice2");
		store.setDefault(P_STRING, "Default value");
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */

	public void createFieldEditors() {
		addField(
				new DirectoryFieldEditor(
					P_PATH, //name of the property that this changes
					"&Directory preference:", //description (text)
					getFieldEditorParent() //parent of the field
				)
			);
		addField(
				new BooleanFieldEditor(
						P_BOOLEAN,
						"&An example of a boolean preference",
						getFieldEditorParent()
				)
			);
		addField(
				new RadioGroupFieldEditor(
					P_CHOICE,
					"An example of a multiple-choice preference",
					1,
					new String[][] {
							{ "&Choice 1", "choice1" },
							{ "C&hoice 2", "choice2" }
						},
					getFieldEditorParent()
				)
			);
		addField(
				new StringFieldEditor(
					P_STRING,
					"A &text preference:",
					getFieldEditorParent()
				)
			);
	}
	
	public void init(IWorkbench workbench) {
		
	}
}