/*
 * Created on 07-Jan-2005
 */
package kenya.eclipse.style.checkerimpl;

import java.util.Map;

import mediator.ICheckedCode;

import org.eclipse.core.resources.IFile;

/**
 * @author Thomas Timbul
 */
public interface IStyleChecker {
	
	/**
	 * a marker property defining the absolute offset in
	 * the document, where the solution should be applied.
	 * It is possible that a marker does not have this attribute set.
	 */
	static final String FIX_OFFSET = "__fix_offset";
	
	public IStyleCheckerDescriptor getDescriptor();
	void setDescriptor(IStyleCheckerDescriptor descriptor);
	
	/**
	 * configures this Checker with the custom attributes
	 * set in the markup
	 * @param customAttributes map of custom attributes
	 */
	public void configure(Map customAttributes);
	
	/**
	 * Executes this Checker on the given code and file. This method should
	 * create markers on the file for any issues it detects. The marker update must
	 * be run in an IWorkspaceRunnable.
	 * <br>Further, this method must create solutions to the found problems, if
	 * it is able to do so. These solutions can later be retrieved using
	 * {@link #getMarkerResolutionMap()}
	 * 
	 * @param code the ICheckedCode to check
	 * @param file the IFile this check is performed on (for adding markers)
	 */
	public void performCheck(ICheckedCode code, IFile file);
	
	/**
	 * Returns a non-null Map of IMarkers to an array of IMarkerResolutions.
	 * The resolutions should have been generated beforehand during a call
	 * to {@link #performCheck(ICheckedCode, IFile)}.
	 * @return a non-null Map of IMarkerResolutions for each
	 * IMarker generated by this instance
	 */
	public Map getMarkerResolutionMap();
	
}
