/*
 * Created on 08-Jan-2005
 */
package kenya.eclipse.style.checkerimpl;

import org.eclipse.core.runtime.QualifiedName;


/**
 * @author Thomas Timbul
 */
public class StyleCheckerDescriptor implements IStyleCheckerDescriptor {
	
	private QualifiedName fId;
	private String fName;
	private IStyleChecker fChecker;
	private boolean fIsDefaultEnabled;
	
	
	public StyleCheckerDescriptor(QualifiedName id, String name, IStyleChecker checker, boolean isDefaultEnabled) {
		fId = id;
		fName = name;
		fIsDefaultEnabled = isDefaultEnabled;
		fChecker = checker;
		fChecker.setDescriptor(this);
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.style.IStyleCheckerDescriptor#getChecker()
	 */
	public IStyleChecker getChecker() {
		return fChecker;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.style.IStyleCheckerDescriptor#getID()
	 */
	public QualifiedName getID() {
		return fId;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.style.IStyleCheckerDescriptor#getName()
	 */
	public String getName() {
		return fName;
	}
	
	/*
	 *  (non-Javadoc)
	 * @see kenya.eclipse.style.checkerimpl.IStyleCheckerDescriptor#isDefaultEnabled()
	 */
	public boolean isDefaultEnabled() {
		return fIsDefaultEnabled;
	}
}
