/*
 * Created on 25-Jan-2005
 */
package kenya.eclipse.style.checks;

import java.util.ArrayList;
import java.util.List;

import minijava.analysis.DepthFirstAdapter;
import minijava.node.AListStatements;
import minijava.node.Node;
import minijava.node.PStatement;

/**
 * utility to find all statements contained in a given node.
 * This includes nested statements.
 * @author Thomas Timbul
 */
public class StatementSearch extends DepthFirstAdapter {
	
	public static List getAllStatements(Node n) {
		StatementSearch s = new StatementSearch();
		n.apply(s);
		return s._statements;
	}
	
	private ArrayList _statements = new ArrayList();
	
	protected StatementSearch() {}
	
	public void caseAListStatements(AListStatements node) {
		PStatement st = node.getStatement();
		if(st!=null) {
			_statements.add(st);
		}
		super.caseAListStatements(node);
	}
	
}
