/*
 * Created on 22-Jan-2005
 */
package kenya.eclipse.style.checks.bool;

import java.util.ArrayList;
import java.util.List;

import minijava.analysis.DepthFirstAdapter;
import minijava.node.AIfStat;
import minijava.node.AIfStatement;
import minijava.node.Node;

/**
 * @author Thomas Timbul
 */
public class IfSearch extends DepthFirstAdapter {
	
	public static List getIfStats(Node n, boolean wrappingStatement) {
		IfSearch s = new IfSearch(wrappingStatement);
		n.apply(s);
		return s._ifs;
	}
	
	protected IfSearch(boolean wrappingStatement) {
		this.wrappingStatement = wrappingStatement;
	}
	
	//if its true then we get AIfStatements rather than AIfStats
	private final boolean wrappingStatement;
	private ArrayList _ifs = new ArrayList();
	
	public void caseAIfStatement(AIfStatement node) {
		if(wrappingStatement) {
			_ifs.add(node);
		}
		super.caseAIfStatement(node);
	}
	
	public void caseAIfStat(AIfStat node) {
		if(!wrappingStatement) {
			_ifs.add(node);
		}
		super.caseAIfStat(node);
	}
}
