/*
 * Created on 24-Oct-2004
 */
package kenya.eclipse.ui.views;

import java.lang.reflect.Array;
import java.util.ArrayList;

import kenya.eclipse.KenyaConstants;
import kenya.eclipse.KenyaPlugin;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.navigator.ResourceNavigator;

/**
 * @author Thomas Timbul
 */
public class KenyaResourceNavigator extends ResourceNavigator implements IResourceChangeListener {
	
	public KenyaResourceNavigator() {
		super();
		MatchMaker.addRegex(".*\\.k", true); //accept any .k file
		MatchMaker.addRegex(".*\\.java", true); //allow java files
		//MatchMaker.addRegex(".*\\.[^k].*", false); //reject anything else
		//MatchMaker.addRegex(null, false)
		ResourcesPlugin.getWorkspace().addResourceChangeListener(this);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.navigator.ResourceNavigator#initFilters(org.eclipse.jface.viewers.TreeViewer)
	 */
	protected void initFilters(TreeViewer viewer) {
		super.initFilters(viewer);
		viewer.addFilter(new ViewerFilter() {
			
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				IResource resource = null;
				
				if(element instanceof IProject) {
					IProject pr = (IProject)element;
					try {
						if(!pr.isAccessible() || pr.hasNature(KenyaConstants.K_NATURE_ID)) {
							return true;
						}
					} catch(CoreException e) {
						e.printStackTrace();
					}
				} else if(element instanceof IFolder) {
					IContainer p = ((IFolder)element).getParent();
					return !( (IResource)element ).getName().equals("CVS")
					    && select(viewer, p.getParent(), p);
					
				} else if (element instanceof IResource) {
					resource = (IResource)element;
				} else if (element instanceof IAdaptable) {
					IAdaptable adaptable = (IAdaptable)element;
					resource = (IResource)adaptable.getAdapter(IResource.class);
				}
				
				if (resource != null) {
					String name = resource.getName();
					return MatchMaker.matches(name);
				}
				return false;
			}
			
		});
	}
	
	private static class MatchMaker {
		
		static class RegEx {
			private String regex;
			private boolean match;
			RegEx(String regex, boolean match) {
				this.regex=regex;
				this.match=match;
			}
			String regex() { return regex; }
			boolean match(){ return match; }
		}
		
		static ArrayList regexs = new ArrayList();
		
		static void addRegex(String regex, boolean match) {
			addRegex(new RegEx(regex, match));
		}
		static void addRegex(RegEx regex) {
			regexs.add(regex);
		}
		
		/**
		 * matches the input string against stored patterns.
		 * If the string matches a particular pattern then the
		 * match flag is returned which indicates whether to accept
		 * or reject matchers of the pattern.
		 * If no patterns are stored then all files will be rejected.
		 * Known issue: If a file could be accepted or rejected by
		 * different patterns then whichever is tested first takes precedence.
		 * The order in this case is defined by the order in which the patterns were added.
		 * @param input the input string to match against stored patterns
		 * @return true iff the input matches a pattern and this pattern is
		 * explicitly flagged for acceptance, false in all other cases
		 */
		static boolean matches(String input) {
			if(input==null) return false;
			for(int i=0; i<regexs.size(); i++) {
				RegEx r = (RegEx)regexs.get(i);
				//System.out.println(r.regex());
				if(input.matches(r.regex())) {
					return r.match();
				}
			}
			return false;
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.navigator.ResourceNavigator#createViewer(org.eclipse.swt.widgets.Composite)
	 */
	protected TreeViewer createViewer(Composite parent) {
		TreeViewer v = super.createViewer(parent);
		
		return v;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IResourceChangeListener#resourceChanged(org.eclipse.core.resources.IResourceChangeEvent)
	 */
	public void resourceChanged(IResourceChangeEvent event) {

		Object refresh = null;
		
		if(event.getType()!=IResourceChangeEvent.POST_CHANGE) {
			refresh = KenyaPlugin.getWorkspace().getRoot();
		} else {
			if(event.getResource()!=null) {
				IResourceDelta delta = event.getDelta();
				if(delta!=null && (delta.getKind()&IResourceDelta.CHANGED)==0) {
					return;
				}
				refresh = event.getResource();
			} else {
				IMarkerDelta[] problemMarkerDelta = event.findMarkerDeltas(IMarker.PROBLEM, true);
				if(Array.getLength(problemMarkerDelta)>0) {
					refresh = problemMarkerDelta[0].getResource();
					//it is UNLIKELY that two things happen at the
					// same time (more than one file get parsed simultaneously)!
				}
			}
		}
		if(refresh!=null) {
			getViewer().getControl().getDisplay().asyncExec(new ViewerUpdate(refresh));
		}
		
	}
	
	private class ViewerUpdate implements Runnable {
		
		private final Object fElement;
		
		public ViewerUpdate(Object element) {
			fElement = element;
		}
		
		public void run() {
			getViewer().refresh(fElement, true);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.navigator.ResourceNavigator#dispose()
	 */
	public void dispose() {
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(this);
		super.dispose();
	}
}
