/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.action.file;

import java.io.File;
import kenya.FileLoaderSaver;
import kenya.sole.ui.core.EditingWindowUtilsFactory;
import kenya.sole.ui.editor.KenyaPart;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenInNewAction
extends Action {
    private final KenyaPart window;
    private String lastDir = null;

    public OpenInNewAction(KenyaPart kenyaPart) {
        this.window = kenyaPart;
        this.setText("&Open in a new window...@Shift+Ctrl+O");
        this.setToolTipText("Open a new file in a new window");
    }

    public void run() {
        Shell shell = new Shell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        if (this.lastDir == null && this.window.getKenyaFile() != null) {
            this.lastDir = this.window.getKenyaFile().getDir();
            if (this.lastDir.length() == 0) {
                this.lastDir = null;
            }
        }
        if (this.lastDir != null) {
            fileDialog.setFilterPath(this.lastDir);
        }
        fileDialog.setFilterExtensions(new String[]{"*.k"});
        fileDialog.setText("Open Kenya file");
        if (fileDialog.open() != null) {
            this.lastDir = fileDialog.getFilterPath();
            File file = new File(fileDialog.getFilterPath(), fileDialog.getFileName());
            FileLoaderSaver fileLoaderSaver = new FileLoaderSaver();
            fileLoaderSaver.setPath(file.getAbsolutePath());
            EditingWindowUtilsFactory.createAndOpenEditorWindow(fileLoaderSaver);
        }
    }
}

