/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor.kenya;

import kenya.sole.ui.editor.KenyaPart;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;

public class KenyaTableSelectionChangedListener
implements ISelectionChangedListener {
    private final KenyaPart kenya;

    public KenyaTableSelectionChangedListener(KenyaPart kenyaPart) {
        this.kenya = kenyaPart;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISourceCodeLocation iSourceCodeLocation;
        StyledText styledText = this.kenya.getEditorTextWidget();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        if (iStructuredSelection.getFirstElement() != null && (iSourceCodeLocation = ((ISourceCodeInformation)iStructuredSelection.getFirstElement()).getLocation()).getLineNumber() > 0) {
            int n = styledText.getOffsetAtLine(iSourceCodeLocation.getLineNumber() - 1);
            styledText.setCaretOffset(n += iSourceCodeLocation.getColumnNumber() - 1);
            int n2 = iSourceCodeLocation.getTokenLength();
            if (n + n2 < styledText.getCharCount()) {
                styledText.setSelectionRange(n, n2);
                styledText.showSelection();
            }
            this.kenya.getHighlightingManager().showLinkedHighlights(n + 1);
        }
        styledText.setFocus();
    }
}

