/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.event;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import kenya.FileLoaderSaver;
import kenya.errors.KenyaInternalError;
import kenya.sole.ui.editor.InterpreterPart;
import kenya.sole.ui.editor.JavaPart;
import kenya.sole.ui.editor.KenyaPart;
import kenya.ui.syntaxhighlighting.JavaLineStyler;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.Mediator;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.TabFolder;
import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.ClosureScope;
import org.wellquite.kenya.stackMachine.scope.IClosureScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;

public class TabSelectionAdapter
extends SelectionAdapter {
    private static final String noTranslation = "Kenya code contains errors, can not translate to Java.";
    private static final String noInterpretation = "Kenya code contains errors, can not debug.";
    private final KenyaPart kenya;
    private final JavaPart java;
    private final InterpreterPart intp;
    private String oldJavaText = null;
    private String oldInterpreterText = null;
    private String lineDelimiter = null;
    private StringBuffer javaBuffer = new StringBuffer();

    public TabSelectionAdapter(KenyaPart kenyaPart, JavaPart javaPart, InterpreterPart interpreterPart) {
        this.kenya = kenyaPart;
        this.java = javaPart;
        this.intp = interpreterPart;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        block38: {
            int n = ((TabFolder)selectionEvent.widget).getSelectionIndex();
            if (n == 0) {
                if (this.intp.getStackMachine() != null) {
                    this.intp.getInterpreterTerminateButton().notifyListeners(13, null);
                }
                if (this.java.getJavaCode() != null) {
                    this.java.getJavaTerminateButton().notifyListeners(13, null);
                }
                return;
            }
            if (n == 1) {
                if (this.intp.getStackMachine() != null) {
                    this.intp.getInterpreterTerminateButton().notifyListeners(13, null);
                }
            } else if (n == 2 && this.java.getJavaCode() != null) {
                this.java.getJavaTerminateButton().notifyListeners(13, null);
            }
            StyledText styledText = this.kenya.getEditorTextWidget();
            StyledText styledText2 = this.java.getEditorTextWidget();
            StyledText styledText3 = this.intp.getEditorTextWidget();
            if (styledText2 == null || styledText == null) {
                return;
            }
            if (this.lineDelimiter == null) {
                this.lineDelimiter = styledText2.getLineDelimiter();
            }
            String string = styledText.getText();
            if (this.oldInterpreterText == null || !string.equals(this.oldInterpreterText) || this.oldJavaText == null || !string.equals(this.oldJavaText)) {
                try {
                    ICheckedCode iCheckedCode = Mediator.check((Reader)new StringReader(string));
                    this.kenya.setCheckedCode(iCheckedCode);
                    if (n == 1) {
                        if (this.oldJavaText != null && string.equals(this.oldJavaText)) break block38;
                        if (this.java.isJavaRunning()) {
                            return;
                        }
                        try {
                            Button button = this.java.getJavaExecuteButton();
                            button.setText("E&xecute Java");
                            if (iCheckedCode.isErroredCode()) {
                                styledText2.setText(noTranslation);
                                ((JavaLineStyler)this.java.getLineStyler()).parseBlockComments(noTranslation);
                                this.java.rebuildLineNumbers();
                                this.java.setJavaCode(null);
                                this.java.setJavaClassName(null);
                                button.setEnabled(false);
                            } else {
                                String string2;
                                this.java.setJavaCode(iCheckedCode.translate());
                                styledText2.setRedraw(false);
                                StyledTextContent styledTextContent = styledText2.getContent();
                                styledTextContent.setText("");
                                BufferedReader bufferedReader = null;
                                FileLoaderSaver fileLoaderSaver = this.kenya.getKenyaFile();
                                boolean bl = false;
                                String string3 = null;
                                IJavaCode iJavaCode = this.java.getJavaCode();
                                if (fileLoaderSaver == null || fileLoaderSaver.getName() == null || fileLoaderSaver.getName().length() == 0) {
                                    if (iJavaCode.isValidClassName(this.java.getJavaDefaultClassName())) {
                                        string3 = this.java.getJavaDefaultClassName();
                                    } else {
                                        bl = true;
                                    }
                                } else {
                                    string2 = fileLoaderSaver.getName();
                                    if (string2.endsWith(".k")) {
                                        string2 = string2.substring(0, string2.length() - 2);
                                    }
                                    if (string2.length() > 1) {
                                        char c = string2.charAt(0);
                                        string2 = new String("" + c).toUpperCase() + string2.substring(1);
                                    }
                                    if (iJavaCode.isValidClassName(string2)) {
                                        string3 = string2;
                                    } else if (iJavaCode.isValidClassName(this.java.getJavaDefaultClassName())) {
                                        string3 = this.java.getJavaDefaultClassName();
                                    } else {
                                        bl = true;
                                    }
                                }
                                if (bl) {
                                    this.java.setJavaClassName(null);
                                    bufferedReader = new BufferedReader(iJavaCode.getPlaceHeldCode());
                                    button.setEnabled(false);
                                } else {
                                    this.java.setJavaClassName(string3);
                                    bufferedReader = new BufferedReader(iJavaCode.getCode(string3));
                                    button.setEnabled(true);
                                }
                                this.javaBuffer.setLength(0);
                                string2 = bufferedReader.readLine();
                                while (string2 != null) {
                                    this.javaBuffer.append(string2);
                                    this.javaBuffer.append(this.lineDelimiter);
                                    string2 = bufferedReader.readLine();
                                }
                                bufferedReader.close();
                                styledTextContent.setText(this.javaBuffer.toString());
                                ((JavaLineStyler)this.java.getLineStyler()).parseBlockComments(this.javaBuffer.toString());
                                this.java.rebuildLineNumbers();
                                styledText2.setRedraw(true);
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        this.oldJavaText = string;
                        break block38;
                    }
                    if (n != 2) break block38;
                    if (this.intp.getStackMachine() != null) {
                        return;
                    }
                    if (this.oldInterpreterText != null && string.equals(this.oldInterpreterText)) break block38;
                    this.intp.getInterpreterContinueButton().setEnabled(false);
                    if (iCheckedCode.isErroredCode()) {
                        styledText3.setText(noInterpretation);
                        this.intp.rebuildLineNumbers();
                        this.intp.getInterpreterInterpretButton().setEnabled(false);
                        this.intp.getInterpreterStepModeButton().setEnabled(false);
                    } else {
                        styledText3.setRedraw(false);
                        styledText3.setText(styledText.getText());
                        this.intp.rebuildLineNumbers();
                        IStackMachineInformationProvider iStackMachineInformationProvider = iCheckedCode.getBaseStackMachine();
                        this.intp.setBaseStackMachine(iStackMachineInformationProvider);
                        this.intp.getCarrotPainter().clear();
                        styledText3.setRedraw(true);
                        this.intp.getInterpreterInterpretButton().setEnabled(true);
                        this.intp.getInterpreterStepModeButton().setEnabled(true);
                        StackMachine stackMachine = this.intp.getStackMachine();
                        if (stackMachine != null) {
                            stackMachine.shutdown();
                            this.intp.setStackMachine(null);
                        }
                        stackMachine = new StackMachine();
                        this.intp.getInterpreterStdOutText().setText("");
                        try {
                            ClosureScope closureScope = new ClosureScope();
                            ClosureMiscHelper.executeClosureInScope((IClosureScope)closureScope, (IAtomicClosure)iStackMachineInformationProvider.getPreInitClosure(), (StackMachine)stackMachine);
                        }
                        catch (Throwable throwable) {
                            this.intp.getInterpreterStdOutText().append("" + throwable);
                            this.intp.getInterpreterInterpretButton().setEnabled(false);
                            this.intp.getInterpreterStepModeButton().setEnabled(false);
                        }
                    }
                    this.oldInterpreterText = string;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (KenyaInternalError kenyaInternalError) {
                    System.err.println("SM compilation failed: ");
                    kenyaInternalError.printStackTrace(System.err);
                }
            }
        }
    }
}

