/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.util;

import java.util.HashSet;
import java.util.Set;
import kenya.sole.ui.editor.EditorPart;
import kenya.sole.ui.util.DefaultSeaDrawer;
import kenya.sole.ui.util.ICustomPaintListener;
import kenya.sole.ui.util.ISeaDrawer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractHighlighter
implements ICustomPaintListener {
    private final Color seaColor;
    private final Color backgroundColor;
    private final EditorPart editor;
    private final Set rows = new HashSet();
    private static final ISeaDrawer seaDrawer = new DefaultSeaDrawer();
    private final Set highlights = new HashSet();

    protected AbstractHighlighter(EditorPart editorPart, Color color, Color color2) {
        this.editor = editorPart;
        this.seaColor = color;
        this.backgroundColor = color2;
    }

    public synchronized void addHighlight(int n, int n2, int n3) {
        this.highlights.add(new Point(n, n2));
        this.rows.add(new Integer(n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintControl(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        if (!this.editor.isVisible()) {
            return;
        }
        StyledText styledText = this.editor.getEditorTextWidget();
        HashSet hashSet = null;
        Object object = this;
        synchronized (object) {
            hashSet = new HashSet(this.highlights);
        }
        if (hashSet != null) {
            object = hashSet.iterator();
            while (object.hasNext()) {
                int n;
                Point point = (Point)object.next();
                int n2 = point.x;
                if (n2 >= styledText.getCharCount()) {
                    n2 = styledText.getCharCount() - 1;
                }
                Point point2 = styledText.getLocationAtOffset(n2);
                int n3 = point.x + point.y;
                if (n3 >= styledText.getCharCount()) {
                    n3 = styledText.getCharCount() - 1;
                }
                Point point3 = styledText.getLocationAtOffset(n3);
                point2.y = n = point2.y + styledText.getLineHeight() - 1;
                point3.y = n;
                if (paintEvent.x >= point3.x || paintEvent.x + paintEvent.width < point2.x || paintEvent.y >= n || paintEvent.y + paintEvent.height < n) continue;
                seaDrawer.drawLine(gC, point2.x, n, point3.x, n, this.seaColor);
            }
        }
    }

    public synchronized void clearHighlights() {
        this.highlights.clear();
        this.rows.clear();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public synchronized boolean isHighlightOnLine(int n) {
        return this.rows.contains(new Integer(n));
    }
}

