/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor.interpreter;

import kenya.sole.ui.editor.InterpreterPart;
import kenya.sole.ui.editor.interpreter.CarrotPainter;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.wellquite.kenya.stackMachine.IPointListener;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;

public class BlueCarrotMover
implements IPointListener {
    private final CarrotPainter ipl;
    private final StyledText text;
    private final InterpreterPart interpreter;
    private volatile int row = 0;
    private volatile int col = 0;
    private volatile int offset = 0;
    private volatile boolean paint = false;
    private volatile ISourceCodeLocation loc = null;
    private volatile IMethodScope lastMethod = null;

    public BlueCarrotMover(InterpreterPart interpreterPart) {
        this.ipl = interpreterPart.getCarrotPainter();
        this.text = interpreterPart.getEditorTextWidget();
        this.interpreter = interpreterPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointReached(final Object object) {
        if (this.text.isDisposed()) {
            return;
        }
        if (!(this.interpreter.getInterpreterStepMode() || this.interpreter.getInterpreterTrackMode() || this.ipl.carrotsSet() && this.ipl.isCarrotAtOffset((ISourceCodeLocation)object))) {
            return;
        }
        if (Thread.currentThread().equals(this.text.getDisplay().getThread())) {
            BlueCarrotMover blueCarrotMover = this;
            synchronized (blueCarrotMover) {
                this.loc = (ISourceCodeLocation)object;
                this.paint = false;
                if (this.ipl.isCarrotAtOffset(this.loc)) {
                    this.interpreter.getStackMachine().setStepMode(true);
                    this.interpreter.getInterpreterContinueButton().setEnabled(true);
                    this.paint = true;
                }
                if (this.interpreter.getInterpreterStepMode()) {
                    this.interpreter.getInterpreterContinueButton().setEnabled(true);
                    this.paint = true;
                }
                if (this.interpreter.getInterpreterTrackMode()) {
                    this.paint = true;
                }
                if (this.paint) {
                    this.row = this.loc.getLineNumber() - 1;
                    this.col = this.loc.getColumnNumber() - 1;
                    this.offset = this.text.getOffsetAtLine(this.row) + this.col;
                    this.ipl.setBlueCarrotOffset(this.offset);
                    if (this.interpreter.getStackMachine().getMethodScope() != this.lastMethod) {
                        this.interpreter.getInterpreterList().refresh();
                        this.interpreter.getInterpreterList().setSelection((ISelection)new StructuredSelection(this.interpreter.getInterpreterList().getElementAt(0)), true);
                        this.lastMethod = this.interpreter.getStackMachine().getMethodScope();
                    }
                    this.interpreter.getInterpreterInspector().refresh();
                }
            }
        } else {
            this.text.getDisplay().syncExec(new Runnable(){

                public void run() {
                    BlueCarrotMover.this.pointReached(object);
                }
            });
        }
    }
}

