/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor.interpreter;

import java.util.Map;
import kenya.sole.ui.editor.InterpreterPart;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassStaticType;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.IGenericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;
import org.wellquite.kenya.stackMachine.types.interfaces.INonPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.IPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.IStringType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class InterpreterInspectorLabelProvider
implements ILabelProvider {
    private static final String SINGLE_QUOTE = "'";
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String STATIC_CLASS_ = "static class ";
    private static final String INSTANCE_OF_CLASS_ = "instance of class ";
    private static final String _EQUALS_ = " = ";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String _ARRAY_OF_LENGTH_ = " array of length ";
    private final InterpreterPart interpreter;

    public InterpreterInspectorLabelProvider(InterpreterPart interpreterPart) {
        this.interpreter = interpreterPart;
    }

    public Image getImage(Object object) {
        return null;
    }

    public String getText(Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry;
            String string;
            IStackMachineInformationProvider iStackMachineInformationProvider = this.interpreter.getBaseStackMachine();
            IVariable iVariable = iStackMachineInformationProvider.lookupVariable(string = (entry = (Map.Entry)object).getKey().toString());
            if (iVariable != null) {
                string = iVariable.getType().getName() + SPACE + iVariable.getName();
            }
            String string2 = EMPTY_STRING;
            IType iType = (IType)entry.getValue();
            if (iType instanceof IPrimitiveType) {
                string2 = iType instanceof IArrayType ? string2 + _ARRAY_OF_LENGTH_ + ((IArrayType)iType).getLength() : (iType instanceof ICharType ? string2 + SINGLE_QUOTE + ((ICharType)iType).getValue().charValue() + SINGLE_QUOTE : string2 + ((IPrimitiveType)iType).valueToString());
            } else if (iType instanceof INullType) {
                string2 = string2 + ((INullType)iType).valueToString();
            } else if (iType instanceof IGenericType) {
                string2 = string2 + ((IGenericType)iType).valueToString();
            } else if (iType instanceof INonPrimitiveType) {
                if (iType instanceof IStringType) {
                    string2 = string2 + DOUBLE_QUOTE + ((IStringType)iType).valueToString() + DOUBLE_QUOTE;
                } else if (iType instanceof IEnumType) {
                    string2 = string2 + ((IEnumType)iType).valueToString() + " (enum ";
                    IInterpretedEnumeration iInterpretedEnumeration = ((IEnumType)iType).getEnumeration();
                    String string3 = iInterpretedEnumeration.getName();
                    IClass iClass = iStackMachineInformationProvider.lookupEnum(string3);
                    if (iClass != null) {
                        string3 = iClass.getName();
                    }
                    string2 = string2 + string3 + " {";
                    Object[] objectArray = iInterpretedEnumeration.getValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        string2 = string2 + objectArray[i].toString() + ", ";
                    }
                    string2 = string2.substring(0, string2.length() - 2);
                    string2 = string2 + "})";
                } else if (iType instanceof IClassStaticType) {
                    string2 = string2 + STATIC_CLASS_;
                    String string4 = ((IClassStaticType)iType).getValue().getName();
                    IClass iClass = iStackMachineInformationProvider.lookupClass(string4);
                    string2 = iClass == null ? string2 + string4 : string2 + iClass.getName();
                } else if (iType instanceof IClassInstanceType) {
                    string2 = string2 + INSTANCE_OF_CLASS_;
                    String string5 = ((IClassInstanceType)iType).getValue().getInterpretedClass().getName();
                    IClass iClass = iStackMachineInformationProvider.lookupClass(string5);
                    string2 = iClass == null ? string2 + string5 : string2 + iClass.getName();
                }
            }
            return string + _EQUALS_ + string2;
        }
        return EMPTY_STRING;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }
}

