/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor.interpreter;

import kenya.sole.ui.editor.InterpreterPart;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

public class InterpreterInspectorListLabelProvider
implements ILabelProvider {
    private static final String CLOSEBRACKET = ")";
    private static final String COMMASPACE = ", ";
    private static final String SPACE = " ";
    private static final String OPENBRACKET = " (";
    private final InterpreterPart interpreter;

    public InterpreterInspectorListLabelProvider(InterpreterPart interpreterPart) {
        this.interpreter = interpreterPart;
    }

    public Image getImage(Object object) {
        return null;
    }

    public String getText(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof IMethodScope) {
            IStackMachineInformationProvider iStackMachineInformationProvider = this.interpreter.getBaseStackMachine();
            IInterpretedMethod iInterpretedMethod = ((IMethodScope)object).getCurrentMethod();
            IFunction iFunction = iStackMachineInformationProvider.lookupFunction(iInterpretedMethod.getName());
            stringBuffer.append(iFunction.getName());
            stringBuffer.append(OPENBRACKET);
            IVariable[] iVariableArray = iFunction.getArguments();
            for (int i = 0; i < iVariableArray.length; ++i) {
                stringBuffer.append(iVariableArray[i].getType());
                stringBuffer.append(SPACE);
                stringBuffer.append(iVariableArray[i].getName());
                stringBuffer.append(COMMASPACE);
            }
            if (stringBuffer.toString().endsWith(COMMASPACE)) {
                stringBuffer.delete(stringBuffer.length() - COMMASPACE.length(), stringBuffer.length());
            }
            stringBuffer.append(CLOSEBRACKET);
            return stringBuffer.toString();
        }
        return null;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }
}

