/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor.interpreter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import kenya.interpreter.util.InterpreterLastPointReachedCatcher;
import kenya.sole.ui.editor.InterpreterPart;
import kenya.sole.ui.editor.interpreter.BlueCarrotMover;
import kenya.sole.ui.editor.interpreter.InterpreterTerminateButtonSelectionListener;
import kenya.sole.ui.util.StdOutWriter;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.wellquite.kenya.stackMachine.IPointListener;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;
import org.wellquite.kenya.stackMachine.types.ArrayTypeFactory;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class InterpreterInterpretSelectionListener
extends SelectionAdapter {
    private final Button interpret;
    private final InterpreterPart interpreter;
    private final StyledText stdOut;
    private final Text stdIn;
    private final Button eof;
    private final Button terminate;
    private final Runnable enableStuff;
    private final Runnable disableStuff;
    private SelectionListener eofListener = null;
    private KeyListener keyListener = null;
    private SelectionListener terminateListener = null;

    public InterpreterInterpretSelectionListener(InterpreterPart interpreterPart) {
        this.interpreter = interpreterPart;
        this.stdOut = interpreterPart.getInterpreterStdOutText();
        this.stdIn = interpreterPart.getInterpreterStdInText();
        this.interpret = interpreterPart.getInterpreterInterpretButton();
        this.eof = interpreterPart.getInterpreterEOFButton();
        this.terminate = interpreterPart.getInterpreterTerminateButton();
        this.enableStuff = new Runnable(){

            public void run() {
                InterpreterInterpretSelectionListener.this.interpret.setEnabled(false);
                InterpreterInterpretSelectionListener.this.stdIn.setEnabled(true);
                InterpreterInterpretSelectionListener.this.stdIn.setFocus();
                InterpreterInterpretSelectionListener.this.stdIn.setText("");
                InterpreterInterpretSelectionListener.this.terminate.setEnabled(true);
                InterpreterInterpretSelectionListener.this.terminate.setText("Terminate");
                InterpreterInterpretSelectionListener.this.eof.setEnabled(true);
                InterpreterInterpretSelectionListener.this.stdOut.setText("");
            }
        };
        this.disableStuff = new Runnable(){

            public void run() {
                InterpreterInterpretSelectionListener.this.interpret.setEnabled(true);
                InterpreterInterpretSelectionListener.this.stdIn.setEnabled(false);
                InterpreterInterpretSelectionListener.this.terminate.setText("Terminate");
                InterpreterInterpretSelectionListener.this.terminate.setEnabled(false);
                InterpreterInterpretSelectionListener.this.eof.setEnabled(false);
                InterpreterInterpretSelectionListener.this.interpreter.getInterpreterContinueButton().setEnabled(false);
                StackMachine stackMachine = InterpreterInterpretSelectionListener.this.interpreter.getStackMachine();
                if (stackMachine != null) {
                    stackMachine.resume();
                    InterpreterInterpretSelectionListener.this.interpreter.setStackMachine(null);
                }
            }
        };
    }

    public synchronized void widgetSelected(SelectionEvent selectionEvent) {
        this.interpret.setEnabled(false);
        final StackMachine stackMachine = new StackMachine();
        final IStackMachineInformationProvider iStackMachineInformationProvider = this.interpreter.getBaseStackMachine();
        if (iStackMachineInformationProvider == null) {
            return;
        }
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            final PrintStream printStream = new PrintStream(pipedOutputStream, true);
            stackMachine.setOut(printStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(pipedInputStream), 16);
            StdOutWriter stdOutWriter = new StdOutWriter(bufferedReader, this.stdOut, 9);
            PipedInputStream pipedInputStream2 = new PipedInputStream();
            PipedOutputStream pipedOutputStream2 = new PipedOutputStream(pipedInputStream2);
            final PrintStream printStream2 = new PrintStream(pipedOutputStream2, true);
            stackMachine.setErr(printStream2);
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(pipedInputStream2), 16);
            StdOutWriter stdOutWriter2 = new StdOutWriter(bufferedReader2, this.stdOut, 3);
            PipedOutputStream pipedOutputStream3 = new PipedOutputStream();
            PipedInputStream pipedInputStream3 = new PipedInputStream(pipedOutputStream3);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(pipedInputStream3);
            stackMachine.setIn((InputStream)bufferedInputStream);
            final PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(pipedOutputStream3), true);
            if (this.keyListener != null) {
                this.stdIn.removeKeyListener(this.keyListener);
            }
            this.keyListener = new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.character == '\r') {
                        keyEvent.doit = false;
                        String string = InterpreterInterpretSelectionListener.this.stdIn.getText() + "\n";
                        InterpreterInterpretSelectionListener.this.stdIn.setText("");
                        InterpreterInterpretSelectionListener.this.stdOut.append(string);
                        StyleRange styleRange = new StyleRange();
                        styleRange.start = InterpreterInterpretSelectionListener.this.stdOut.getCharCount() - string.length();
                        styleRange.length = string.length();
                        styleRange.foreground = InterpreterInterpretSelectionListener.this.stdOut.getDisplay().getSystemColor(6);
                        InterpreterInterpretSelectionListener.this.stdOut.setStyleRange(styleRange);
                        InterpreterInterpretSelectionListener.this.stdOut.setCaretOffset(InterpreterInterpretSelectionListener.this.stdOut.getCharCount());
                        InterpreterInterpretSelectionListener.this.stdOut.setSelection(InterpreterInterpretSelectionListener.this.stdOut.getCharCount());
                        InterpreterInterpretSelectionListener.this.stdOut.showSelection();
                        printWriter.write(string);
                        printWriter.flush();
                    }
                }
            };
            this.stdIn.addKeyListener(this.keyListener);
            if (this.eofListener != null) {
                this.eof.removeSelectionListener(this.eofListener);
            }
            this.eofListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    printWriter.close();
                    InterpreterInterpretSelectionListener.this.stdIn.setEnabled(false);
                    InterpreterInterpretSelectionListener.this.eof.setEnabled(false);
                }
            };
            this.eof.addSelectionListener(this.eofListener);
            if (this.terminateListener != null) {
                this.terminate.removeSelectionListener(this.terminateListener);
            }
            this.terminateListener = new InterpreterTerminateButtonSelectionListener(this.interpreter, printWriter);
            this.terminate.addSelectionListener(this.terminateListener);
            AbstractJob abstractJob = new AbstractJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute() {
                    try {
                        InterpreterInterpretSelectionListener.this.interpreter.getDisplay().syncExec(InterpreterInterpretSelectionListener.this.enableStuff);
                        IInterpretedClass iInterpretedClass = iStackMachineInformationProvider.getEntryPointClass();
                        String string = iStackMachineInformationProvider.getEntryPoint();
                        BlueCarrotMover blueCarrotMover = new BlueCarrotMover(InterpreterInterpretSelectionListener.this.interpreter);
                        stackMachine.addPositionReachedListener((IPointListener)blueCarrotMover);
                        InterpreterLastPointReachedCatcher interpreterLastPointReachedCatcher = new InterpreterLastPointReachedCatcher(stackMachine);
                        stackMachine.addPositionReachedListener((IPointListener)interpreterLastPointReachedCatcher);
                        if (InterpreterInterpretSelectionListener.this.interpreter.getInterpreterStepMode()) {
                            stackMachine.setStepMode(true);
                        } else {
                            stackMachine.setStepMode(false);
                        }
                        InterpreterInterpretSelectionListener.this.interpreter.setStackMachine(stackMachine);
                        try {
                            try {
                                if (iStackMachineInformationProvider.entryPointTakesArguments()) {
                                    String[] stringArray = InterpreterInterpretSelectionListener.this.interpreter.getInterpreterArgs();
                                    IType[] iTypeArray = new IType[stringArray.length];
                                    for (int i = 0; i < stringArray.length; ++i) {
                                        iTypeArray[i] = StringTypeFactory.createStringType((String)stringArray[i]);
                                    }
                                    stackMachine.push((IType)ArrayTypeFactory.createArrayType((IType[])iTypeArray, (String)"String"));
                                }
                                InterpreterInterpretSelectionListener.this.interpreter.safeSetStatus("Debugger starting.");
                                stackMachine.invokeMethod(iInterpretedClass, string);
                                InterpreterInterpretSelectionListener.this.interpreter.positionBlueCarrot(0);
                                InterpreterInterpretSelectionListener.this.interpreter.safeSetStatus("Debugger completed.");
                            }
                            catch (Throwable throwable) {
                                stackMachine.shutdown();
                                IAtomicClosure iAtomicClosure = interpreterLastPointReachedCatcher.getLastClosure();
                                ISourceCodeLocation iSourceCodeLocation = (ISourceCodeLocation)interpreterLastPointReachedCatcher.getLastPointData();
                                if (iSourceCodeLocation == null || iAtomicClosure == null) {
                                    printStream2.println(throwable);
                                } else {
                                    printStream2.println(throwable + " at " + iAtomicClosure + ", line " + iSourceCodeLocation.getLineNumber() + ", column " + iSourceCodeLocation.getColumnNumber());
                                    InterpreterInterpretSelectionListener.this.interpreter.positionBlueCarrot(iSourceCodeLocation);
                                }
                                Object var9_13 = null;
                                printStream.close();
                                printStream2.close();
                                printWriter.close();
                                stackMachine.removePositionReachedListener((IPointListener)blueCarrotMover);
                                stackMachine.shutdown();
                                InterpreterInterpretSelectionListener.this.interpreter.setStackMachine(null);
                                InterpreterInterpretSelectionListener.this.interpreter.getDisplay().syncExec(InterpreterInterpretSelectionListener.this.disableStuff);
                                return;
                            }
                            Object var9_12 = null;
                            printStream.close();
                            printStream2.close();
                            printWriter.close();
                        }
                        catch (Throwable throwable) {
                            Object var9_14 = null;
                            printStream.close();
                            printStream2.close();
                            printWriter.close();
                            stackMachine.removePositionReachedListener((IPointListener)blueCarrotMover);
                            stackMachine.shutdown();
                            InterpreterInterpretSelectionListener.this.interpreter.setStackMachine(null);
                            InterpreterInterpretSelectionListener.this.interpreter.getDisplay().syncExec(InterpreterInterpretSelectionListener.this.disableStuff);
                            throw throwable;
                        }
                        stackMachine.removePositionReachedListener((IPointListener)blueCarrotMover);
                        stackMachine.shutdown();
                        InterpreterInterpretSelectionListener.this.interpreter.setStackMachine(null);
                        InterpreterInterpretSelectionListener.this.interpreter.getDisplay().syncExec(InterpreterInterpretSelectionListener.this.disableStuff);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println("SM encountered an error:\n");
                        runtimeException.printStackTrace(System.err);
                    }
                }
            };
            JobDispatch.enqueueJob((AbstractJob)stdOutWriter);
            JobDispatch.enqueueJob((AbstractJob)stdOutWriter2);
            JobDispatch.enqueueJob((AbstractJob)abstractJob);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

