/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;

public class StdOutWriter
extends AbstractJob {
    private static final int MAXBUFFERSIZE = 64;
    private final BufferedReader reader;
    private final StyledText text;
    private static final int EOF = -1;
    private final StringBuffer line = new StringBuffer();
    private final int color;
    private final Runnable runner;

    public StdOutWriter(Reader reader, StyledText styledText, int n) {
        this.reader = new BufferedReader(reader);
        this.text = styledText;
        this.color = n;
        this.runner = new Runnable(){

            public void run() {
                String string = StdOutWriter.this.line.toString();
                if (string != null) {
                    StdOutWriter.this.text.append(string);
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = StdOutWriter.this.text.getCharCount() - string.length();
                    styleRange.length = string.length();
                    styleRange.foreground = StdOutWriter.this.text.getDisplay().getSystemColor(StdOutWriter.this.color);
                    StdOutWriter.this.text.setStyleRange(styleRange);
                    StdOutWriter.this.text.setCaretOffset(StdOutWriter.this.text.getCharCount());
                    StdOutWriter.this.text.setSelection(StdOutWriter.this.text.getCharCount());
                    StdOutWriter.this.text.showSelection();
                }
            }
        };
    }

    public synchronized void execute() {
        try {
            this.line.setLength(0);
            int n = this.reader.read();
            while (n != -1) {
                this.line.append((char)n);
                if (!this.reader.ready() || this.line.length() >= 64) {
                    this.text.getDisplay().syncExec(this.runner);
                    this.line.setLength(0);
                }
                n = this.reader.read();
            }
        }
        catch (IOException iOException) {
            System.err.println("IO error when reading");
            iOException.printStackTrace();
        }
    }
}

