/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Jul 28, 2004
 *
 */
package kenya.sole.ui.action.file;

import kenya.sole.ui.editor.KenyaPart;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class SavePromptAction extends Action {

    private final KenyaPart window;

    private final Runnable runner;

    private boolean cancelled = false;

    public SavePromptAction(KenyaPart w) {
        window = w;
        final Action spa = this;
        runner = new Runnable() {

            public void run() {
                Shell shell = new Shell();
                MessageBox messageBox = new MessageBox(shell, SWT.YES | SWT.NO
                        | SWT.CANCEL);
                messageBox.setMessage("This file has been modified. "
                        + "If you do not save this file, your modifications "
                        + "will be lost. Do you wish to save this file?");
                int result = messageBox.open();
                synchronized (spa) {
                    if (result == SWT.YES) {
                        new KenyaSaveAction(window).run();
                    } else if (result == SWT.CANCEL) {
                        cancelled = true;
                    }
                }
            }
        };
    }

    public void run() {
        if (Thread.currentThread().equals(Display.getDefault().getThread())) {
            synchronized (this) {
                runner.run();
            }
        } else {
            Display.getDefault().syncExec(new Runnable() {

                public void run() {
                    run();
                }
            });
        }
    }

    public synchronized boolean isCancelled() {
        return cancelled;
    }
}