/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 19-Jul-2004 by toa02
 *
 */
package kenya.sole.ui.core;

import gnu.getopt.Getopt;

import java.util.ArrayList;
import java.util.List;

import kenya.CommandLineKenya;
import kenya.FileLoaderSaver;
import kenya.KenyaCore;

import mediator.subscription.MediationService;

import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.IJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

/**
 * @author toa02
 *  
 */
public class KenyaUI {
	
	public static final String VERSION = "4.2";
	
	private static boolean exiting = false;
	
	static final List exitListeners = new ArrayList();
	
	private static final AbstractJob exitJob = new AbstractJob() {
		
		public void execute() {
			List exiters = new ArrayList(exitListeners);
			for (int idx = 0; idx < exiters.size(); idx++) {
				AbstractJob exitingJob = (AbstractJob) exiters.get(idx);
				if (exitingJob != null) exitingJob.execute();
			}
			JobDispatch.shutDownAllJobs();
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				/* silently fail */
			}
			System.exit(0);
		}
	};
	
	/**
	 * Main entry point into Kenya.
	 */
	public static void main(String[] args) {
		
		Getopt op = CommandLineKenya.getOpts(args);
		int opt;
		while ((opt = op.getopt()) != -1) {
			switch (opt) {
				case 'h':
					/* Help */
					printHelp();
					System.exit(0);
					break;
				case 'n':
					KenyaCore.printLicense();
					System.exit(0);
					break;
				case 'd':
				case 'p':
				case 'f':
				case 'e':
				case 'l':
				case 't':
				case 'y':
				case 's':
				case 'c':
				case 'i':
					CommandLineKenya.main(args);
					return;
				case '?':
					/* Error message from getopt */
				default:
					/* Not recognised */
					printHelp();
				System.exit(1);
				break;
			}
		}
		
		//start the mediation service and add an exitListener
		// to stop it on program termination
		MediationService.getInstance().start();
		addExitListener(new AbstractJob() {
			public void execute() {
				MediationService.getInstance().shutdown();
			}
		});
		
		if(args.length>0) {
			/* There are file(s) to process */
			for (int idx = 0; idx < args.length; idx++) {
				String fileName = args[idx];
				FileLoaderSaver fls = new FileLoaderSaver();
				fls.setPath(fileName);
				EditingWindowUtilsFactory.createAndOpenEditorWindow(fls);
			}
		} else {
			/* There are no files to process */
			EditingWindowUtilsFactory.createAndOpenEditorWindow();
		}
	}
	
	public synchronized static void exit() {
		if (!exiting) {
			exiting = true;
			JobDispatch.enqueueJob(exitJob);
		}
	}
	
	public synchronized static boolean isExiting() {
		return exiting;
	}
	
	public synchronized static void addExitListener(IJob listener) {
		if (listener == null) {
			System.err.println("Attempt made to add a null exit listener.");
			throw new NullPointerException();
		} else
			exitListeners.add(listener);
	}
	
	public synchronized static void removeExitListener(AbstractJob listener) {
		exitListeners.remove(listener);
	}
	
	public static void printHelp() {
		System.out.println(guihelp);
	}
	
	public static final String guihelp =
		KenyaCore.commonhelp1
		+ KenyaCore.NEWLINE
		+ "        kenya [options] kenyaFile [arguments]"
		+ KenyaCore.NEWLINE
		+ KenyaCore.NEWLINE
		+ "If no options are specified, then the Kenya GUI will be used."
		+ KenyaCore.NEWLINE
		+ "Any options will cause Kenya to run on the command line, valid options are:"
		+ KenyaCore.optionshelp;
	
}