/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 29, 2004
 *
 */
package kenya.sole.ui.editor.interpreter;

import java.io.PrintWriter;

import kenya.sole.ui.editor.InterpreterPart;
import mediator.stackMachine.IStackMachineInformationProvider;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class InterpreterTerminateButtonSelectionListener extends
        SelectionAdapter {

    private final Button terminate;

    private final InterpreterPart interpreter;
    
    private final PrintWriter writer;

    public InterpreterTerminateButtonSelectionListener(InterpreterPart intp, PrintWriter write) {
        interpreter = intp;
        terminate = intp.getInterpreterTerminateButton();
        writer = write;
    }

    public void widgetSelected(SelectionEvent e) {
        terminate.setText("Terminating...");
        terminate.setEnabled(false);
        JobDispatch.enqueueJob(new AbstractJob() {

            public void execute() {
                IStackMachineInformationProvider ismip = interpreter
                        .getBaseStackMachine();
                StackMachine sm = interpreter.getStackMachine();
                String methodName = ismip.getEntryPoint();
                IInterpretedClass methodClass = ismip.getEntryPointClass();
                IAtomicClosure methodBody = methodClass.getMethod(methodName)
                        .getMethodBody();
                methodBody.getClosureScope().setReturn(true);
                writer.close();
                sm.shutdown();
                interpreter.safeSetStatus("Debugger terminated.");
            }
        });
    }

}