/*
 * Created on 30-Oct-2004
 */
package kenya.sole.ui.action;


import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * TargetAction invokes method(s) in a target specified in the constructor
 * @author Thomas Timbul
 */
public abstract class TargetAction extends Action {
	
	protected final IActionTarget target;
	
	public TargetAction(IActionTarget target) {
		super();
		this.target = target;
	}
	
	public TargetAction(IActionTarget target, String text) {
		super(text);
		this.target = target;
	}
	
	public TargetAction(IActionTarget target, String text, int style) {
		super(text, style);
		this.target = target;
	}
	
	public TargetAction(IActionTarget target, String text, ImageDescriptor image) {
		super(text, image);
		this.target = target;
	}
}
