/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on Jul 25, 2004
 *
 */
package kenya.sole.ui.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import kenya.FileLoaderSaver;
import kenya.sole.ui.editor.KenyaPart;
import kenya.sole.ui.event.ExitListener;

import org.eclipse.swt.widgets.Display;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class EditingWindowUtilsFactory {

    private static final Set editingWindows = new HashSet();

    private EditingWindowUtilsFactory() {
    }
    
    public static EditingWindow createAndOpenEditorWindow() {
        EditingWindow window = new EditingWindow();
        openEditorWindow(window);
        return window;
    }
    
    public static EditingWindow createAndOpenEditorWindow(FileLoaderSaver fls) {
        EditingWindow window = new EditingWindow();
        KenyaPart kenya = (KenyaPart)window.getEditor(EditingWindow.KENYATABINDEX);
        kenya.setKenyaFile(fls);
        kenya.loadFromKenyaFile();
        openEditorWindow(window);
        return window;
    }
    
    private static void openEditorWindow(final EditingWindow window) {
        final Runnable editorThread = new Runnable() {

            public void run() {
                AbstractJob exitListener = new ExitListener(window);
                KenyaUI.addExitListener(exitListener);
                
                window.setBlockOnOpen(true);
                windowOpened(window);
                window.open();
                windowClosed(window);
                KenyaUI.removeExitListener(exitListener);
            }
        };
        AbstractJob start = new AbstractJob() {

            public void execute() {
                if (Display.getDefault().equals(Thread.currentThread())) {
                    editorThread.run();
                } else {
                    Display.getDefault().syncExec(editorThread);
                }
            }
        };
        JobDispatch.enqueueJob(start);
    }
    
    private synchronized static void windowOpened(EditingWindow window) {
        editingWindows.add(window);
    }
    
    private synchronized static void windowClosed(EditingWindow window) {
        editingWindows.remove(window);
        if (editingWindows.size() == 0) {
            if (Display.getCurrent().isDisposed())
                    Display.getCurrent().dispose();
            KenyaUI.exit();
        }
    }
    
    public synchronized static void closeEditingWindows() {
        Iterator it = editingWindows.iterator();
        while (it.hasNext()) {
            EditingWindow window = (EditingWindow) it.next();
            window.closeWindow();
        }
    }
    
}