/*
 * Created on 30-Oct-2004
 */
package kenya.sole.ui.editor;

import kenya.sole.ui.action.fontchange.IFontActionTarget;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

/**
 * @author Thomas Timbul
 */
public class EditorPartsFontTarget implements IFontActionTarget {
	
	private final EditorPart[] targets;
	
	public EditorPartsFontTarget(EditorPart[] targets) {
		this.targets = targets;
	}
	
	/* (non-Javadoc)
	 * @see kenya.gui.editor.menuActions.targets.IFontActionTarget#setFont(org.eclipse.swt.graphics.Font)
	 */
	public void setFont(Font font) {
		for(int i=0; i<targets.length; i++) {
			targets[i].setFont(font);
		}
	}
	
	/* (non-Javadoc)
	 * @see kenya.gui.editor.menuActions.targets.IFontActionTarget#setIOFont(org.eclipse.swt.graphics.Font)
	 */
	public void setIOFont(Font font) {
		for(int i=0; i<targets.length; i++) {
			targets[i].setSecondaryFont(font);
		}
	}
	
	/* (non-Javadoc)
	 * @see kenya.gui.editor.menuActions.targets.IFontActionTarget#getFont()
	 */
	public Font getFont() {
		for(int i=0; i<targets.length; i++) {
			if(targets[i].getFont()!=null) {
				return targets[i].getFont();
			}
		}
		return null;
	}
	
	/* (non-Javadoc)
	 * @see kenya.gui.editor.menuActions.targets.IFontActionTarget#getIOFont()
	 */
	public Font getIOFont() {
		for(int i=0; i<targets.length; i++) {
			if(targets[i].getSecondaryFont()!=null) {
				return targets[i].getSecondaryFont();
			}
		}
		return null;
	}
	
	/* (non-Javadoc)
	 * @see kenya.gui.editor.menuActions.targets.IFontActionTarget#getDisplay()
	 */
	public Display getDisplay() {
		//assume the same display for all
		return targets[0].getDisplay();

	}
	
}
