/*
 * Created on 28-Oct-2004
 */
package kenya.sole.ui.editor;


import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

import kenya.FileLoaderSaver;
import kenya.sole.ui.core.EditingWindow;
import kenya.sole.ui.editor.java.JavaExecuteButtonSelectionListener;
import kenya.sole.ui.editor.java.JavaTerminateButtonSelectionListener;
import kenya.sole.ui.event.DefaultPaintListener;
import kenya.ui.IButtonManager;
import kenya.ui.syntaxhighlighting.JavaLineStyler;
import mediator.IJavaCode;
import mediator.subscription.IJavaCodeReceiver;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * @author Thomas Timbul
 */
public class JavaPart extends EditorPart implements IJavaCodeReceiver {
	
	private volatile Button javaExecuteButton;

	private volatile Button javaEOFButton;

	private volatile Button javaTerminateButton;

	private volatile Text javaStdInText;

	private volatile StyledText javaStdOutText;

	private volatile Text javaArgsText;

	private volatile Label javaArgsLabel;

	private String[] javaArgsResult;
	
	private volatile IJavaCode javaCode;
	
	private volatile FileLoaderSaver javaFileLoaderSaver = null;
	
	private volatile String javaClassName;
	
	private volatile boolean javaRunning = false;
	
	
	public JavaPart(
				Composite parent,
				int style,
				IStatusLineManager statusLine,
				IButtonManager buttonManager,
				String dcn
			) {
		super(parent, style, statusLine, buttonManager);
		javaDefaultClassName = dcn;
	}
	
	public void init() {
		super.init();
		
		rebuildLineNumbers();
		
		Composite ioComposite = new Composite(this, SWT.BORDER);
		FormLayout fl = new FormLayout();
		ioComposite.setLayout(fl);

		javaExecuteButton = new Button(ioComposite, SWT.PUSH);
		javaExecuteButton.setText("E&xecute Java");

		javaTerminateButton = new Button(ioComposite, SWT.PUSH);
		javaTerminateButton.setText("Terminate");
		javaTerminateButton.setEnabled(false);
		javaTerminateButton.addSelectionListener(
						new JavaTerminateButtonSelectionListener(this));

		javaStdOutText = new StyledText(ioComposite, SWT.MULTI | SWT.WRAP
				| SWT.V_SCROLL | SWT.BORDER);
		javaStdOutText.setEditable(false);
		javaStdOutText.setTabs(8);

		javaStdInText = new Text(ioComposite, SWT.SINGLE | SWT.BORDER);
		javaStdInText.setEditable(true);
		javaStdInText.setEnabled(false);
		javaStdInText.setTabs(8);

		javaEOFButton = new Button(ioComposite, SWT.PUSH);
		javaEOFButton.setText("Input EOF");
		javaEOFButton.setEnabled(false);

		javaArgsLabel = new Label(ioComposite, SWT.LEFT);
		javaArgsLabel.setText("Arguments");

		javaArgsText = new Text(ioComposite, SWT.SINGLE | SWT.BORDER);

		// top left
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 0);
		fd.left = new FormAttachment(0, 1);
		fd.right = new FormAttachment(javaTerminateButton, -5);
		javaExecuteButton.setLayoutData(fd);

		// top right
		fd = new FormData();
		fd.top = new FormAttachment(0, 0);
		fd.right = new FormAttachment(100, -1);
		fd.width = 100;
		fd.bottom = new FormAttachment(javaExecuteButton, 0, SWT.BOTTOM);
		javaTerminateButton.setLayoutData(fd);

		// middle
		fd = new FormData();
		fd.top = new FormAttachment(javaExecuteButton, 5);
		fd.bottom = new FormAttachment(javaStdInText, -5);
		fd.left = new FormAttachment(0, 1);
		fd.right = new FormAttachment(100, -1);
		javaStdOutText.setLayoutData(fd);

		// bottom left
		fd = new FormData();
		fd.left = new FormAttachment(0, 1); // 0%, 0 offset
		fd.bottom = new FormAttachment(javaArgsText, -5);
		fd.right = new FormAttachment(javaEOFButton, -5);
		javaStdInText.setLayoutData(fd);

		// bottom right
		fd = new FormData();
		fd.right = new FormAttachment(100, -1); // 100%, 0 offset
		fd.bottom = new FormAttachment(javaArgsText, -5);
		fd.width = 100;
		fd.top = new FormAttachment(javaStdInText, 0, SWT.TOP);
		javaEOFButton.setLayoutData(fd);

		fd = new FormData();
		fd.left = new FormAttachment(0, 1);
		fd.bottom = new FormAttachment(100, -5);
		fd.top = new FormAttachment(javaArgsText, 5, SWT.TOP);
		javaArgsLabel.setLayoutData(fd);

		fd = new FormData();
		fd.right = new FormAttachment(100, -1);
		fd.left = new FormAttachment(javaArgsLabel, 5);
		fd.bottom = new FormAttachment(100, -5);
		javaArgsText.setLayoutData(fd);
		
		SelectionListener executeJavaButtonSelection =
				new JavaExecuteButtonSelectionListener(this);
		javaExecuteButton.addSelectionListener(executeJavaButtonSelection);
		
		this.setWeights(new int[] { 2, 1 });
		
	}
	
	private final String javaDefaultClassName;
	
	public synchronized String getJavaDefaultClassName() {
		return javaDefaultClassName;
	}
	
	
	/* (non-Javadoc)
	 * @see kenya.gui.editor.EditorPart#setSecondaryFont(org.eclipse.swt.graphics.Font)
	 */
	public void setSecondaryFont(Font font) {
		javaStdOutText.setFont(font);
		javaStdInText.setFont(font);
		
	}
	
	/*
	 *  (non-Javadoc)
	 * @see kenya.gui.editor.EditorPart#getSecondaryFont()
	 */
	public Font getSecondaryFont() {
		if(getEditorTextWidget()!=null) {
			return javaStdOutText.getFont();
		}
		return null;
	}
	
	/* (non-Javadoc)
	 * @see kenya.gui.editor.EditorPart#buildEditorContent(org.eclipse.swt.custom.SashForm)
	 */
	protected void buildEditorContent(SashForm parent) {
		super.buildEditorContent(parent);
		setLineStyler(new JavaLineStyler());
		
		editorText.setEditable(false);
		editorText.addPaintListener(new DefaultPaintListener(this));
		editorText.addKeyListener(new KeyListener() {
			
			private static final String statusText = "Switch to the Kenya tab to edit the code.";
			
			public void keyPressed(KeyEvent e) {
				safeSetStatus(statusText);
			}

			public void keyReleased(KeyEvent e) {
				safeSetStatus(statusText);
			}
		});

	}
	
	public synchronized Button getJavaExecuteButton() {
		return javaExecuteButton;
	}
	
	public synchronized Button getJavaEOFButton() {
		return javaEOFButton;
	}
	
	public synchronized Button getJavaTerminateButton() {
		return javaTerminateButton;
	}
	
	public synchronized String getJavaClassName() {
		return javaClassName;
	}
	
	public synchronized void setJavaClassName(String javaClassName) {
		this.javaClassName = javaClassName;
	}
	
	public synchronized IJavaCode getJavaCode() {
		return javaCode;
	}
	
	public synchronized void setJavaCode(IJavaCode javaCode) {
		this.javaCode = javaCode;
	}
	
	public synchronized boolean isJavaRunning() {
		return javaRunning;
	}
	
	public synchronized void setJavaRunning(boolean value) {
		javaRunning = value;
	}
	
	private void setJavaArgsResult(String[] javaArgs) {
		synchronized (lock) {
			this.javaArgsResult = javaArgs;
		}
	}
	
	private String[] getJavaArgsResult() {
		synchronized (lock) {
			return javaArgsResult;
		}
	}
	
	public String[] getJavaArgs() {
		if (Thread.currentThread().equals(
				getJavaArgsText().getDisplay().getThread())) {
			setJavaArgsResult(EditingWindow.parseIntoArgs(getJavaArgsText().getText()));
		} else {
			getJavaArgsText().getDisplay().syncExec(new Runnable() {
				
				public void run() {
					getJavaArgs();
				}
			});
		}
		return getJavaArgsResult();
	}
	
	public synchronized Text getJavaArgsText() {
		return javaArgsText;
	}
	
	public synchronized Text getJavaStdInText() {
		return javaStdInText;
	}
	
	public synchronized StyledText getJavaStdOutText() {
		return javaStdOutText;
	}
	
	public synchronized FileLoaderSaver getJavaFileLoaderSaver() {
		return javaFileLoaderSaver;
	}
	
	public synchronized void setJavaFileLoaderSaver(
			FileLoaderSaver javaFileLoaderSaver) {
		this.javaFileLoaderSaver = javaFileLoaderSaver;
	}
	
	
	public void saveJavaAs() {
		if (Thread.currentThread()
				.equals(this.getDisplay().getThread())) {
			synchronized (this) {
				Shell shell = new Shell();
				FileDialog dialog = new FileDialog(shell, SWT.SAVE);
				dialog.setFilterExtensions(new String[] { "*.java" });
				dialog.setText("Save Java translation file");
				
				String lastDir = EditingWindow.lastDir;
				
				if (lastDir == null) {
					if (getJavaFileLoaderSaver() != null) {
						lastDir = getJavaFileLoaderSaver().getDir();
						if (lastDir.length() == 0)
							lastDir = null;
					}
				}
				if (lastDir != null)
					dialog.setFilterPath(lastDir);

				if (dialog.open() != null) {
					lastDir = dialog.getFilterPath();

					File file = new File(dialog.getFilterPath(), dialog
							.getFileName());
					if (getJavaFileLoaderSaver() == null) {
						FileLoaderSaver fls = new FileLoaderSaver();
						fls.setPath(file.getAbsolutePath());
						setJavaFileLoaderSaver(fls);
					} else {
						FileLoaderSaver fls = getJavaFileLoaderSaver();
						fls.setPath(file.getAbsolutePath());
					}
					saveJava();
				}
			}
		} else {
			this.getDisplay().syncExec(new Runnable() {
				public void run() {

					saveJavaAs();
				}
			});
		}
	}
	
	public void saveJava() {
		if (Thread.currentThread()
				.equals(this.getDisplay().getThread())) {
			synchronized (this) {
				Shell shell = new Shell();
				FileLoaderSaver fls = getJavaFileLoaderSaver();
				if (fls == null || fls.getPath() == null) {
					saveJavaAs();
					return;
				} else {
					try {
						String name = fls.getName();
						if (name.indexOf('.') != -1) {
							name = name.substring(0, name.indexOf('.'));
						}
						if (getJavaCode() != null) {
							BufferedReader javaReader = new BufferedReader(
									getJavaCode().getCode(name));
							StringBuffer javaBuffer = new StringBuffer();
							int c = javaReader.read();
							while (c != -1) {
								javaBuffer.append((char) c);
								c = javaReader.read();
							}
							javaReader.close();
							fls.saveFile(javaBuffer.toString());
							safeSetStatus("Java translation saved to "
									+ fls.getPath());
						} else {
							MessageBox message = new MessageBox(shell, SWT.OK);
							message.setText("Unable to save file.");
							message
									.setMessage("Can't save translation of faulty code.");
							message.open();
							safeSetStatus("Can't save translation of faulty code.");
						}
					} catch (IOException e) {
						safeSetStatus("IOException occured when translating Kenya.");
					} catch (IllegalArgumentException e) {
						MessageBox message = new MessageBox(shell, SWT.OK);
						message.setText("Unable to save file.");
						message
								.setMessage("Can not save Java into invalid file name '"
										+ fls.getName() + "'");
						message.open();
						safeSetStatus("Can not save Java into invalid file name '"
								+ fls.getName() + "'");
					}
				}
			}
		} else {
			this.getDisplay().syncExec(new Runnable() {
				public void run() {

					saveJava();
				}
			});
		}
	}
	
}
