/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Sep 7, 2004
 *
 */
package kenya.sole.ui.editor.interpreter;

import java.util.Map;

import kenya.sole.ui.editor.InterpreterPart;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassStaticType;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.IGenericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;
import org.wellquite.kenya.stackMachine.types.interfaces.INonPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.IPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.IStringType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

/**
 * @author matthew
 *  
 */
public class InterpreterInspectorLabelProvider implements ILabelProvider {

    private static final String SINGLE_QUOTE = "'";

    private static final String SPACE = " ";

    private static final String EMPTY_STRING = "";

    private static final String STATIC_CLASS_ = "static class ";

    private static final String INSTANCE_OF_CLASS_ = "instance of class ";

    private static final String _EQUALS_ = " = ";

    private static final String DOUBLE_QUOTE = "\"";

    private static final String _ARRAY_OF_LENGTH_ = " array of length ";

    private final InterpreterPart interpreter;

    public InterpreterInspectorLabelProvider(InterpreterPart intp) {
        interpreter = intp;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof Map.Entry) {
            IStackMachineInformationProvider ismip = interpreter
                    .getBaseStackMachine();
            Map.Entry entry = (Map.Entry) element;
            String name = entry.getKey().toString();
            IVariable variable = ismip.lookupVariable(name);
            if (variable != null) {
                name = variable.getType().getName() + SPACE
                        + variable.getName();
            }
            String result = EMPTY_STRING;
            IType value = (IType) entry.getValue();
            if (value instanceof IPrimitiveType) {
                if (value instanceof IArrayType) {
                    result += _ARRAY_OF_LENGTH_
                            + ((IArrayType) value).getLength();
                } else if (value instanceof ICharType) {
                    result += SINGLE_QUOTE
                            + ((ICharType) value).getValue().charValue()
                            + SINGLE_QUOTE;
                } else {
                    result += ((IPrimitiveType) value).valueToString();
                }
            } else if (value instanceof INullType) {
                result += ((INullType) value).valueToString();
            } else if (value instanceof IGenericType) {
                result += ((IGenericType) value).valueToString();
            } else if (value instanceof INonPrimitiveType) {
                if (value instanceof IStringType) {
                    result += DOUBLE_QUOTE
                            + ((IStringType) value).valueToString()
                            + DOUBLE_QUOTE;
                } else if (value instanceof IEnumType) {
                    result += ((IEnumType) value).valueToString() + " (enum ";
                    IInterpretedEnumeration enumeration = ((IEnumType) value)
                            .getEnumeration();
                    String enumName = enumeration.getName();
                    IClass enumDetails = ismip.lookupEnum(enumName);
                    if (enumDetails != null) {
                        enumName = enumDetails.getName();
                    }
                    result += enumName + " {";
                    Object[] enumValues = enumeration.getValues();
                    for (int idx = 0; idx < enumValues.length; idx++) {
                        result += enumValues[idx].toString() + ", ";
                    }
                    result = result.substring(0, result.length() - 2);
                    result += "})";
                } else if (value instanceof IClassStaticType) {
                    result += STATIC_CLASS_;
                    String className = ((IClassStaticType) value).getValue()
                            .getName();
                    IClass classDetails = ismip.lookupClass(className);
                    if (classDetails == null) {
                        result += className;
                    } else {
                        result += classDetails.getName();
                    }
                } else if (value instanceof IClassInstanceType) {
                    result += INSTANCE_OF_CLASS_;
                    String className = ((IClassInstanceType) value).getValue()
                            .getInterpretedClass().getName();
                    IClass classDetails = ismip.lookupClass(className);
                    if (classDetails == null) {
                        result += className;
                    } else {
                        result += classDetails.getName();
                    }
                }
            }
            return name + _EQUALS_ + result;
        } else {
            return EMPTY_STRING;
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

}