/* *******************************************************************************
 *   kenya                                                             *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on 19-Aug-2004
 */
package kenya.sole.ui.editor.interpreter;

import java.util.List;

import kenya.sole.ui.editor.InterpreterPart;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.stackMachine.IStackMachineInformationProvider;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class InterpreterMouseListener extends MouseAdapter {

    private final CarrotPainter ipl;

    private final StyledText interpreterText;

    private final InterpreterPart interpreter;

    public InterpreterMouseListener(InterpreterPart intp) {
        this.ipl = intp.getCarrotPainter();
        interpreterText = intp.getEditorTextWidget();
        interpreter = intp;
    }

    public void mouseDoubleClick(MouseEvent e) {
        Point location = new Point(e.x, e.y);
        try {
            int offset = interpreterText.getOffsetAtLocation(location);
            int line = interpreterText.getLineAtOffset(offset);
            int column = offset - interpreterText.getOffsetAtLine(line);
            line++;
            column++;
            IStackMachineInformationProvider smip = interpreter
                    .getBaseStackMachine();
            if (smip != null) {
                List positions = smip
                        .getDiscreteExecutionPointMarkersFromTheAST();
                int realOffset = 0;
                ISourceCodeLocation realLoc = null;
                int delta = Integer.MAX_VALUE;
                for (int idx = 0; idx < positions.size(); idx++) {
                    ISourceCodeLocation scl = (ISourceCodeLocation) positions
                            .get(idx);
                    int thisOffset = interpreterText.getOffsetAtLine(scl
                            .getLineNumber() - 1)
                            + scl.getColumnNumber() - 1;
                    if (Math.abs(offset - thisOffset) < delta) {
                        realOffset = thisOffset;
                        realLoc = scl;
                        delta = Math.abs(offset - thisOffset);
                    }
                }
                if (ipl.isCarrotAtOffset(realOffset)) {
                    ipl.removeCarrot(realOffset, realLoc);
                } else {
                    ipl.addCarrot(realOffset, realLoc);
                }
                interpreterText.setSelection(offset);
                interpreterText.redraw();
            }
        } catch (IllegalArgumentException error) {
            interpreterText.setSelection(interpreterText.getCaretOffset());
            interpreterText.redraw();
        }
    }
}