/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 10, 2004
 *
 */
package kenya.sole.ui.editor.kenya;

import kenya.sole.ui.editor.KenyaPart;

import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class KenyaTextChangedListener implements TextChangeListener {

    private final KenyaPart kenya;

    public KenyaTextChangedListener(KenyaPart kenya) {
        this.kenya = kenya;
    }

    private void modifyText() {
        kenya.getHighlightingManager().clear();
        kenya.rebuildLineNumbers();
        kenya.reparse(true);
        if (!kenya.isModified()) {
            kenya.setModified(true);
        }
    }

    public void textChanging(TextChangingEvent event) {
        modifyText();
    }

    public void textChanged(TextChangedEvent event) {
        modifyText();
    }

    public void textSet(TextChangedEvent event) {
        modifyText();
    }

}