/*
 * Decompiled with CFR 0.152.
 */
import LTS.LTS;
import com.chatley.magicbeans.PluginManager;
import darwin.DarwinCompiler;
import darwin.DarwinException;
import darwin.FSPSource;
import darwin.NullBackEnd;
import darwin.Output;
import darwin.Reader;
import ic.doc.extension.LTSA;
import ic.doc.extension.LTSAButton;
import ic.doc.extension.LTSAPlugin;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import syntaxHighlight.DarwinTextArea;

public class DarwinPlugin
extends LTSAPlugin
implements Reader,
Output {
    private static final int s_port = 5555;
    private ServerSocket o_server_socket;
    private ServerThread o_server;
    private DarwinTextArea o_darwin_pane;
    private JScrollPane o_scroll_pane;
    private List o_toolbar_buttons;
    private Boolean o_running;
    private int fPos = -1;
    private String fSrc = "\n";
    private Vector components;
    private FSPSource o_fsp_source;

    public DarwinPlugin() {
    }

    public DarwinPlugin(LTSA p_ltsa) {
        super(p_ltsa);
    }

    public void initialise() {
        this.o_toolbar_buttons = new ArrayList();
        this.createButtons();
        this.o_running = new Boolean(false);
        this.o_darwin_pane = new DarwinTextArea();
        this.o_scroll_pane = new JScrollPane(this.o_darwin_pane);
        this.o_darwin_pane.setBorder(BorderFactory.createLoweredBevelBorder());
        PluginManager.getInstance().addBackDatedObserver((Object)this);
    }

    public String getName() {
        return "Darwin Editor";
    }

    public boolean addAsTab() {
        return true;
    }

    public Component getComponent() {
        return this.o_scroll_pane;
    }

    public boolean addToolbarButtons() {
        return true;
    }

    public synchronized List getToolbarButtons() {
        return this.o_toolbar_buttons;
    }

    public boolean addMenusToMenuBar() {
        return false;
    }

    public boolean useOwnMenuBar() {
        return false;
    }

    private synchronized void createButtons() {
        ImageIcon x_icon = new ImageIcon(this.getClass().getResource("/icon/msc.gif"));
        LTSAButton x_button = new LTSAButton(x_icon, "Compile Darwin", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DarwinPlugin.this.lts();
            }
        });
        this.o_toolbar_buttons.add(x_button);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggle_server() {
        Boolean bl = this.o_running;
        synchronized (bl) {
            if (!this.o_running.booleanValue()) {
                System.out.println("*** Starting darwin server ***");
                try {
                    this.o_server_socket = new ServerSocket(5555);
                }
                catch (IOException p_ioe) {
                    System.err.println("Failed to create new server socket." + p_ioe);
                }
                this.o_server = new ServerThread(this.o_server_socket);
                this.o_server.start();
            } else {
                System.out.println("*** Stopping darwin server ***");
                try {
                    this.o_server_socket.close();
                }
                catch (IOException p_ioe) {
                    System.err.println("Failed to close socket." + p_ioe);
                }
            }
            this.o_running = new Boolean(this.o_running == false);
        }
    }

    public void out(String str) {
        String t = this.getLTSA().getInputPane().getText();
        this.getLTSA().getInputPane().setText(String.valueOf(t) + str);
    }

    public void outln(String str) {
        this.out(String.valueOf(str) + "\n");
    }

    public void clearOutput() {
        this.getLTSA().clearInternalBuffer();
    }

    public char nextChar() {
        ++this.fPos;
        if (this.fPos < this.fSrc.length()) {
            return this.fSrc.charAt(this.fPos);
        }
        return '\u0000';
    }

    public char backChar() {
        --this.fPos;
        if (this.fPos < 0) {
            this.fPos = 0;
            return '\u0000';
        }
        return this.fSrc.charAt(this.fPos);
    }

    public Object getMarker() {
        return new Integer(this.fPos);
    }

    private void compile() {
        this.clearOutput();
        this.parse();
        this.fPos = -1;
        this.fSrc = this.o_darwin_pane.getText();
        NullBackEnd be = new NullBackEnd();
        DarwinCompiler compiler = new DarwinCompiler(this, be);
        this.components = null;
        try {
            this.components = compiler.parseComponents();
            compiler.checkSemantics(this.components);
            this.getLTSA().outln("Compiled from Darwin OK");
        }
        catch (DarwinException x) {
            int i = (Integer)x.marker;
            this.getLTSA().outln("ERROR - " + x.getMessage());
            this.o_darwin_pane.select(i, i + 1);
        }
    }

    private void parse() {
        this.clearOutput();
        this.fPos = -1;
        this.fSrc = this.o_darwin_pane.getText();
        NullBackEnd be = new NullBackEnd();
        DarwinCompiler compiler = new DarwinCompiler(this, be);
        this.components = null;
        try {
            this.components = compiler.parseComponents();
            this.getLTSA().outln("Parsed Darwin OK");
        }
        catch (DarwinException x) {
            try {
                int i = (Integer)x.marker;
                this.getLTSA().outln("ERROR - " + x.getMessage());
                this.o_darwin_pane.select(i, i + 1);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private void lts() {
        this.lts(true);
    }

    private void lts(boolean p_useFSPSource) {
        this.compile();
        if (this.components != null) {
            LTS lts = p_useFSPSource ? new LTS(this.o_fsp_source) : new LTS(null);
            this.getLTSA().clearInternalBuffer();
            this.getLTSA().appendInternalBuffer(lts.toString(this.components));
            this.getLTSA().swapto("Output");
        }
    }

    public boolean providesNewFile() {
        return true;
    }

    public void newFile() {
        this.o_darwin_pane.setText("");
    }

    public boolean providesOpenFile() {
        return true;
    }

    public void openFile(File p_file) {
        try {
            BufferedReader x_in = new BufferedReader(new FileReader(p_file));
            StringBuffer x_contents = new StringBuffer();
            String x_line = "";
            while ((x_line = x_in.readLine()) != null) {
                x_contents.append(String.valueOf(x_line) + "\n");
            }
            this.o_darwin_pane.setText(x_contents.toString());
        }
        catch (FileNotFoundException p_fnfe) {
            this.getLTSA().outln("File not found.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getFileExtension() {
        return "dw";
    }

    public boolean providesSaveFile() {
        return true;
    }

    public void saveFile(FileOutputStream p_fos) {
        PrintWriter x_pw = new PrintWriter(p_fos);
        x_pw.println(this.o_darwin_pane.getText());
        x_pw.close();
    }

    public boolean providesCut() {
        return true;
    }

    public void cut() {
        this.o_darwin_pane.cut();
    }

    public boolean providesCopy() {
        return true;
    }

    public void copy() {
        this.o_darwin_pane.copy();
    }

    public boolean providesPaste() {
        return true;
    }

    public void paste() {
        this.o_darwin_pane.paste();
    }

    public void setBigFont(boolean p_big) {
        this.o_darwin_pane.bigFont(p_big);
    }

    public void pluginAdded(FSPSource p_obj) {
        this.o_fsp_source = p_obj;
    }

    class ServerThread
    extends Thread {
        private ServerSocket o_ss;

        public ServerThread(ServerSocket p_socket) {
            this.o_ss = p_socket;
        }

        public void run() {
            try {
                try {
                    while (DarwinPlugin.this.o_running.booleanValue()) {
                        Socket x_client = this.o_ss.accept();
                        RequestHandler x_rh = new RequestHandler(x_client, this);
                        x_rh.start();
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            finally {
                try {
                    this.o_ss.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    class RequestHandler
    extends Thread {
        private ServerThread o_server;
        private Socket o_client;
        private StringBuffer o_darwin;

        RequestHandler(Socket p_client, ServerThread p_server) {
            this.o_client = p_client;
            this.o_server = p_server;
        }

        public void run() {
            StringBuffer x_darwin = new StringBuffer(10000);
            try {
                try {
                    String line;
                    InputStream is = this.o_client.getInputStream();
                    BufferedReader in = new BufferedReader(new InputStreamReader(is));
                    while ((line = in.readLine()) != null) {
                        x_darwin.append(String.valueOf(line) + "\n");
                    }
                    DarwinPlugin.this.o_darwin_pane.setText(x_darwin.toString());
                    is.close();
                    DarwinPlugin.this.lts(false);
                    DarwinPlugin.this.getLTSA().parse();
                    DarwinPlugin.this.getLTSA().compileNoClear();
                    DarwinPlugin.this.getLTSA().composeCurrentState();
                    DarwinPlugin.this.getLTSA().postCurrentState();
                }
                catch (IOException p_ioe) {
                    System.err.println(p_ioe);
                }
            }
            finally {
                try {
                    this.o_client.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

