/*
 * Decompiled with CFR 0.152.
 */
package LTS;

import LTS.Binding;
import darwin.BindDeclaration;
import darwin.BindElement;
import darwin.BindPoint;
import darwin.ComponentDeclaration;
import darwin.ConstDeclaration;
import darwin.Dimension;
import darwin.Expression;
import darwin.ExternalDeclaration;
import darwin.FSPInclusion;
import darwin.FSPSource;
import darwin.ForAllDeclaration;
import darwin.InstDeclaration;
import darwin.InterfaceDeclaration;
import darwin.MemberDeclaration;
import darwin.PortalDeclaration;
import darwin.WhenDeclaration;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class LTS {
    private FSPSource o_fsp_source;
    private Map o_instances;
    private Map o_components;
    private Map o_comp_decs;
    private Map o_par_comps;
    private Set o_bindings;
    protected PrintStream out;
    protected ByteArrayOutputStream buf = new ByteArrayOutputStream();

    public LTS(FSPSource p_fsp_source) {
        this.out = new PrintStream(this.buf);
        this.o_fsp_source = p_fsp_source;
        this.o_instances = new HashMap();
        this.o_components = new HashMap();
        this.o_comp_decs = new HashMap();
        this.o_par_comps = new HashMap();
        this.o_bindings = new HashSet();
    }

    private String typeCase(String name) {
        int len = name.length();
        if (len > 1) {
            return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        if (len == 1) {
            return name.substring(0, 1).toUpperCase();
        }
        return "";
    }

    protected String lts_dimensions_str(Enumeration dimensions) {
        String tmp = "";
        while (dimensions.hasMoreElements()) {
            Dimension dimension = (Dimension)dimensions.nextElement();
            tmp = "[";
            if (dimension.id() != null) {
                tmp = String.valueOf(tmp) + dimension.name() + ":";
            }
            tmp = String.valueOf(tmp) + dimension.low();
            if (dimension.high() != null) {
                tmp = String.valueOf(tmp) + ".." + dimension.high();
            }
            tmp = String.valueOf(tmp) + "]";
        }
        return tmp;
    }

    protected void lts_dimensions(Enumeration dimensions) {
        this.out.print(this.lts_dimensions_str(dimensions));
    }

    protected String lts_bindpoint(BindPoint bindPoint) {
        Vector<String> tmp = new Vector<String>();
        Enumeration path = bindPoint.bindPath();
        while (path.hasMoreElements()) {
            BindElement bindElement = (BindElement)path.nextElement();
            String name = bindElement.name();
            if (bindElement.isType()) continue;
            tmp.addElement(String.valueOf(bindElement.name()) + this.lts_dimensions_str(bindElement.dimensions()));
        }
        Enumeration e = tmp.elements();
        String result = "";
        while (e.hasMoreElements()) {
            result = String.valueOf(result) + (String)e.nextElement();
            if (!e.hasMoreElements()) continue;
            result = String.valueOf(result) + ".";
        }
        return result;
    }

    private Vector binding_list(Enumeration declarations) {
        Vector<Object> tmp = new Vector<Object>();
        while (declarations.hasMoreElements()) {
            ForAllDeclaration forall;
            Vector forvec;
            Object declaration = declarations.nextElement();
            if (declaration instanceof BindDeclaration) {
                BindDeclaration binding = (BindDeclaration)declaration;
                String left = this.lts_bindpoint(binding.left());
                String right = this.lts_bindpoint(binding.right());
                this.o_bindings.add(new Binding(left, right));
                if (binding.left().signature().startsWith("i") && !binding.right().signature().startsWith("i")) {
                    String stmp = left;
                    left = right;
                    right = stmp;
                }
                if (left.equals(right)) continue;
                tmp.addElement(String.valueOf(left) + "/" + right);
                continue;
            }
            if (!(declaration instanceof ForAllDeclaration) || (forvec = this.binding_list((forall = (ForAllDeclaration)declaration).declarations())).size() <= 0) continue;
            String forstr = "forall [" + forall.name() + ":" + forall.from() + ".." + forall.to() + "] {";
            tmp.addElement(forstr);
            tmp.addElement(forvec);
        }
        return tmp;
    }

    private void indent(int level) {
        int i = 0;
        while (i < level * 4) {
            this.out.print(" ");
            ++i;
        }
    }

    private void out_bindings(Vector tmp, int level) {
        if (tmp.size() > 0) {
            this.out.println();
            this.indent(level);
            if (level == 1) {
                this.out.print("/{");
            }
            boolean first = true;
            Enumeration e = tmp.elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o instanceof String) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.print(",\n");
                        this.indent(level);
                    }
                    String s = (String)o;
                    this.out.print(s);
                    continue;
                }
                if (!(o instanceof Vector)) continue;
                this.out_bindings((Vector)o, level + 1);
            }
            this.out.println();
            this.indent(level);
            this.out.print("}");
        }
    }

    private void lts_bindings(Enumeration declarations) {
        this.out_bindings(this.binding_list(declarations), 1);
    }

    protected void lts_arguments(Enumeration arguments) {
        boolean foundone = false;
        while (arguments.hasMoreElements()) {
            Expression expression = (Expression)arguments.nextElement();
            if (foundone) {
                this.out.print(",");
            } else {
                this.out.print("(");
                foundone = true;
            }
            this.out.print(expression.toString());
        }
        if (foundone) {
            this.out.print(")");
        }
    }

    private void add_instances(String p_name) {
        ComponentDeclaration x_cd = (ComponentDeclaration)this.o_comp_decs.get(this.typeOf(p_name));
        if (this.hasInstances(x_cd.declarations())) {
            Enumeration e = x_cd.declarations();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof InstDeclaration)) continue;
                InstDeclaration x_id = (InstDeclaration)o;
                this.o_instances.put(String.valueOf(p_name) + "." + x_id.name(), x_id.type().name());
                this.add_instances(String.valueOf(p_name) + "." + x_id.name());
            }
        }
    }

    protected void lts_instances(Enumeration declarations) {
        boolean foundone = false;
        while (declarations.hasMoreElements()) {
            ForAllDeclaration forall;
            Object declaration = declarations.nextElement();
            if (declaration instanceof InstDeclaration) {
                InstDeclaration inst = (InstDeclaration)declaration;
                this.o_instances.put(inst.name(), inst.type().name());
                this.add_instances(inst.name());
                if (foundone) {
                    this.out.print(" || ");
                } else {
                    this.out.print("(");
                    foundone = true;
                }
                boolean overloaded = inst.name().equals(inst.type().name());
                if (!overloaded) {
                    this.out.print(inst.name());
                }
                this.lts_dimensions(inst.dimensions());
                if (!overloaded || inst.numDimensions() != 0) {
                    this.out.print(":");
                }
                this.out.print(inst.type().name());
                this.lts_arguments(inst.arguments());
                continue;
            }
            if (!(declaration instanceof ForAllDeclaration) || !this.hasInstances((forall = (ForAllDeclaration)declaration).declarations())) continue;
            if (foundone) {
                this.out.print(" || ");
            } else {
                this.out.print(" = (");
                foundone = true;
            }
            this.out.print("forall [" + forall.name() + ":" + forall.from() + ".." + forall.to() + "]");
            this.lts_instances(forall.declarations());
        }
        if (foundone) {
            this.out.print(")");
        }
    }

    protected void lts_constants(Enumeration declarations) {
        boolean foundone = false;
        while (declarations.hasMoreElements()) {
            Object declaration = declarations.nextElement();
            if (!(declaration instanceof ConstDeclaration)) continue;
            ConstDeclaration constant = (ConstDeclaration)declaration;
            if (foundone) {
                this.out.print(", ");
            } else {
                this.out.print(" (");
                foundone = true;
            }
            this.out.print(String.valueOf(constant.name()) + "=" + constant.expression());
        }
        if (foundone) {
            this.out.print(")");
        }
    }

    protected void lts_interface(InterfaceDeclaration iface) {
        int n = iface.numMemberDeclarations();
        if (n > 0) {
            this.out.print("set " + iface.name() + " = {");
            int i = 0;
            while (i < n - 1) {
                MemberDeclaration mb = iface.memberDeclaration(i);
                this.out.print(String.valueOf(mb.name()) + ", ");
                ++i;
            }
            MemberDeclaration mbe = iface.memberDeclaration(n - 1);
            this.out.print(mbe.name());
            this.out.println(" }");
        }
    }

    protected boolean lts_members(boolean foundone, String prefix, Enumeration declarations) {
        while (declarations.hasMoreElements()) {
            String name;
            Object declaration = declarations.nextElement();
            if (!(declaration instanceof MemberDeclaration)) continue;
            MemberDeclaration member = (MemberDeclaration)declaration;
            InterfaceDeclaration interFace = member.interFace();
            String string = name = prefix.length() > 0 ? String.valueOf(prefix) + "." + member.name() : member.name();
            if (interFace != null) {
                foundone = this.lts_members(foundone, name, interFace.memberDeclarations());
                continue;
            }
            if (foundone) {
                this.out.print(", ");
            } else {
                this.out.println();
                this.out.print("    @ {");
                foundone = true;
            }
            this.out.print(name);
        }
        return foundone;
    }

    protected void lts_portals(char prefix, Enumeration declarations) {
        boolean foundone = false;
        while (declarations.hasMoreElements()) {
            Object declaration = declarations.nextElement();
            if (!(declaration instanceof PortalDeclaration)) continue;
            PortalDeclaration portal = (PortalDeclaration)declaration;
            InterfaceDeclaration interFace = portal.interFace();
            if (interFace != null && portal.name().equals(interFace.name())) {
                foundone = this.lts_members(foundone, "", interFace.memberDeclarations());
                continue;
            }
            if (foundone) {
                this.out.print(", ");
            } else {
                this.out.println();
                this.indent(1);
                this.out.print(String.valueOf(prefix) + " {");
                foundone = true;
            }
            this.out.print(portal.name());
            this.lts_dimensions(portal.dimensions());
        }
        if (foundone) {
            this.out.print("}");
        }
    }

    private boolean hasInstances(Enumeration declarations) {
        while (declarations.hasMoreElements()) {
            WhenDeclaration when;
            ForAllDeclaration forall;
            Object declaration = declarations.nextElement();
            if (declaration instanceof InstDeclaration) {
                return true;
            }
            if (!(declaration instanceof ForAllDeclaration ? this.hasInstances((forall = (ForAllDeclaration)declaration).declarations()) : declaration instanceof WhenDeclaration && this.hasInstances((when = (WhenDeclaration)declaration).declarations()))) continue;
            return true;
        }
        return false;
    }

    private void build_component_map(Enumeration p_declarations) {
        while (p_declarations.hasMoreElements()) {
            Object x_declaration = p_declarations.nextElement();
            if (!(x_declaration instanceof ComponentDeclaration)) continue;
            ComponentDeclaration x_comp = (ComponentDeclaration)x_declaration;
            Map x_port_map = this.build_port_map(x_comp.declarations());
            this.o_components.put(x_comp.name(), x_port_map);
            this.o_comp_decs.put(x_comp.name(), x_comp);
        }
    }

    protected void lts_components(Enumeration declarations) {
        while (declarations.hasMoreElements()) {
            Object declaration = declarations.nextElement();
            if (declaration instanceof ComponentDeclaration) {
                ComponentDeclaration comp = (ComponentDeclaration)declaration;
                if (!this.hasInstances(comp.declarations())) continue;
                this.out.println();
                PrintStream x_out = this.out;
                ByteArrayOutputStream x_baos = new ByteArrayOutputStream();
                this.out = new PrintStream(x_baos);
                this.out.print("||" + comp.name());
                this.lts_constants(comp.declarations());
                this.out.println(" = ");
                this.indent(1);
                this.lts_instances(comp.declarations());
                this.lts_bindings(comp.declarations());
                this.lts_portals('@', comp.declarations());
                this.out.println(".");
                this.out.flush();
                this.o_par_comps.put(comp.name(), x_baos.toString());
                this.out = x_out;
                continue;
            }
            if (declaration instanceof ExternalDeclaration) {
                ExternalDeclaration ext = (ExternalDeclaration)declaration;
                if (ext.name().equals("lts")) {
                    this.out.println();
                }
                this.out.println(ext.text());
                continue;
            }
            if (declaration instanceof ConstDeclaration) {
                ConstDeclaration cnst = (ConstDeclaration)declaration;
                this.out.println("const " + cnst.name() + " = " + cnst.expression());
                continue;
            }
            if (declaration instanceof FSPInclusion) {
                FSPInclusion x_fsp = (FSPInclusion)declaration;
                this.out.print(x_fsp.text());
                continue;
            }
            if (!(declaration instanceof InterfaceDeclaration)) continue;
            InterfaceDeclaration iface = (InterfaceDeclaration)declaration;
            this.lts_interface(iface);
        }
    }

    private void expand_bindings() {
        HashSet x_tmp = new HashSet();
        Iterator i = this.o_bindings.iterator();
        while (i.hasNext()) {
            x_tmp.addAll(this.expand_binding((Binding)i.next()));
        }
        this.o_bindings.addAll(x_tmp);
    }

    private Set expand_binding(Binding p_bind) {
        HashSet<Binding> x_ret = new HashSet<Binding>();
        Set x_lhs = this.expand_end(p_bind.fromInst, p_bind.fromPort, new HashSet());
        Set x_rhs = this.expand_end(p_bind.toInst, p_bind.toPort, new HashSet());
        x_lhs.add(String.valueOf(p_bind.fromInst) + "." + p_bind.fromPort);
        x_rhs.add(String.valueOf(p_bind.toInst) + "." + p_bind.toPort);
        for (String left : x_lhs) {
            Iterator j = x_rhs.iterator();
            while (j.hasNext()) {
                Binding b = new Binding(left, (String)j.next());
                x_ret.add(b);
            }
        }
        return x_ret;
    }

    private Set expand_end(String p_inst, String p_port, Set p_ret) {
        String x_type = this.typeOf(p_inst);
        ComponentDeclaration x_comp_dec = (ComponentDeclaration)this.o_comp_decs.get(x_type);
        if (x_comp_dec == null) {
            return p_ret;
        }
        Enumeration e = x_comp_dec.declarations();
        while (e.hasMoreElements()) {
            String x_new;
            Object x_dec = e.nextElement();
            if (!(x_dec instanceof BindDeclaration)) continue;
            BindDeclaration x_bd = (BindDeclaration)x_dec;
            String left = this.lts_bindpoint(x_bd.left());
            String right = this.lts_bindpoint(x_bd.right());
            Binding x_bind = new Binding(left, right);
            if (x_bind.fromInst == null && x_bind.fromPort.equals(p_port)) {
                x_new = String.valueOf(p_inst) + "." + x_bind.toInst + "." + x_bind.toPort;
                p_ret.add(x_new);
                this.expand_end(String.valueOf(p_inst) + "." + x_bind.toInst, x_bind.toPort, p_ret);
            }
            if (x_bind.toInst != null || !x_bind.toPort.equals(p_port)) continue;
            x_new = String.valueOf(p_inst) + "." + x_bind.fromInst + "." + x_bind.fromPort;
            p_ret.add(x_new);
            this.expand_end(String.valueOf(p_inst) + "." + x_bind.fromInst, x_bind.fromPort, p_ret);
        }
        return p_ret;
    }

    void expand_outwards() {
        for (String x_classname : this.o_comp_decs.keySet()) {
            ComponentDeclaration x_comp_dec = (ComponentDeclaration)this.o_comp_decs.get(x_classname);
            if (x_comp_dec == null) continue;
            Enumeration e = x_comp_dec.declarations();
            while (e.hasMoreElements()) {
                Object x_dec = e.nextElement();
                if (!(x_dec instanceof BindDeclaration)) continue;
                BindDeclaration x_bd = (BindDeclaration)x_dec;
                String left = this.lts_bindpoint(x_bd.left());
                String right = this.lts_bindpoint(x_bd.right());
                Binding x_bind = new Binding(left, right);
                if (x_bind.fromInst == null || x_bind.toInst == null) continue;
                for (String x_inst : this.o_instances.keySet()) {
                    if (!this.typeOf(x_inst).equals(x_classname)) continue;
                    Binding b = new Binding(String.valueOf(x_inst) + "." + x_bind.fromInst + "." + x_bind.fromPort, String.valueOf(x_inst) + "." + x_bind.toInst + "." + x_bind.toPort);
                    this.o_bindings.add(b);
                }
            }
        }
    }

    private Map build_port_map(Enumeration p_declarations) {
        HashMap<String, InterfaceDeclaration> x_port_map = new HashMap<String, InterfaceDeclaration>();
        while (p_declarations.hasMoreElements()) {
            Object x_declaration = p_declarations.nextElement();
            if (!(x_declaration instanceof PortalDeclaration)) continue;
            PortalDeclaration x_portal = (PortalDeclaration)x_declaration;
            InterfaceDeclaration x_interFace = x_portal.interFace();
            x_port_map.put(x_portal.name(), x_interFace);
        }
        return x_port_map;
    }

    private void print_parcomps() {
        for (String x_val : this.o_par_comps.values()) {
            if (x_val == null) continue;
            this.out.println("");
            this.out.println(x_val);
        }
    }

    private void generateFSP() {
        HashMap x_bigmap = new HashMap();
        for (String x_inst : this.o_instances.keySet()) {
            Set x_comp_msgs = this.o_fsp_source.getMessageLabels(this.typeOf(x_inst));
            if (x_comp_msgs == null) continue;
            Map x_portmap = (Map)this.o_components.get(this.typeOf(x_inst));
            HashMap x_translations = new HashMap();
            Iterator j = x_comp_msgs.iterator();
            while (j.hasNext()) {
                HashMap<String, String> x_smallmap = new HashMap<String, String>();
                String x_msc_action = (String)j.next();
                int p = x_msc_action.indexOf(",", x_msc_action.indexOf(",") + 1);
                String x_message = x_msc_action.substring(p + 1, x_msc_action.length());
                Binding x_bind = new Binding(x_msc_action.substring(0, p));
                if (!x_bind.fromInst.equals(x_inst) && !x_bind.toInst.equals(x_inst)) continue;
                ArrayList<Binding> x_bindings = new ArrayList<Binding>();
                for (Binding b : this.o_bindings) {
                    if (!x_bind.equals(b)) continue;
                    x_bindings.add(b);
                }
                String x_port = null;
                for (Binding b : x_bindings) {
                    if (b.fromInst.equals(x_inst)) {
                        x_port = b.fromPort;
                    } else {
                        if (!b.toInst.equals(x_inst)) continue;
                        x_port = b.toPort;
                    }
                    boolean x_found = false;
                    InterfaceDeclaration id = (InterfaceDeclaration)x_portmap.get(x_port);
                    if (id != null) {
                        Enumeration e = id.memberDeclarations();
                        while (e.hasMoreElements()) {
                            MemberDeclaration a = (MemberDeclaration)e.nextElement();
                            if (!a.name().equals(x_message)) continue;
                            x_found = true;
                            break;
                        }
                    }
                    if (!x_found || x_smallmap.get(x_inst) != null) continue;
                    x_smallmap.put(x_inst, String.valueOf(x_port) + "." + x_message);
                }
                if (x_smallmap.isEmpty()) continue;
                if (x_bigmap.get(x_msc_action) == null) {
                    x_bigmap.put(x_msc_action, x_smallmap);
                    continue;
                }
                Map m = (Map)x_bigmap.get(x_msc_action);
                m.putAll(x_smallmap);
            }
        }
        System.out.println("Map contents: ");
        for (String a : x_bigmap.keySet()) {
            System.out.println(String.valueOf(a) + " -> ");
            Map m = (Map)x_bigmap.get(a);
            for (String b : m.keySet()) {
                System.out.println("\t" + b + " -> " + m.get(b));
            }
        }
        for (String x_comp : this.o_components.keySet()) {
            String x_fsp = this.o_fsp_source.getFSPforComponent(x_comp, x_bigmap);
            if (x_fsp != null && !x_fsp.trim().equals("")) {
                this.out.println(x_fsp);
                continue;
            }
            if (this.o_par_comps.get(x_comp) == null) continue;
            this.out.println(this.o_par_comps.get(x_comp));
        }
    }

    private String typeOf(String p_inst) {
        String x_type = (String)this.o_instances.get(p_inst);
        if (x_type != null) {
            x_type = x_type.trim();
        }
        return x_type;
    }

    public String toString(Vector list) {
        this.buf.reset();
        this.build_component_map(list.elements());
        this.lts_components(list.elements());
        this.expand_outwards();
        this.expand_bindings();
        if (this.o_fsp_source != null) {
            this.generateFSP();
        } else {
            this.print_parcomps();
        }
        this.out.flush();
        return this.buf.toString();
    }
}

