/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.Diagnostics;
import darwin.Dimension;
import darwin.InstDeclaration;
import darwin.InterfaceDeclaration;
import darwin.MemberDeclaration;
import darwin.PortalDeclaration;
import darwin.SemanticAnalyser;
import darwin.Symbol;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BindElement {
    private Symbol bindId;
    private Vector dimensions;
    private Object bindObject;
    private String signature;
    private boolean isType = false;
    private static final String MSG1 = "unknown instance/portal identifier";
    private static final String MSG2 = "portal id expected after instance";
    private static final String MSG3 = "instance has wrong number of dimensions";
    private static final String MSG4 = "portal cannot be selected further";
    private static final String MSG5 = "portal has wrong number of dimensions";
    private static final String MSG6 = "interface member cannot be selected further";
    private static final String MSG7 = "interface member has wrong number of dimensions";
    private static final String MSG8 = "identifier is not an instance or portal or interface member";

    public BindElement(Symbol bindId, Vector dimensions) {
        this.bindId = bindId;
        this.dimensions = dimensions;
        this.bindObject = null;
    }

    public Hashtable semantics(SemanticAnalyser analyser, Hashtable scope, boolean moreElements) {
        this.signature = "";
        this.bindObject = scope.get("$" + this.bindId.string);
        if (this.bindObject == null) {
            this.bindObject = scope.get(this.bindId.string);
        }
        analyser.fatal(this.bindObject == null, MSG1, this.bindId);
        if (this.bindObject instanceof InstDeclaration) {
            InstDeclaration inst = (InstDeclaration)this.bindObject;
            analyser.fatal(!moreElements, MSG2, this.bindId);
            analyser.semantics(this.dimensions());
            analyser.fatal(this.numDimensions() != inst.numDimensions(), MSG3, this.bindId);
            this.signature = "i";
            this.isType = this.name().equals(inst.type().name());
            return inst.component().identifiers();
        }
        if (this.bindObject instanceof PortalDeclaration) {
            PortalDeclaration portal = (PortalDeclaration)this.bindObject;
            InterfaceDeclaration interFace = portal.interFace();
            analyser.fatal(interFace == null && moreElements, MSG4, this.bindId);
            analyser.fatal(this.numDimensions() != portal.numDimensions(), MSG5, this.bindId);
            this.signature = portal.signature();
            if (interFace != null) {
                this.isType = this.name().equals(interFace.name());
                return interFace.members();
            }
        } else if (this.bindObject instanceof MemberDeclaration) {
            MemberDeclaration member = (MemberDeclaration)this.bindObject;
            InterfaceDeclaration interFace = member.interFace();
            analyser.fatal(interFace == null && moreElements, MSG6, this.bindId);
            analyser.fatal(this.numDimensions() != member.numDimensions(), MSG7, this.bindId);
            if (interFace != null) {
                return interFace.members();
            }
        } else {
            Diagnostics.fatal(MSG8, this.bindId);
        }
        return scope;
    }

    public Symbol id() {
        return this.bindId;
    }

    public String name() {
        return this.bindId.toString();
    }

    public boolean isArray() {
        return this.numDimensions() > 0;
    }

    public int numDimensions() {
        return this.dimensions.size();
    }

    public Dimension dimension(int n) {
        return (Dimension)this.dimensions.elementAt(n);
    }

    public Enumeration dimensions() {
        return this.dimensions.elements();
    }

    public Object bindObject() {
        return this.bindObject;
    }

    public String signature() {
        return this.signature;
    }

    public boolean isType() {
        return this.isType;
    }
}

