/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.BindElement;
import darwin.PortalDeclaration;
import darwin.SemanticAnalyser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BindPoint {
    private Vector bindPath;
    private boolean dyn;
    private String signature;

    public BindPoint(Vector bindPath, boolean dyn) {
        this.bindPath = bindPath;
        this.dyn = dyn;
        this.signature = "";
    }

    public void semantics(SemanticAnalyser analyser) {
        this.signature = "";
        Hashtable scope = analyser.currScope();
        Enumeration list = this.bindPath.elements();
        while (list.hasMoreElements()) {
            BindElement bindElement = (BindElement)list.nextElement();
            scope = bindElement.semantics(analyser, scope, list.hasMoreElements());
            this.signature = String.valueOf(this.signature) + bindElement.signature();
        }
    }

    public void setSignature(String signature) {
        PortalDeclaration portalDeclaration = (PortalDeclaration)this.bindElement(signature.length() - 1).bindObject();
        portalDeclaration.setSignature(signature);
    }

    public boolean dyn() {
        return this.dyn;
    }

    public int sizeBindPath() {
        return this.bindPath.size();
    }

    public BindElement bindElement(int n) {
        return (BindElement)this.bindPath.elementAt(n);
    }

    public Enumeration bindPath() {
        return this.bindPath.elements();
    }

    public String signature() {
        return this.signature;
    }
}

