/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.ConstDeclaration;
import darwin.Declaration;
import darwin.Diagnostics;
import darwin.Dimension;
import darwin.ForAllDeclaration;
import darwin.FormalParameter;
import darwin.InstDeclaration;
import darwin.Symbol;
import java.util.Hashtable;
import java.util.Stack;

public class IdentifierTable {
    private Stack idStack = new Stack();
    private static final String MSG1 = "identifier not a local const, forall,index or parameter of scalar type";

    public IdentifierTable() {
        this.newScope();
    }

    protected void newScope() {
        this.idStack.push(new Hashtable());
    }

    protected Hashtable currScope() {
        return (Hashtable)this.idStack.peek();
    }

    protected Hashtable closeScope() {
        return (Hashtable)this.idStack.pop();
    }

    protected Object getLocal(Symbol id) {
        Hashtable local = (Hashtable)this.idStack.peek();
        return local.get(id.string);
    }

    protected Object getLocal(Symbol id, int kind) {
        Hashtable local = (Hashtable)this.idStack.peek();
        switch (kind) {
            case 12: {
                return local.get("$" + id.string);
            }
        }
        return local.get(id.string);
    }

    protected void putLocal(Symbol id, Object object, String msg) {
        Hashtable local = (Hashtable)this.idStack.peek();
        if (local.containsKey(id.string)) {
            Diagnostics.fatal(msg, id);
        }
        if (object instanceof InstDeclaration) {
            local.put("$" + id.string, object);
        } else {
            local.put(id.string, object);
        }
    }

    protected void putLocal(Symbol id, Object object) {
        this.putLocal(id, object, "Identifier already defined");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getGlobal(Symbol id, int kind, String msg) {
        int k = this.idStack.size() - 1;
        while (k >= 0) {
            Hashtable table = (Hashtable)this.idStack.elementAt(k);
            Object object = table.get(id.string);
            if (object != null) {
                if (object instanceof Declaration) {
                    Declaration declaration = (Declaration)object;
                    if (declaration.kind() == kind) return object;
                    Diagnostics.fatal("identifier of wrong kind", id);
                } else {
                    Diagnostics.fatal("identifier of wrong kind", id);
                }
            }
            --k;
        }
        Diagnostics.fatal(msg, id);
        return null;
    }

    protected Object getGlobal(Symbol id, int kind) {
        int k = this.idStack.size() - 1;
        while (k >= 0) {
            Hashtable table = (Hashtable)this.idStack.elementAt(k);
            Object object = table.get(id.string);
            if (object != null) {
                if (object instanceof Declaration) {
                    Declaration declaration = (Declaration)object;
                    if (declaration.kind() != kind) {
                        return null;
                    }
                    return object;
                }
                return null;
            }
            --k;
        }
        return null;
    }

    protected void UnknownPutLocal(Symbol id, Object object, String msg) {
        int k = this.idStack.size() - 1;
        while (k >= 0) {
            Hashtable table = (Hashtable)this.idStack.elementAt(k);
            if (table.containsKey(id.string)) {
                Diagnostics.fatal(msg, id);
            }
            --k;
        }
        this.putLocal(id, object);
    }

    protected int scalarGetTypeId(Symbol scalarTypeId, String msg) {
        if (scalarTypeId.isScalarType()) {
            return scalarTypeId.kind;
        }
        Diagnostics.fatal(msg, scalarTypeId);
        return 103;
    }

    protected int scalarGetType(Symbol scalarId) {
        Object object = this.getLocal(scalarId);
        if (object != null) {
            if (object instanceof FormalParameter) {
                FormalParameter f = (FormalParameter)object;
                return f.parameterTypeId().kind;
            }
            if (object instanceof ConstDeclaration) {
                ConstDeclaration c = (ConstDeclaration)object;
                return c.type().kind;
            }
            if (object instanceof ForAllDeclaration) {
                return 10;
            }
            if (object instanceof Dimension) {
                return 10;
            }
            Diagnostics.fatal(MSG1, scalarId);
        } else {
            if (scalarId.kind == 102 || scalarId.kind == 101) {
                return scalarId.kind;
            }
            object = this.getGlobal(scalarId, 10);
            if (object != null && object instanceof ConstDeclaration) {
                ConstDeclaration c = (ConstDeclaration)object;
                return c.type().kind;
            }
            Diagnostics.fatal(MSG1, scalarId);
        }
        return 0;
    }
}

