/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.Diagnostics;
import darwin.Reader;
import darwin.Symbol;
import java.util.Vector;

public class Lex {
    private Reader darwinInput;
    private Symbol symbol;
    private char ch;
    private boolean eoln;

    public Lex(Reader darwinInput) {
        this.darwinInput = darwinInput;
        this.symbol = new Symbol();
    }

    private void error(String errorMsg) {
        Diagnostics.fatal(errorMsg, this.darwinInput.getMarker());
    }

    private void next_ch() {
        this.ch = this.darwinInput.nextChar();
        this.eoln = this.ch == '\n' || this.ch == '\r';
    }

    private void back_ch() {
        this.ch = this.darwinInput.backChar();
        this.eoln = this.ch == '\n' || this.ch == '\r';
    }

    private void in_comment() {
        if (this.ch == '/') {
            do {
                this.next_ch();
            } while (!this.eoln);
        } else if (this.ch == '%') {
            StringBuffer buf = new StringBuffer();
            while (true) {
                if (this.ch != '%') {
                    buf.append(this.ch);
                    this.next_ch();
                    continue;
                }
                this.next_ch();
                if (this.ch == '/') break;
            }
            this.symbol.string = buf.toString();
            this.symbol.kind = 70;
        } else {
            while (true) {
                this.next_ch();
                if (this.ch != '*') continue;
                this.next_ch();
                if (this.ch == '/') break;
            }
            this.next_ch();
        }
    }

    private boolean isodigit(char ch) {
        return ch >= '0' && ch <= '7';
    }

    private boolean isxdigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    private boolean isbase(char ch, int base) {
        switch (base) {
            case 10: {
                return Character.isDigit(ch);
            }
            case 16: {
                return this.isxdigit(ch);
            }
            case 8: {
                return this.isodigit(ch);
            }
        }
        return true;
    }

    private void in_number() {
        long intValue = 0L;
        double doubleValue = 0.0;
        int digit = 0;
        int base = 10;
        this.symbol.kind = 21;
        if (this.ch == '0') {
            this.next_ch();
            if (this.ch == 'x' || this.ch == 'X') {
                base = 16;
                this.next_ch();
            } else {
                base = 8;
            }
        } else {
            base = 10;
        }
        StringBuffer realBuf = new StringBuffer();
        while (this.isbase(this.ch, base)) {
            realBuf.append(this.ch);
            switch (base) {
                case 8: 
                case 10: {
                    digit = this.ch - 48;
                    break;
                }
                case 16: {
                    digit = Character.isUpperCase(this.ch) ? this.ch - 65 : (Character.isLowerCase(this.ch) ? this.ch - 97 : this.ch - 48);
                }
            }
            if (intValue * (long)base > (long)(Integer.MAX_VALUE - digit)) {
                this.error("Integer Overflow");
                intValue = Integer.MAX_VALUE;
                break;
            }
            intValue = intValue * (long)base + (long)digit;
            this.next_ch();
        }
        if (base == 10) {
            boolean numIsDouble = false;
            if (this.ch == '.') {
                this.next_ch();
                if (Character.isDigit(this.ch)) {
                    numIsDouble = true;
                    realBuf.append('.');
                    do {
                        realBuf.append(this.ch);
                        this.next_ch();
                    } while (Character.isDigit(this.ch));
                } else {
                    this.back_ch();
                }
            }
            if (this.ch == 'e' || this.ch == 'E') {
                numIsDouble = true;
                realBuf.append(this.ch);
                this.next_ch();
                if (this.ch == '+' || this.ch == '-') {
                    realBuf.append(this.ch);
                    this.next_ch();
                }
                if (Character.isDigit(this.ch)) {
                    while (Character.isDigit(this.ch)) {
                        realBuf.append(this.ch);
                        this.next_ch();
                    }
                } else {
                    this.error("exponent expected after e or E");
                }
            }
            if (numIsDouble) {
                try {
                    this.symbol.doubleValue = Double.valueOf(realBuf.toString());
                    this.symbol.kind = 22;
                }
                catch (NumberFormatException msg) {
                    this.error("Bad double value. " + msg);
                }
            }
        } else if (this.ch == 'U' || this.ch == 'u' || this.ch == 'L' || this.ch == 'U') {
            this.next_ch();
        }
        this.symbol.longValue = intValue;
        this.back_ch();
    }

    private void in_escseq() {
        while (this.ch == '\\') {
            this.next_ch();
            switch (this.ch) {
                case 'a': {
                    this.ch = (char)97;
                    break;
                }
                case 'b': {
                    this.ch = (char)8;
                    break;
                }
                case 'f': {
                    this.ch = (char)12;
                    break;
                }
                case 'n': {
                    this.ch = (char)10;
                    break;
                }
                case 'r': {
                    this.ch = (char)13;
                    break;
                }
                case 't': {
                    this.ch = (char)9;
                    break;
                }
                case 'v': {
                    break;
                }
                case '\\': {
                    this.ch = (char)92;
                    break;
                }
                case '\'': {
                    this.ch = (char)39;
                    break;
                }
                case '\"': {
                    this.ch = (char)34;
                    break;
                }
                case '?': {
                    this.ch = (char)63;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int n = this.ch - 48;
                    this.next_ch();
                    if (this.isodigit(this.ch)) {
                        n = n * 8 + this.ch - 48;
                        this.next_ch();
                        if (this.isodigit(this.ch)) {
                            n = n * 8 + this.ch - 48;
                        }
                    }
                    this.ch = (char)n;
                    break;
                }
                case 'X': 
                case 'x': {
                    int n = 0;
                    this.next_ch();
                    if (!this.isxdigit(this.ch)) {
                        this.error("hex digit expected after \\x");
                    } else {
                        int hex_digits = 0;
                        while (this.isxdigit(this.ch) && hex_digits < 2) {
                            ++hex_digits;
                            n = Character.isDigit(this.ch) ? n * 16 + this.ch - 48 : (Character.isUpperCase(this.ch) ? n * 16 + this.ch - 65 : n * 16 + this.ch - 97);
                            this.next_ch();
                        }
                    }
                    this.ch = (char)n;
                }
            }
        }
    }

    private void in_string() {
        boolean more;
        char quote = this.ch;
        boolean single = quote == '\'';
        StringBuffer buf = new StringBuffer();
        do {
            this.next_ch();
            if (this.ch == '\\') {
                this.in_escseq();
            }
            if (!(more = this.ch != quote && !this.eoln)) continue;
            buf.append(this.ch);
        } while (more);
        this.symbol.string = buf.toString();
        if (single) {
            if (this.ch != quote) {
                this.error("No closing character for char constant");
            }
            if (buf.length() != 1) {
                this.error("Char constant not 1 char long");
            }
            this.symbol.kind = 23;
        } else {
            if (this.eoln) {
                this.error("No closing character for string constant");
            }
            this.symbol.kind = 23;
        }
    }

    private void in_identifier() {
        StringBuffer buf = new StringBuffer();
        do {
            buf.append(this.ch);
            this.next_ch();
        } while (Character.isLetterOrDigit(this.ch) || this.ch == '_');
        this.symbol.string = buf.toString();
        Object kind = Symbol.keyword.get(this.symbol.string);
        this.symbol.kind = kind == null ? 20 : (Integer)kind;
        this.back_ch();
    }

    protected String in_charSeq(String closeChars) {
        StringBuffer buf = new StringBuffer();
        this.next_ch();
        while (closeChars.lastIndexOf(this.ch) == -1) {
            if (this.ch == '\\') {
                this.next_ch();
                if (closeChars.lastIndexOf(this.ch) == -1) {
                    buf.append('\\');
                }
            }
            buf.append(this.ch);
            this.next_ch();
        }
        return buf.toString();
    }

    protected Vector in_stringArguments() {
        Vector<String> sequences = new Vector<String>();
        while (this.ch != ')') {
            sequences.addElement(this.in_charSeq(",)"));
        }
        return sequences;
    }

    protected Symbol in_sym() {
        this.next_ch();
        this.symbol = new Symbol();
        boolean DoOnce = true;
        while (DoOnce) {
            DoOnce = false;
            this.symbol.marker = this.darwinInput.getMarker();
            switch (this.ch) {
                case '\u0000': {
                    this.symbol.kind = 99;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    while (Character.isWhitespace(this.ch)) {
                        this.next_ch();
                    }
                    DoOnce = true;
                    break;
                }
                case '/': {
                    this.next_ch();
                    if (this.ch == '%') {
                        this.in_comment();
                        break;
                    }
                    if (this.ch == '/' || this.ch == '*') {
                        this.in_comment();
                        DoOnce = true;
                        break;
                    }
                    this.symbol.kind = 33;
                    this.back_ch();
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.in_identifier();
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.in_number();
                    break;
                }
                case '\"': 
                case '\'': {
                    this.in_string();
                    break;
                }
                case '+': {
                    this.symbol.kind = 30;
                    break;
                }
                case '*': {
                    this.symbol.kind = 32;
                    break;
                }
                case '%': {
                    this.symbol.kind = 34;
                    break;
                }
                case '^': {
                    this.symbol.kind = 35;
                    break;
                }
                case '~': {
                    this.symbol.kind = 36;
                    break;
                }
                case '?': {
                    this.symbol.kind = 37;
                    break;
                }
                case ':': {
                    this.symbol.kind = 38;
                    break;
                }
                case ',': {
                    this.symbol.kind = 39;
                    break;
                }
                case '(': {
                    this.symbol.kind = 53;
                    break;
                }
                case ')': {
                    this.symbol.kind = 54;
                    break;
                }
                case '{': {
                    this.symbol.kind = 60;
                    break;
                }
                case '}': {
                    this.symbol.kind = 61;
                    break;
                }
                case '[': {
                    this.symbol.kind = 62;
                    break;
                }
                case ']': {
                    this.symbol.kind = 63;
                    break;
                }
                case ';': {
                    this.symbol.kind = 65;
                    break;
                }
                case '@': {
                    this.symbol.kind = 68;
                    break;
                }
                case '|': {
                    this.next_ch();
                    if (this.ch == '|') {
                        this.symbol.kind = 40;
                        break;
                    }
                    this.symbol.kind = 41;
                    this.back_ch();
                    break;
                }
                case '&': {
                    this.next_ch();
                    if (this.ch == '&') {
                        this.symbol.kind = 42;
                        break;
                    }
                    this.symbol.kind = 43;
                    this.back_ch();
                    break;
                }
                case '!': {
                    this.next_ch();
                    if (this.ch == '=') {
                        this.symbol.kind = 44;
                        break;
                    }
                    this.symbol.kind = 45;
                    this.back_ch();
                    break;
                }
                case '<': {
                    this.next_ch();
                    if (this.ch == '=') {
                        this.symbol.kind = 46;
                        break;
                    }
                    if (this.ch == '<') {
                        this.symbol.kind = 48;
                        break;
                    }
                    this.symbol.kind = 47;
                    this.back_ch();
                    break;
                }
                case '>': {
                    this.next_ch();
                    if (this.ch == '=') {
                        this.symbol.kind = 49;
                        break;
                    }
                    if (this.ch == '>') {
                        this.symbol.kind = 51;
                        break;
                    }
                    this.symbol.kind = 50;
                    this.back_ch();
                    break;
                }
                case '=': {
                    this.next_ch();
                    if (this.ch == '=') {
                        this.symbol.kind = 52;
                        break;
                    }
                    this.symbol.kind = 64;
                    this.back_ch();
                    break;
                }
                case '.': {
                    this.next_ch();
                    if (this.ch == '.') {
                        this.symbol.kind = 67;
                        break;
                    }
                    this.symbol.kind = 66;
                    this.back_ch();
                    break;
                }
                case '-': {
                    this.next_ch();
                    if (this.ch == '-') {
                        this.symbol.kind = 69;
                        break;
                    }
                    this.symbol.kind = 31;
                    this.back_ch();
                    break;
                }
                default: {
                    this.error("unexpected character encountered");
                }
            }
        }
        return this.symbol;
    }
}

