/*
 * Decompiled with CFR 0.152.
 */
package syntaxHighlight;

import java.awt.Color;
import java.awt.Font;
import javax.swing.text.BadLocationException;
import syntaxHighlight.DarwinDefaults;
import syntaxHighlight.DarwinTokenMarker;
import syntaxHighlight.jeditSyntax.JEditTextArea;
import syntaxHighlight.jeditSyntax.SyntaxDocument;

public class DarwinTextArea
extends JEditTextArea {
    public static final int KENYA_MODE = 1;
    public static final int JAVA_MODE = 2;
    public static final int SMALL_FONT_SIZE = 12;
    public static final int LARGE_FONT_SIZE = 18;
    public static final int HUGE_FONT_SIZE = 24;

    public DarwinTextArea() {
        super(new DarwinDefaults());
        this.setTokenMarker(new DarwinTokenMarker());
        this.setFontSize(12);
    }

    public void setTabSize(int size) {
        SyntaxDocument doc = this.getDocument();
        if (doc != null) {
            int old = this.getTabSize();
            doc.putProperty("tabSize", new Integer(size));
            this.firePropertyChange("tabSize", old, size);
        }
    }

    public int getTabSize() {
        Integer i;
        int size = 8;
        SyntaxDocument doc = this.getDocument();
        if (doc != null && (i = (Integer)doc.getProperty("tabSize")) != null) {
            size = i;
        }
        return size;
    }

    public void append(String str) {
        SyntaxDocument doc = this.getDocument();
        if (doc != null) {
            try {
                doc.insertString(doc.getLength(), str, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void bigFont(boolean p_big) {
        this.getPainter().bigFont(p_big);
    }

    public void setFontSize(int size) {
        if (size < 18) {
            this.getPainter().setFont(new Font("Courier", 0, size));
        } else {
            this.getPainter().setFont(new Font("Courier", 1, size));
        }
    }

    public int getFontSize() {
        return this.getPainter().getFont().getSize();
    }

    public void addLineHighlight(int line, Color c) {
        this.getPainter().addLineHighlight(line, c);
    }

    public boolean isLineHighlighted(int line) {
        return this.getPainter().isLineHighlighted(line);
    }

    public Color getLineHighlightColour(int line) {
        return this.getPainter().getLineHighlightColour(line);
    }

    public void removeLineHighlight(int line) {
        this.getPainter().removeLineHighlight(line);
    }

    public void removeAllLineHighlights() {
        this.getPainter().removeAllLineHighlights();
    }
}

