/*
 * Decompiled with CFR 0.152.
 */
package syntaxHighlight.jeditSyntax;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;
import syntaxHighlight.jeditSyntax.JEditTextArea;

public class Gutter
extends JLabel
implements SwingConstants {
    public static final Color DEFAULT_BG_COLOUR = new Color(239, 235, 239);
    public static final Color DEFAULT_FG_COLOUR = new Color(115, 113, 189);
    public static final Color DEFAULT_DIVIDER_COLOUR = Color.red;
    public static final Color DEFAULT_CURRENT_LINE_COLOUR = Color.blue;
    public static final Color DEFAULT_INTERVAL_COLOUR = Color.black;
    private JEditTextArea textArea;
    private JPopupMenu context;
    private int baseline = 0;
    private int ileft = 0;
    private int mMinWidth;
    private Dimension gutterSize;
    private Dimension collapsedSize;
    private Color intervalHighlight;
    private Color currentLineHighlight;
    private Color dividerColour;
    private FontMetrics fm;
    private int alignment;
    private int interval = 5;
    private boolean lineNumberingEnabled = true;
    private boolean currentLineHighlightEnabled = false;
    private boolean collapsed = false;

    public Gutter(JEditTextArea textArea) {
        this.textArea = textArea;
        this.mMinWidth = textArea.getPainter().getFontMetrics().charWidth('8') * 5;
        this.gutterSize = new Dimension(this.mMinWidth, 100);
        this.collapsedSize = new Dimension(10, 100);
        this.setDoubleBuffered(true);
        MouseHandler ml = new MouseHandler();
        this.addMouseListener(ml);
        this.setBackground(DEFAULT_BG_COLOUR);
        this.setForeground(DEFAULT_FG_COLOUR);
        this.setDividerColour(DEFAULT_DIVIDER_COLOUR);
        this.setHighlightedForeground(DEFAULT_INTERVAL_COLOUR);
        this.setCurrentLineForeground(DEFAULT_CURRENT_LINE_COLOUR);
    }

    public void paintComponent(Graphics gfx) {
        if (!this.collapsed) {
            Rectangle r = gfx.getClipBounds();
            gfx.setColor(this.getBackground());
            gfx.fillRect(r.x, r.y, r.width, r.height);
            Color save = gfx.getColor();
            gfx.setColor(this.dividerColour);
            gfx.drawLine(this.gutterSize.width - 3, r.y, this.gutterSize.width - 3, r.y + r.height);
            gfx.setColor(save);
            if (this.lineNumberingEnabled) {
                this.paintLineNumbers(gfx);
            }
        }
    }

    public void paint(Graphics gfx) {
        this.paintComponent(gfx);
    }

    private void paintLineNumbers(Graphics gfx) {
        FontMetrics pfm = this.textArea.getPainter().getFontMetrics();
        int lineHeight = pfm.getHeight();
        Rectangle clip = gfx.getClipBounds();
        int baseline = this.textArea.lineToY(this.textArea.getFirstLine());
        int firstLine = this.textArea.getFirstLine();
        int lastLine = firstLine + 1 + clip.height / lineHeight;
        int caretLine = this.textArea.getCaretLine() + 1;
        int firstValidLine = firstLine > 1 ? firstLine : 1;
        int lastValidLine = lastLine > this.textArea.getLineCount() ? this.textArea.getLineCount() : lastLine;
        boolean highlightCurrentLine = this.currentLineHighlightEnabled && this.textArea.getSelectionStart() == this.textArea.getSelectionEnd();
        gfx.setFont(this.textArea.getPainter().getFont());
        Color fg = this.getForeground();
        Color hfg = this.getHighlightedForeground();
        Color clfg = this.getCurrentLineForeground();
        int line = firstLine;
        while (line <= lastLine) {
            if (line >= firstValidLine && line <= lastValidLine) {
                int offset;
                String number = Integer.toString(line);
                if (this.textArea.isBreakpoint(line)) {
                    Color save = gfx.getColor();
                    gfx.setColor(Color.red);
                    gfx.fillRect(0, baseline - lineHeight, this.gutterSize.width - 3, lineHeight);
                    gfx.setColor(save);
                }
                switch (this.alignment) {
                    case 4: {
                        offset = this.gutterSize.width - this.collapsedSize.width - (this.fm.stringWidth(number) + 1);
                        break;
                    }
                    case 0: {
                        offset = (this.gutterSize.width - this.collapsedSize.width - this.fm.stringWidth(number)) / 2;
                        break;
                    }
                    default: {
                        offset = 1;
                    }
                }
                if (line == caretLine && highlightCurrentLine) {
                    gfx.setColor(clfg);
                } else if (this.interval > 1 && line % this.interval == 0) {
                    gfx.setColor(hfg);
                } else {
                    gfx.setColor(fg);
                }
                gfx.drawString(number, this.ileft + offset, baseline);
            }
            ++line;
            baseline += lineHeight;
        }
    }

    public final void invalidateLine(int line) {
        FontMetrics pfm = this.textArea.getPainter().getFontMetrics();
        this.repaint(0, this.textArea.lineToY(line) + pfm.getDescent() + pfm.getLeading(), this.getWidth(), pfm.getHeight());
    }

    public final void invalidateLineRange(int firstLine, int lastLine) {
        FontMetrics pfm = this.textArea.getPainter().getFontMetrics();
        this.repaint(0, this.textArea.lineToY(firstLine) + pfm.getDescent() + pfm.getLeading(), this.getWidth(), (lastLine - firstLine + 1) * pfm.getHeight());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.baseline = this.fm.getAscent();
    }

    public Color getHighlightedForeground() {
        return this.intervalHighlight;
    }

    public void setHighlightedForeground(Color highlight) {
        this.intervalHighlight = highlight;
    }

    public Color getCurrentLineForeground() {
        return this.currentLineHighlight;
    }

    public void setCurrentLineForeground(Color highlight) {
        this.currentLineHighlight = highlight;
    }

    public void setGutterWidth(int width) {
        if (width < this.collapsedSize.width) {
            width = this.collapsedSize.width;
        }
        this.gutterSize.width = width;
        if (!this.collapsed) {
            this.textArea.revalidate();
        }
    }

    public int getGutterWidth() {
        return this.gutterSize.width;
    }

    public Dimension getPreferredSize() {
        if (this.collapsed) {
            return this.collapsedSize;
        }
        return this.gutterSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isLineNumberingEnabled() {
        return this.lineNumberingEnabled;
    }

    public void setLineNumberingEnabled(boolean enabled) {
        if (this.lineNumberingEnabled == enabled) {
            return;
        }
        this.lineNumberingEnabled = enabled;
        this.repaint();
    }

    public int getLineNumberAlignment() {
        return this.alignment;
    }

    public void setLineNumberAlignment(int alignment) {
        if (this.alignment == alignment) {
            return;
        }
        this.alignment = alignment;
        this.repaint();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.collapsed = collapsed;
        this.textArea.revalidate();
    }

    public void toggleCollapsed() {
        this.setCollapsed(!this.collapsed);
    }

    public int getHighlightInterval() {
        return this.interval;
    }

    public void setHighlightInterval(int interval) {
        if (interval <= 1) {
            interval = 0;
        }
        this.interval = interval;
        this.repaint();
    }

    public void setDividerColour(Color c) {
        this.dividerColour = c;
        this.repaint();
    }

    public Color getDividerColour() {
        return this.dividerColour;
    }

    public boolean isCurrentLineHighlightEnabled() {
        return this.currentLineHighlightEnabled;
    }

    public void setCurrentLineHighlightEnabled(boolean enabled) {
        if (this.currentLineHighlightEnabled == enabled) {
            return;
        }
        this.currentLineHighlightEnabled = enabled;
        this.repaint();
    }

    public JPopupMenu getContextMenu() {
        return this.context;
    }

    public void setContextMenu(JPopupMenu context) {
        this.context = context;
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Gutter.this.toggleCollapsed();
            }
        }
    }
}

