/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.BindPoint;
import darwin.Declaration;
import darwin.Diagnostics;
import darwin.SemanticAnalyser;
import darwin.Semantics;
import java.util.Vector;

public class BindDeclaration
extends Declaration
implements Semantics {
    private BindPoint left;
    private BindPoint right;

    public BindDeclaration() {
    }

    public BindDeclaration(BindPoint left, BindPoint right, Vector tags) {
        super(tags);
        this.left = left;
        this.right = right;
    }

    public void semantics(SemanticAnalyser analyser) {
        this.left.semantics(analyser);
        this.right.semantics(analyser);
        this.checkDirections();
    }

    private boolean direction(String sig1, String sig2, String inferredSignature) {
        String lhs = this.left.signature();
        String rhs = this.right.signature();
        if (lhs.equals(sig1) && rhs.equals(sig2)) {
            if (inferredSignature != null) {
                this.left.setSignature(inferredSignature);
            }
            return true;
        }
        if (lhs.equals(sig2) && rhs.equals(sig1)) {
            if (inferredSignature != null) {
                this.right.setSignature(inferredSignature);
            }
            return true;
        }
        return false;
    }

    private void checkDirections() {
        if (this.direction("p", "ip", null)) {
            return;
        }
        if (this.direction("p", "r", null)) {
            return;
        }
        if (this.direction("x", "ip", null)) {
            return;
        }
        if (this.direction("ir", "ip", null)) {
            return;
        }
        if (this.direction("ir", "r", null)) {
            return;
        }
        if (this.direction("ir", "m", null)) {
            return;
        }
        if (this.direction("t", "t", null)) {
            return;
        }
        if (this.direction("it", "t", null)) {
            return;
        }
        if (this.direction("it", "it", null)) {
            return;
        }
        if (this.direction("t", "r", "p")) {
            return;
        }
        if (this.direction("t", "p", "r")) {
            return;
        }
        if (this.direction("t", "ip", "p")) {
            return;
        }
        if (this.direction("t", "ir", "r")) {
            return;
        }
        if (this.direction("it", "p", "ip")) {
            return;
        }
        if (this.direction("it", "x", "ip")) {
            return;
        }
        if (this.direction("it", "r", "ir")) {
            return;
        }
        if (this.direction("it", "m", "ir")) {
            return;
        }
        if (this.direction("it", "ip", "ir")) {
            return;
        }
        if (this.direction("it", "ir", "ip")) {
            return;
        }
        Diagnostics.fatal("binding directionality not allowed", this.right.bindElement(0).id());
    }

    public BindPoint left() {
        return this.left;
    }

    public BindPoint right() {
        return this.right;
    }
}

