/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.Declaration;
import darwin.FormalParameter;
import darwin.SemanticAnalyser;
import darwin.Semantics;
import darwin.Symbol;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ComponentDeclaration
extends Declaration
implements Semantics {
    private Symbol componentId;
    private Vector formalParameters;
    private Vector declarations;
    protected Hashtable identifiers;
    private static final String MSG1 = "component identifier already has a definition";

    public ComponentDeclaration() {
        this.formalParameters = new Vector();
        this.declarations = new Vector();
        this.identifiers = null;
    }

    public ComponentDeclaration(Symbol componentId, Vector formalParameters, Vector declarations, Vector tags) {
        super(tags);
        this.componentId = componentId;
        this.formalParameters = formalParameters;
        this.declarations = declarations;
        this.identifiers = null;
    }

    public void semantics(SemanticAnalyser analyser) {
        analyser.putLocal(this.componentId, this, MSG1);
        analyser.newScope();
        analyser.semantics(this.formalParameters());
        analyser.semantics(this.declarations());
        this.identifiers = analyser.closeScope();
    }

    public Symbol id() {
        return this.componentId;
    }

    public String name() {
        return this.componentId.toString();
    }

    public int numFormalParameters() {
        return this.formalParameters.size();
    }

    public FormalParameter formalParameter(int n) {
        return (FormalParameter)this.formalParameters.elementAt(n);
    }

    public Enumeration formalParameters() {
        return this.formalParameters.elements();
    }

    public int numDeclarations() {
        return this.declarations.size();
    }

    public Declaration declaration(int n) {
        return (Declaration)this.declarations.elementAt(n);
    }

    public Enumeration declarations() {
        return this.declarations.elements();
    }

    public Hashtable identifiers() {
        return this.identifiers;
    }
}

