/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.Declaration;
import darwin.Expression;
import darwin.SemanticAnalyser;
import darwin.Semantics;
import darwin.Symbol;
import java.util.Vector;

public class ConstDeclaration
extends Declaration
implements Semantics {
    private Symbol constType;
    private Symbol constId;
    private Expression expression;
    private static final String MSG1 = "unknown constant type identifier";
    private static final String MSG2 = "constant identifier already has a definition";

    public ConstDeclaration(Symbol constType, Symbol constId, Expression expression, Vector tags) {
        super(tags);
        this.constType = constType;
        this.constId = constId;
        this.expression = expression;
    }

    public void semantics(SemanticAnalyser analyser) {
        int exprtype = analyser.scalarGetTypeId(this.constType, MSG1);
        analyser.putLocal(this.constId, this, MSG2);
        this.expression.semantics(analyser, exprtype);
    }

    public Symbol type() {
        return this.constType;
    }

    public Symbol id() {
        return this.constId;
    }

    public String name() {
        return this.constId.toString();
    }

    public Expression expression() {
        return this.expression;
    }
}

