/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.Diagnostics;
import darwin.SemanticAnalyser;
import darwin.Semantics;
import darwin.Symbol;

public class Expression
implements Semantics {
    protected Symbol op;
    protected Expression left;
    protected Expression right;
    public static final int UNKNOWN = 0;

    public Expression(Symbol op, Expression left, Expression right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    private String typeString(int type) {
        return new Symbol(type).toString();
    }

    public void semantics(SemanticAnalyser analyser) {
        this.expressionType(analyser);
    }

    public void semantics(SemanticAnalyser analyser, int expected) {
        int type = this.expressionType(analyser);
        if (type != expected) {
            Diagnostics.fatal(String.valueOf(this.typeString(expected)) + " expression expected, found " + this.typeString(type), this.op);
        }
    }

    public String toString() {
        String lhs = "";
        String rhs = "";
        if (this.left != null) {
            lhs = this.left.toString();
        }
        if (this.right != null) {
            rhs = this.right.toString();
        }
        if (this.op.kind == 53) {
            return "(" + rhs + ")";
        }
        return String.valueOf(lhs) + this.op + rhs;
    }

    public Symbol startSymbol() {
        Symbol symbol = this.op;
        Expression expression = this;
        while (expression.left != null) {
            symbol = expression.op;
            expression = expression.left;
        }
        return symbol;
    }

    public int expressionType(SemanticAnalyser analyser) {
        int lhs = 0;
        int rhs = 0;
        if (this.left != null) {
            lhs = this.left.expressionType(analyser);
        }
        if (this.right != null) {
            rhs = this.right.expressionType(analyser);
        }
        switch (this.op.kind) {
            case 20: {
                return analyser.scalarGetType(this.op);
            }
            case 101: 
            case 102: {
                return 3;
            }
            case 21: {
                return 10;
            }
            case 22: {
                return 5;
            }
            case 23: {
                return 17;
            }
            case 53: {
                return rhs;
            }
            case 28: 
            case 29: {
                if (rhs != 10 && rhs != 5) {
                    Diagnostics.fatal("int or double operand expected for unary " + this.op, this.op);
                }
                return rhs;
            }
            case 36: {
                if (rhs != 10) {
                    Diagnostics.fatal("int operand expected for unary ~", this.op);
                }
                return rhs;
            }
            case 45: {
                if (rhs != 3) {
                    Diagnostics.fatal("boolean operand expected for unary !", this.op);
                }
                return rhs;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                if (lhs != 10 && lhs != 5) {
                    Diagnostics.fatal("left hand operand for " + this.op + " not int or double", this.op);
                }
                if (rhs != 10 && rhs != 5) {
                    Diagnostics.fatal("right hand operand for " + this.op + " not int or double", this.op);
                }
                if (lhs == 5 || rhs == 5) {
                    return 5;
                }
                return 10;
            }
            case 34: 
            case 35: 
            case 41: 
            case 43: 
            case 48: 
            case 51: {
                if (lhs != 10) {
                    Diagnostics.fatal("left hand operand for " + this.op + " is not an int", this.op);
                }
                if (rhs != 10) {
                    Diagnostics.fatal("right hand operand for " + this.op + " is not an int", this.op);
                }
                return 10;
            }
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: {
                if (lhs == 10 && rhs == 5) {
                    lhs = 5;
                } else if (lhs == 5 && rhs == 10) {
                    rhs = 5;
                } else if (lhs != rhs) {
                    Diagnostics.fatal("types of left hand and right hand operands are not the same (" + this.typeString(lhs) + ", " + this.typeString(rhs) + ")", this.op);
                }
                return 3;
            }
            case 40: 
            case 42: {
                if (lhs != 3) {
                    Diagnostics.fatal("left hand operand for " + this.op + " is " + this.typeString(lhs) + " not boolean", this.op);
                }
                if (rhs != 3) {
                    Diagnostics.fatal("right hand operand for " + this.op + " is " + this.typeString(rhs) + " not boolean", this.op);
                }
                return 3;
            }
        }
        Diagnostics.fatal("Error in compiler logic, expressionType", this.op);
        return 0;
    }

    public Symbol op() {
        return this.op;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }
}

