/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.Declaration;
import darwin.Expression;
import darwin.SemanticAnalyser;
import darwin.Semantics;
import darwin.Symbol;
import java.util.Enumeration;
import java.util.Vector;

public class ForAllDeclaration
extends Declaration
implements Semantics {
    private Symbol forId;
    private Expression fromExpression;
    private Expression toExpression;
    private Vector declarations;
    private static final String MSG1 = "forall identifier already has a definition";

    public ForAllDeclaration(Symbol forId, Expression fromExpression, Expression toExpression, Vector declarations, Vector tags) {
        super(tags);
        this.forId = forId;
        this.fromExpression = fromExpression;
        this.toExpression = toExpression;
        this.declarations = declarations;
    }

    public void semantics(SemanticAnalyser analyser) {
        Object object = analyser.getLocal(this.forId);
        if (object == null) {
            analyser.putLocal(this.forId, this, MSG1);
        } else {
            analyser.fatal(!(object instanceof ForAllDeclaration), MSG1, this.forId);
        }
        this.fromExpression.semantics(analyser, 10);
        this.toExpression.semantics(analyser, 10);
        analyser.semantics(this.declarations());
    }

    public Symbol id() {
        return this.forId;
    }

    public String name() {
        return this.forId.toString();
    }

    public Expression from() {
        return this.fromExpression;
    }

    public Expression to() {
        return this.toExpression;
    }

    public int numDeclarations() {
        return this.declarations.size();
    }

    public Declaration declaration(int n) {
        return (Declaration)this.declarations.elementAt(n);
    }

    public Enumeration declarations() {
        return this.declarations.elements();
    }
}

