/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.ComponentDeclaration;
import darwin.Declaration;
import darwin.Dimension;
import darwin.Expression;
import darwin.SemanticAnalyser;
import darwin.Semantics;
import darwin.Symbol;
import darwin.Type;
import java.util.Enumeration;
import java.util.Vector;

public class InstDeclaration
extends Declaration
implements Semantics {
    private Type componentType;
    private Symbol instId;
    private Vector dimensions;
    private Vector arguments;
    private ComponentDeclaration component;
    private static final String MSG1 = "component type identifier required for instance";
    private static final String MSG2 = "unknown component type identifier";
    private static final String MSG3 = "identifier already defined as something else";
    private static final String MSG4 = "component type different in a previous inst declaration";
    private static final String MSG5 = "number of dimensions different in a previous inst declartion";
    private static final String MSG6 = "generic component types are not currently supported";

    public InstDeclaration(Symbol instId, Type componentType, Vector dimensions, Vector arguments, Vector tags) {
        super(tags);
        this.instId = instId;
        this.componentType = componentType;
        this.dimensions = dimensions;
        this.arguments = arguments;
        this.component = null;
    }

    public void semantics(SemanticAnalyser analyser) {
        analyser.semantics(this.dimensions());
        analyser.fatal(this.componentType == null, MSG1, this.instId);
        analyser.fatal(this.componentType.kind() != 1, MSG6, this.instId);
        ComponentDeclaration component = analyser.getComponent(this.componentType.id(), MSG2);
        InstDeclaration instance = analyser.getInstance(this.instId);
        analyser.checkParameters(component.formalParameters(), this.arguments(), this.instId);
        if (instance == null) {
            this.component = component;
            analyser.putLocal(this.instId, this);
        } else {
            analyser.fatal(instance.component != component, MSG4, this.instId);
            analyser.fatal(instance.numDimensions() != this.numDimensions(), MSG5, this.instId);
        }
    }

    public Type type() {
        return this.componentType;
    }

    public Symbol id() {
        return this.instId;
    }

    public String name() {
        return this.instId.toString();
    }

    public boolean isArray() {
        return this.numDimensions() > 0;
    }

    public int numDimensions() {
        return this.dimensions.size();
    }

    public Dimension dimension(int n) {
        return (Dimension)this.dimensions.elementAt(n);
    }

    public Enumeration dimensions() {
        return this.dimensions.elements();
    }

    public int numArguments() {
        return this.arguments.size();
    }

    public Expression argument(int n) {
        return (Expression)this.arguments.elementAt(n);
    }

    public Enumeration arguments() {
        return this.arguments.elements();
    }

    public ComponentDeclaration component() {
        return this.component;
    }
}

