/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.BaseInterface;
import darwin.Declaration;
import darwin.FormalParameter;
import darwin.MemberDeclaration;
import darwin.SemanticAnalyser;
import darwin.Semantics;
import darwin.Symbol;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class InterfaceDeclaration
extends Declaration
implements Semantics {
    private Symbol interfaceId;
    private Vector formalParameters;
    private Vector baseInterfaces;
    private Vector memberDeclarations;
    protected Hashtable members;
    private static final String MSG1 = "interface identifier already has a definition";

    public InterfaceDeclaration(Symbol interfaceId, Vector formalParameters, Vector baseInterfaces, Vector memberDeclarations, Vector tags) {
        super(tags);
        this.interfaceId = interfaceId;
        this.formalParameters = formalParameters;
        this.baseInterfaces = baseInterfaces;
        this.memberDeclarations = memberDeclarations;
        this.members = null;
    }

    public void semantics(SemanticAnalyser analyser) {
        analyser.putLocal(this.interfaceId, this, MSG1);
        analyser.newScope();
        analyser.semantics(this.formalParameters());
        analyser.semantics(this.memberDeclarations());
        this.members = analyser.closeScope();
    }

    public Symbol id() {
        return this.interfaceId;
    }

    public String name() {
        return this.interfaceId.toString();
    }

    public int numFormalParameters() {
        return this.formalParameters.size();
    }

    public FormalParameter formalParameter(int n) {
        return (FormalParameter)this.formalParameters.elementAt(n);
    }

    public Enumeration formalParameters() {
        return this.formalParameters.elements();
    }

    public int numBaseClasses() {
        return this.formalParameters.size();
    }

    public BaseInterface baseInterface(int n) {
        return (BaseInterface)this.baseInterfaces.elementAt(n);
    }

    public Enumeration baseInterfaces() {
        return this.baseInterfaces.elements();
    }

    public int numMemberDeclarations() {
        return this.memberDeclarations.size();
    }

    public MemberDeclaration memberDeclaration(int n) {
        return (MemberDeclaration)this.memberDeclarations.elementAt(n);
    }

    public Enumeration memberDeclarations() {
        return this.memberDeclarations.elements();
    }

    public Hashtable members() {
        return this.members;
    }
}

