/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.Diagnostics;
import darwin.Dimension;
import darwin.Expression;
import darwin.InterfaceDeclaration;
import darwin.SemanticAnalyser;
import darwin.Semantics;
import darwin.Symbol;
import darwin.Tag;
import darwin.Type;
import java.util.Enumeration;
import java.util.Vector;

public class MemberDeclaration
implements Semantics {
    private Symbol memberId;
    private Type interfaceType;
    private Vector dimensions;
    private Vector arguments;
    private Vector tags;
    private InterfaceDeclaration interFace;
    private static final String MSG1 = "unknown interface identifier";
    private static final String MSG2 = "generic interface types are not currently handled";
    private static final String MSG3 = "inline interface types are not currenly handled";
    private static final String MSG4 = "identifier already defined as something else";
    private static final String MSG5 = "arguments wrongly supplied to portal";

    public MemberDeclaration(Symbol memberId, Type interfaceType, Vector dimensions, Vector arguments, Vector tags) {
        this.memberId = memberId;
        this.interfaceType = interfaceType;
        this.dimensions = dimensions;
        this.arguments = arguments;
        this.tags = tags;
        this.interFace = null;
    }

    public void semantics(SemanticAnalyser analyser) {
        analyser.semantics(this.dimensions());
        InterfaceDeclaration interFace = null;
        switch (this.interfaceType.kind()) {
            case 1: {
                interFace = analyser.getInterface(this.interfaceType.id(), MSG1);
                break;
            }
            case 2: {
                Diagnostics.fatal(MSG2, this.interfaceType.id());
                break;
            }
            case 3: {
                Diagnostics.fatal(MSG3, this.memberId);
                break;
            }
            case 0: {
                interFace = analyser.getInterface(this.memberId);
            }
        }
        if (interFace == null) {
            analyser.fatal(this.numArguments() > 0, MSG5, this.memberId);
        } else {
            analyser.checkParameters(interFace.formalParameters(), this.arguments(), this.memberId);
        }
        this.interFace = interFace;
        analyser.putLocal(this.memberId, this);
    }

    public Type type() {
        return this.interfaceType;
    }

    public Symbol id() {
        return this.memberId;
    }

    public String name() {
        return this.memberId.toString();
    }

    public int numDimensions() {
        return this.dimensions.size();
    }

    public Dimension dimension(int n) {
        return (Dimension)this.dimensions.elementAt(n);
    }

    public Enumeration dimensions() {
        return this.dimensions.elements();
    }

    public int numArguments() {
        return this.arguments.size();
    }

    public Expression argument(int n) {
        return (Expression)this.arguments.elementAt(n);
    }

    public Enumeration arguments() {
        return this.arguments.elements();
    }

    public int numTags() {
        return this.tags.size();
    }

    public Tag tag(int n) {
        return (Tag)this.tags.elementAt(n);
    }

    public Enumeration tags() {
        return this.tags.elements();
    }

    public InterfaceDeclaration interFace() {
        return this.interFace;
    }
}

