/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.AssertDeclaration;
import darwin.BackEnd;
import darwin.BaseInterface;
import darwin.BindDeclaration;
import darwin.BindElement;
import darwin.BindPoint;
import darwin.ComponentDeclaration;
import darwin.ConstDeclaration;
import darwin.Declaration;
import darwin.Diagnostics;
import darwin.Dimension;
import darwin.Expression;
import darwin.ExternalDeclaration;
import darwin.FSPInclusion;
import darwin.ForAllDeclaration;
import darwin.FormalParameter;
import darwin.InstDeclaration;
import darwin.InterfaceDeclaration;
import darwin.Lex;
import darwin.MemberDeclaration;
import darwin.PartialDeclaration;
import darwin.PortalDeclaration;
import darwin.Symbol;
import darwin.Tag;
import darwin.Type;
import darwin.WhenDeclaration;
import java.util.Vector;

public class Parser {
    private Lex lex;
    private BackEnd factory;
    private Symbol currSymbol;
    private Symbol lastKeyword;
    private Vector components;

    public Parser(Lex lex, BackEnd factory) {
        this.lex = lex;
        this.factory = factory;
    }

    private void error(String errorMsg) {
        Diagnostics.fatal(errorMsg, this.currSymbol);
    }

    private Symbol next_symbol() {
        this.currSymbol = this.lex.in_sym();
        return this.currSymbol;
    }

    private void next_symbol_is(int kind, String errorMsg) {
        this.currSymbol = this.next_symbol();
        if (this.currSymbol.kind != kind) {
            this.error(errorMsg);
        }
    }

    private boolean next_symbol_is(int kind) {
        this.currSymbol = this.next_symbol();
        return this.currSymbol.kind == kind;
    }

    private boolean next_symbol_is_not(int kind) {
        this.currSymbol = this.next_symbol();
        return this.currSymbol.kind != kind;
    }

    private boolean curr_symbol_is(int kind) {
        return this.currSymbol.kind == kind;
    }

    private boolean curr_symbol_is_not(int kind) {
        return this.currSymbol.kind != kind;
    }

    private void curr_symbol_is(int kind, String errorMsg) {
        if (this.currSymbol.kind != kind) {
            this.error(errorMsg);
        }
    }

    private Expression unary() {
        Symbol unary_operator;
        Expression expr = null;
        switch (this.currSymbol.kind) {
            case 30: {
                unary_operator = this.currSymbol;
                unary_operator.kind = 29;
                this.next_symbol();
                break;
            }
            case 31: {
                unary_operator = this.currSymbol;
                unary_operator.kind = 28;
                this.next_symbol();
                break;
            }
            case 45: {
                unary_operator = this.currSymbol;
                this.next_symbol();
                break;
            }
            case 36: {
                unary_operator = this.currSymbol;
                this.next_symbol();
                break;
            }
            default: {
                unary_operator = null;
            }
        }
        switch (this.currSymbol.kind) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 70: 
            case 101: 
            case 102: {
                expr = new Expression(this.currSymbol, null, null);
                this.next_symbol();
                break;
            }
            case 53: {
                unary_operator = this.currSymbol;
                this.next_symbol();
                expr = this.expression();
                this.curr_symbol_is(54, ") expected to end expression");
                this.next_symbol();
                break;
            }
            default: {
                this.error("syntax error in expression");
            }
        }
        if (unary_operator != null) {
            expr = new Expression(unary_operator, null, expr);
        }
        return expr;
    }

    private Expression multiplicative() {
        Expression left = this.unary();
        while (this.curr_symbol_is(32) || this.curr_symbol_is(33) || this.curr_symbol_is(34)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.unary();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression additive() {
        Expression left = this.multiplicative();
        while (this.curr_symbol_is(30) || this.curr_symbol_is(31)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.multiplicative();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression shift() {
        Expression left = this.additive();
        while (this.curr_symbol_is(48) || this.curr_symbol_is(51)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.additive();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression relational() {
        Expression left = this.shift();
        while (this.curr_symbol_is(47) || this.curr_symbol_is(46) || this.curr_symbol_is(50) || this.curr_symbol_is(49)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.shift();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression equality() {
        Expression left = this.relational();
        while (this.curr_symbol_is(52) || this.curr_symbol_is(44)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.relational();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression and() {
        Expression left = this.equality();
        while (this.curr_symbol_is(43)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.equality();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression exclusive_or() {
        Expression left = this.and();
        while (this.curr_symbol_is(35)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.and();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression inclusive_or() {
        Expression left = this.exclusive_or();
        while (this.curr_symbol_is(41)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.exclusive_or();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression logical_and() {
        Expression left = this.inclusive_or();
        while (this.curr_symbol_is(42)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.inclusive_or();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression logical_or() {
        Expression left = this.logical_and();
        while (this.curr_symbol_is(40)) {
            Symbol op = this.currSymbol;
            this.next_symbol();
            Expression right = this.logical_and();
            left = new Expression(op, left, right);
        }
        return left;
    }

    private Expression expression() {
        return this.logical_or();
    }

    private Vector optional_tag_argument_list() {
        if (this.curr_symbol_is(53)) {
            Vector args = this.lex.in_stringArguments();
            this.next_symbol();
            return args;
        }
        return new Vector();
    }

    private Tag tag() {
        this.next_symbol_is(20, "tag identifier expected after @");
        Symbol tagid = this.currSymbol;
        this.next_symbol();
        Vector arguments = this.optional_tag_argument_list();
        return this.factory.new_Tag(tagid, arguments);
    }

    private Vector optional_tag_list() {
        Vector<Tag> tags = new Vector<Tag>();
        while (this.curr_symbol_is(68)) {
            tags.addElement(this.tag());
        }
        return tags;
    }

    private Vector optional_dimensions() {
        Vector<Dimension> dimensions = new Vector<Dimension>();
        while (this.curr_symbol_is(62)) {
            this.next_symbol();
            Expression low = this.expression();
            Symbol indexId = null;
            if (this.curr_symbol_is(38)) {
                if (low.left() != null || low.right() != null || low.op().kind != 20) {
                    Diagnostics.fatal("index identifier expected", low.startSymbol());
                }
                indexId = low.op();
                this.next_symbol();
                low = this.expression();
            }
            Expression high = null;
            if (this.curr_symbol_is(67)) {
                this.next_symbol();
                high = this.expression();
            }
            dimensions.addElement(this.factory.new_Dimension(indexId, low, high));
            this.curr_symbol_is(63, "] expected after array expression");
            this.next_symbol();
        }
        return dimensions;
    }

    private Type optional_type(Symbol defaultType) {
        Symbol typeId = null;
        if (this.curr_symbol_is(38)) {
            this.next_symbol();
            switch (this.currSymbol.kind) {
                case 20: {
                    typeId = this.currSymbol;
                    this.next_symbol();
                    return this.factory.new_Type(1, typeId, null);
                }
                case 47: {
                    this.next_symbol_is(20, "Generic type Identifier expected after <");
                    typeId = this.currSymbol;
                    this.next_symbol_is(50, "> expected after generic type identifier");
                    this.next_symbol();
                    return this.factory.new_Type(2, typeId, null);
                }
                case 60: {
                    Vector memberDeclarations = this.interface_block();
                    return this.factory.new_Type(3, null, memberDeclarations);
                }
            }
            this.error("type expected");
        }
        if (defaultType != null) {
            return this.factory.new_Type(1, defaultType, null);
        }
        return this.factory.new_Type(0, defaultType, null);
    }

    private AssertDeclaration assert_declaration() {
        Expression expr = this.expression();
        Vector tags = this.optional_tag_list();
        this.curr_symbol_is(65, "; expected to end an assert declaration");
        this.next_symbol();
        return this.factory.new_AssertDeclaration(expr, tags);
    }

    private BindElement bind_element() {
        Symbol bindId = this.currSymbol;
        this.next_symbol();
        Vector dimensions = this.optional_dimensions();
        return this.factory.new_BindElement(bindId, dimensions);
    }

    private Vector bind_path() {
        Vector<BindElement> bindpath = new Vector<BindElement>();
        this.curr_symbol_is(20, "instance or portal or portal member identifier expected");
        bindpath.addElement(this.bind_element());
        while (this.curr_symbol_is(66)) {
            this.next_symbol_is(20, "portal or portal member identifier expected after dot");
            bindpath.addElement(this.bind_element());
        }
        return bindpath;
    }

    private BindPoint bind_point() {
        boolean dyn = this.curr_symbol_is(6);
        if (dyn) {
            this.next_symbol();
        }
        Vector bindpath = this.bind_path();
        return this.factory.new_BindPoint(bindpath, dyn);
    }

    private BindDeclaration bind_declaration() {
        BindPoint lhs = this.bind_point();
        this.curr_symbol_is(69, "-- expected");
        this.next_symbol();
        BindPoint rhs = this.bind_point();
        Vector tags = this.optional_tag_list();
        this.curr_symbol_is(65, "; expected to end a bind declaration");
        this.next_symbol();
        return this.factory.new_BindDeclaration(lhs, rhs, tags);
    }

    private ConstDeclaration const_declaration(Symbol constType) {
        this.curr_symbol_is(20, "constant identifier expected");
        Symbol constId = this.currSymbol;
        this.next_symbol_is(64, "= expected after constant identifier");
        this.next_symbol();
        Expression expr = this.expression();
        Vector tags = this.optional_tag_list();
        this.curr_symbol_is(65, "; expected to end a const declaration");
        this.next_symbol();
        return this.factory.new_ConstDeclaration(constType, constId, expr, tags);
    }

    private ExternalDeclaration external_declaration() {
        Symbol externalId = this.currSymbol;
        this.next_symbol();
        Vector tags = this.optional_tag_list();
        this.curr_symbol_is(60, "{ expected after external language identifier");
        String charBlock = this.lex.in_charSeq("}");
        this.next_symbol();
        return this.factory.new_ExternalDeclaration(externalId, charBlock, tags);
    }

    private FSPInclusion fsp_comment(Symbol p_fsp) {
        return new FSPInclusion(p_fsp, p_fsp.string);
    }

    private ForAllDeclaration forall_declaration() {
        this.curr_symbol_is(20, "forall identifier expected after keyword 'forall'");
        Symbol forId = this.currSymbol;
        this.next_symbol_is(64, "= expected after forall identifier");
        this.next_symbol();
        Expression fromExpr = this.expression();
        this.curr_symbol_is(18, "keyword 'to' expected after initial forall expression");
        this.next_symbol();
        Expression toExpr = this.expression();
        Vector tags = this.optional_tag_list();
        Vector declarations = this.declaration_block();
        return this.factory.new_ForAllDeclaration(forId, fromExpr, toExpr, declarations, tags);
    }

    private InstDeclaration instance_declaration() {
        this.curr_symbol_is(20, "instance identifier expected");
        Symbol instId = this.currSymbol;
        this.next_symbol();
        Vector dimensions = this.optional_dimensions();
        Type componentType = this.optional_type(instId);
        Vector arguments = this.optional_argument_list();
        Vector tags = this.optional_tag_list();
        this.curr_symbol_is(65, "; expected to end inst declaration");
        this.next_symbol();
        return this.factory.new_InstDeclaration(instId, componentType, dimensions, arguments, tags);
    }

    private BaseInterface base_interface() {
        this.next_symbol_is(20, "base class identifier expected after :");
        Symbol typeId = this.currSymbol;
        this.next_symbol();
        Vector arguments = this.optional_argument_list();
        return this.factory.new_BaseInterface(typeId, arguments);
    }

    private Vector base_interface_list() {
        Vector<BaseInterface> baseInterfaces = new Vector<BaseInterface>();
        while (this.curr_symbol_is(38)) {
            baseInterfaces.addElement(this.base_interface());
        }
        return baseInterfaces;
    }

    private MemberDeclaration member_declaration() {
        this.curr_symbol_is(20, "interface member identifier expected");
        Symbol memberId = this.currSymbol;
        this.next_symbol();
        Vector dimensions = this.optional_dimensions();
        Type memberType = this.optional_type(null);
        Vector arguments = this.optional_argument_list();
        Vector tags = this.optional_tag_list();
        return this.factory.new_MemberDeclaration(memberId, memberType, dimensions, arguments, tags);
    }

    private Vector interface_block() {
        Vector<MemberDeclaration> members = new Vector<MemberDeclaration>();
        this.curr_symbol_is(60, "{ expected to start portal member declarations");
        while (this.next_symbol_is_not(61)) {
            members.addElement(this.member_declaration());
            this.curr_symbol_is(65, "; expected to end a portal member declaration");
        }
        this.next_symbol();
        return members;
    }

    private InterfaceDeclaration interface_declaration() {
        this.curr_symbol_is(20, "interface identifier expected after keyword 'interface'");
        Symbol interfaceId = this.currSymbol;
        this.next_symbol();
        Vector formalparameters = this.optional_formal_parameter_list();
        Vector tags = this.optional_tag_list();
        Vector baseInterfaces = this.base_interface_list();
        Vector memberdeclarations = this.interface_block();
        return this.factory.new_InterfaceDeclaration(interfaceId, formalparameters, baseInterfaces, memberdeclarations, tags);
    }

    private PortalDeclaration portal_declaration(Symbol portalKind) {
        if (portalKind.kind != 13 && this.curr_symbol_is(13)) {
            this.next_symbol();
        }
        this.curr_symbol_is(20, "portal name expected");
        Symbol portalId = this.currSymbol;
        this.next_symbol();
        Vector dimensions = this.optional_dimensions();
        Type interfaceType = this.optional_type(null);
        Vector arguments = this.optional_argument_list();
        Vector tags = this.optional_tag_list();
        this.curr_symbol_is(65, "; expected to end portal declaration");
        this.next_symbol();
        return this.factory.new_PortalDeclaration(portalKind, portalId, interfaceType, dimensions, arguments, tags);
    }

    private WhenDeclaration when_declaration() {
        Expression expr = this.expression();
        Vector tags = this.optional_tag_list();
        Vector declarations = this.declaration_block();
        return this.factory.new_WhenDeclaration(expr, declarations, tags);
    }

    private Declaration declaration(boolean useLastKeyword) {
        Symbol keyword = useLastKeyword ? this.lastKeyword : this.currSymbol;
        switch (keyword.kind) {
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                this.lastKeyword = keyword;
                if (useLastKeyword) break;
                this.next_symbol();
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 16: 
            case 19: {
                this.lastKeyword = null;
                this.next_symbol();
            }
        }
        switch (keyword.kind) {
            case 1: {
                return this.assert_declaration();
            }
            case 2: {
                return this.bind_declaration();
            }
            case 3: 
            case 5: 
            case 10: 
            case 17: {
                return this.const_declaration(keyword);
            }
            case 4: {
                return this.component_declaration();
            }
            case 8: {
                return this.forall_declaration();
            }
            case 12: {
                return this.instance_declaration();
            }
            case 11: {
                return this.interface_declaration();
            }
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                return this.portal_declaration(keyword);
            }
            case 16: {
                return this.external_declaration();
            }
            case 19: {
                return this.when_declaration();
            }
        }
        switch (this.currSymbol.kind) {
            case 70: {
                Symbol fsp = this.currSymbol;
                this.next_symbol();
                this.components.addElement(this.fsp_comment(fsp));
                break;
            }
            case 6: 
            case 20: 
            case 47: {
                if (this.lastKeyword != null) {
                    return this.declaration(true);
                }
            }
            default: {
                this.error("declaration expected, for example provide, inst, bind");
            }
        }
        return null;
    }

    private Vector declaration_block() {
        Vector<Declaration> declarations = new Vector<Declaration>();
        this.curr_symbol_is(60, "{ expected to start declaration block");
        this.next_symbol();
        while (this.curr_symbol_is_not(61)) {
            declarations.addElement(this.declaration(false));
        }
        this.next_symbol();
        return declarations;
    }

    private Vector optional_argument_list() {
        Vector<Expression> arguments = new Vector<Expression>();
        if (this.curr_symbol_is(53)) {
            do {
                if (!this.next_symbol_is_not(54)) continue;
                arguments.addElement(this.expression());
            } while (this.curr_symbol_is(39));
            this.curr_symbol_is(54, ") expected to end list of arguments");
            this.next_symbol();
            return arguments;
        }
        return arguments;
    }

    private void partial_argument_list() {
        this.next_symbol_is(53, "( expected to start partial component type argument list");
        this.next_symbol_is(54, ") expected to end partial component type argument list");
    }

    private FormalParameter value_parameter() {
        Symbol parameterTypeId = this.currSymbol;
        this.next_symbol_is(20, "parameter identifier expected after parameter type");
        Symbol parameterId = this.currSymbol;
        this.next_symbol();
        return this.factory.new_FormalParameter(parameterTypeId, parameterId);
    }

    private void generic_type_parameter() {
        this.next_symbol_is(20, "generic type identifier expected after '<'");
        this.next_symbol_is(50, "'>' expected  after generic type identifer");
        this.next_symbol();
    }

    private FormalParameter formal_parameter() {
        switch (this.next_symbol().kind) {
            case 47: {
                this.generic_type_parameter();
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 17: {
                return this.value_parameter();
            }
            default: {
                this.error("scalar type or <type> parameter expected");
            }
        }
        return null;
    }

    private Vector optional_formal_parameter_list() {
        Vector<FormalParameter> formalparameters = new Vector<FormalParameter>();
        if (this.curr_symbol_is(53)) {
            do {
                formalparameters.addElement(this.formal_parameter());
            } while (this.curr_symbol_is(39));
            this.curr_symbol_is(54, ") expected to end list of formal parameters");
            this.next_symbol();
        }
        return formalparameters;
    }

    private ComponentDeclaration component_block(Symbol componentId) {
        Vector formalParameters = this.optional_formal_parameter_list();
        Vector tags = this.optional_tag_list();
        Vector declarations = this.declaration_block();
        return this.factory.new_ComponentDeclaration(componentId, formalParameters, declarations, tags);
    }

    private PartialDeclaration partial_component_type(Symbol componentId) {
        this.next_symbol_is(20, "component type identifier expected after =");
        Symbol baseComponentId = this.currSymbol;
        Vector arguments = this.optional_argument_list();
        Vector tags = this.optional_tag_list();
        return this.factory.new_PartialDeclaration(componentId, baseComponentId, arguments, tags);
    }

    private Declaration component_declaration() {
        this.curr_symbol_is(20, "component identifier expected after keyword 'component'");
        Symbol componentId = this.currSymbol;
        switch (this.next_symbol().kind) {
            case 52: {
                return this.partial_component_type(componentId);
            }
        }
        return this.component_block(componentId);
    }

    public Vector parse() {
        this.components = new Vector();
        this.next_symbol();
        while (this.curr_symbol_is_not(99)) {
            switch (this.currSymbol.kind) {
                case 4: {
                    this.next_symbol();
                    this.components.addElement(this.component_declaration());
                    break;
                }
                case 11: {
                    this.next_symbol();
                    this.components.addElement(this.interface_declaration());
                    break;
                }
                case 3: 
                case 5: 
                case 10: 
                case 17: {
                    Symbol keyword = this.currSymbol;
                    this.next_symbol();
                    this.components.addElement(this.const_declaration(keyword));
                    break;
                }
                case 16: {
                    this.next_symbol();
                    this.components.addElement(this.external_declaration());
                    break;
                }
                case 70: {
                    Symbol fsp = this.currSymbol;
                    this.next_symbol();
                    this.components.addElement(this.fsp_comment(fsp));
                    break;
                }
                default: {
                    this.error("component or interface or constant or external declaration expected.");
                }
            }
        }
        return this.components;
    }
}

