/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.Declaration;
import darwin.Diagnostics;
import darwin.Dimension;
import darwin.Expression;
import darwin.InterfaceDeclaration;
import darwin.SemanticAnalyser;
import darwin.Semantics;
import darwin.Symbol;
import darwin.Type;
import java.util.Enumeration;
import java.util.Vector;

public class PortalDeclaration
extends Declaration
implements Semantics {
    private int portalKind;
    private Type interfaceType;
    private Symbol portalId;
    private Vector dimensions;
    private Vector arguments;
    private InterfaceDeclaration interFace;
    private String signature;
    private static final String MSG1 = "unknown interface identifier";
    private static final String MSG2 = "generic interface types are not currently handled";
    private static final String MSG3 = "inline interface types are not currenly handled";
    private static final String MSG4 = "identifier already defined as something else";
    private static final String MSG5 = "interface type different in previous portal declaration";
    private static final String MSG6 = "number of dimensions different in previous portal declalartion";
    private static final String MSG7 = "portal direction different in previous portal declalartion";
    private static final String MSG8 = "arguments wrongly supplied to portal";

    public PortalDeclaration(Symbol portalKind, Symbol portalId, Type interfaceType, Vector dimensions, Vector arguments, Vector tags) {
        super(tags);
        this.portalKind = portalKind.kind;
        this.portalId = portalId;
        this.interfaceType = interfaceType;
        this.dimensions = dimensions;
        this.arguments = arguments;
        this.interFace = null;
        this.signature = "";
    }

    public void semantics(SemanticAnalyser analyser) {
        analyser.semantics(this.dimensions());
        InterfaceDeclaration interFace = null;
        switch (this.interfaceType.kind()) {
            case 1: {
                interFace = analyser.getInterface(this.interfaceType.id(), MSG1);
                break;
            }
            case 2: {
                Diagnostics.fatal(MSG2, this.interfaceType.id());
                break;
            }
            case 3: {
                Diagnostics.fatal(MSG3, this.portalId);
                break;
            }
            case 0: {
                interFace = analyser.getInterface(this.portalId);
            }
        }
        PortalDeclaration portal = analyser.getPortal(this.portalId);
        if (interFace == null) {
            analyser.fatal(this.numArguments() > 0, MSG8, this.portalId);
        } else {
            analyser.checkParameters(interFace.formalParameters(), this.arguments(), this.portalId);
        }
        if (portal == null) {
            this.interFace = interFace;
            analyser.putLocal(this.portalId, this);
        } else {
            analyser.fatal(portal.interFace != interFace, MSG5, this.portalId);
            analyser.fatal(portal.numDimensions() != this.numDimensions(), MSG6, this.portalId);
            analyser.fatal(portal.kind() != this.kind(), MSG7, this.portalId);
        }
    }

    public String signature() {
        if (this.signature.length() == 0) {
            switch (this.portalKind) {
                case 13: {
                    return "t";
                }
                case 14: {
                    return "p";
                }
                case 15: {
                    return "r";
                }
                case 9: {
                    return "m";
                }
                case 7: {
                    return "x";
                }
            }
        }
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature.substring(signature.length() - 1);
    }

    public int kind() {
        return this.portalKind;
    }

    public String portalKeyword() {
        return new Symbol(this.portalKind).toString();
    }

    public Type type() {
        return this.interfaceType;
    }

    public InterfaceDeclaration interFace() {
        return this.interFace;
    }

    public Symbol id() {
        return this.portalId;
    }

    public String name() {
        return this.portalId.toString();
    }

    public boolean isArray() {
        return this.numDimensions() > 0;
    }

    public int numDimensions() {
        return this.dimensions.size();
    }

    public Dimension dimension(int n) {
        return (Dimension)this.dimensions.elementAt(n);
    }

    public Enumeration dimensions() {
        return this.dimensions.elements();
    }

    public int numArguments() {
        return this.arguments.size();
    }

    public Expression argument(int n) {
        return (Expression)this.arguments.elementAt(n);
    }

    public Enumeration arguments() {
        return this.arguments.elements();
    }
}

