/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import darwin.ComponentDeclaration;
import darwin.Diagnostics;
import darwin.Expression;
import darwin.FormalParameter;
import darwin.IdentifierTable;
import darwin.InstDeclaration;
import darwin.InterfaceDeclaration;
import darwin.PortalDeclaration;
import darwin.Semantics;
import darwin.Symbol;
import java.util.Enumeration;
import java.util.Hashtable;

public class SemanticAnalyser {
    private IdentifierTable identifiers = new IdentifierTable();

    public void semantics(Enumeration clauses) {
        while (clauses.hasMoreElements()) {
            Semantics clause = (Semantics)clauses.nextElement();
            if (clause == null) continue;
            clause.semantics(this);
        }
    }

    public void checkParameters(Enumeration formals, Enumeration actuals, Symbol marker) {
        Expression actual = null;
        while (formals.hasMoreElements() && actuals.hasMoreElements()) {
            FormalParameter formal = (FormalParameter)formals.nextElement();
            actual = (Expression)actuals.nextElement();
            int actualType = actual.expressionType(this);
            this.fatal(formal.parameterTypeId().kind != actual.expressionType(this), "argument has wrong type", actual.startSymbol());
        }
        if (actuals.hasMoreElements()) {
            actual = (Expression)actuals.nextElement();
            Diagnostics.fatal("too many arguments supplied", actual.startSymbol());
        } else if (formals.hasMoreElements()) {
            if (actual != null) {
                Diagnostics.fatal("too few arguments supplied", actual.startSymbol());
            } else {
                Diagnostics.fatal("too few arguments supplied", marker);
            }
        }
    }

    public void fatal(boolean fatalCondition, String msg, Symbol symbol) {
        if (fatalCondition) {
            Diagnostics.fatal(msg, symbol);
        }
    }

    protected void newScope() {
        this.identifiers.newScope();
    }

    protected Hashtable currScope() {
        return this.identifiers.currScope();
    }

    protected Hashtable closeScope() {
        return this.identifiers.closeScope();
    }

    public InterfaceDeclaration getInterface(Symbol id, String msg) {
        return (InterfaceDeclaration)this.getGlobal(id, 11, msg);
    }

    public ComponentDeclaration getComponent(Symbol id, String msg) {
        return (ComponentDeclaration)this.getGlobal(id, 4, msg);
    }

    public InterfaceDeclaration getInterface(Symbol id) {
        return (InterfaceDeclaration)this.getGlobal(id, 11);
    }

    public InstDeclaration getInstance(Symbol id) {
        return (InstDeclaration)this.getLocal(id, 12);
    }

    public PortalDeclaration getPortal(Symbol id) {
        return (PortalDeclaration)this.getLocal(id);
    }

    protected Object getLocal(Symbol id) {
        return this.identifiers.getLocal(id);
    }

    protected Object getLocal(Symbol id, int kind) {
        return this.identifiers.getLocal(id, kind);
    }

    protected void putLocal(Symbol id, Object object) {
        this.identifiers.putLocal(id, object);
    }

    protected void putLocal(Symbol id, Object object, String msg) {
        this.identifiers.putLocal(id, object, msg);
    }

    protected Object getGlobal(Symbol id, int kind, String msg) {
        return this.identifiers.getGlobal(id, kind, msg);
    }

    protected Object getGlobal(Symbol id, int kind) {
        return this.identifiers.getGlobal(id, kind);
    }

    protected void UnknownPutLocal(Symbol id, Object object, String msg) {
        this.identifiers.UnknownPutLocal(id, object, msg);
    }

    protected int scalarGetTypeId(Symbol scalarTypeId, String msg) {
        return this.identifiers.scalarGetTypeId(scalarTypeId, msg);
    }

    protected int scalarGetType(Symbol scalarId) {
        return this.identifiers.scalarGetType(scalarId);
    }
}

