/*
 * Decompiled with CFR 0.152.
 */
package darwin;

import java.util.Hashtable;

public class Symbol {
    protected static Hashtable keyword = new Hashtable();
    public int kind;
    public Object marker;
    protected String string;
    protected long longValue;
    protected double doubleValue;
    public static final int ASSERT = 1;
    public static final int BIND = 2;
    public static final int BOOLEAN = 3;
    public static final int COMPONENT = 4;
    public static final int DOUBLE = 5;
    public static final int DYN = 6;
    public static final int EXPORT = 7;
    public static final int FORALL = 8;
    public static final int IMPORT = 9;
    public static final int INT = 10;
    public static final int INTERFACE = 11;
    public static final int INST = 12;
    public static final int PORTAL = 13;
    public static final int PROVIDE = 14;
    public static final int REQUIRE = 15;
    public static final int SPEC = 16;
    public static final int STRING = 17;
    public static final int TO = 18;
    public static final int WHEN = 19;
    public static final int PARTIAL = 100;
    public static final int FALSE = 101;
    public static final int TRUE = 102;
    public static final int UNKNOWN_TYPE = 103;
    public static final int IDENTIFIER = 20;
    public static final int INT_VALUE = 21;
    public static final int DOUBLE_VALUE = 22;
    public static final int STRING_VALUE = 23;
    public static final int UNARY_MINUS = 28;
    public static final int UNARY_PLUS = 29;
    public static final int PLUS = 30;
    public static final int MINUS = 31;
    public static final int STAR = 32;
    public static final int DIVIDE = 33;
    public static final int MODULUS = 34;
    public static final int CIRCUMFLEX = 35;
    public static final int SINE = 36;
    public static final int QUESTION = 37;
    public static final int COLON = 38;
    public static final int COMMA = 39;
    public static final int OR = 40;
    public static final int BITWISE_OR = 41;
    public static final int AND = 42;
    public static final int BITWISE_AND = 43;
    public static final int NOT_EQUAL = 44;
    public static final int PLING = 45;
    public static final int LESS_THAN_EQUAL = 46;
    public static final int LESS_THAN = 47;
    public static final int SHIFT_LEFT = 48;
    public static final int GREATER_THAN_EQUAL = 49;
    public static final int GREATER_THAN = 50;
    public static final int SHIFT_RIGHT = 51;
    public static final int EQUALS = 52;
    public static final int LROUND = 53;
    public static final int RROUND = 54;
    public static final int LCURLY = 60;
    public static final int RCURLY = 61;
    public static final int LSQUARE = 62;
    public static final int RSQUARE = 63;
    public static final int BECOMES = 64;
    public static final int SEMICOLON = 65;
    public static final int DOT = 66;
    public static final int DOT_DOT = 67;
    public static final int AT = 68;
    public static final int DASH_DASH = 69;
    public static final int FSP_COMMENT = 70;
    public static final int EOFSYM = 99;

    static {
        keyword.put("assert", new Integer(1));
        keyword.put("bind", new Integer(2));
        keyword.put("boolean", new Integer(3));
        keyword.put("component", new Integer(4));
        keyword.put("double", new Integer(5));
        keyword.put("dyn", new Integer(6));
        keyword.put("export", new Integer(7));
        keyword.put("forall", new Integer(8));
        keyword.put("import", new Integer(9));
        keyword.put("int", new Integer(10));
        keyword.put("interface", new Integer(11));
        keyword.put("inst", new Integer(12));
        keyword.put("portal", new Integer(13));
        keyword.put("provide", new Integer(14));
        keyword.put("require", new Integer(15));
        keyword.put("spec", new Integer(16));
        keyword.put("string", new Integer(17));
        keyword.put("to", new Integer(18));
        keyword.put("when", new Integer(19));
        keyword.put("false", new Integer(101));
        keyword.put("true", new Integer(102));
    }

    public Symbol() {
    }

    public Symbol(int kind) {
        this.kind = kind;
        this.marker = null;
        this.string = null;
        this.longValue = 0L;
        this.doubleValue = 0.0;
    }

    public boolean isScalarType() {
        switch (this.kind) {
            case 3: 
            case 5: 
            case 10: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        switch (this.kind) {
            case 1: {
                return "assert";
            }
            case 2: {
                return "bind";
            }
            case 4: {
                return "component";
            }
            case 6: {
                return "dyn";
            }
            case 7: {
                return "export";
            }
            case 8: {
                return "forall";
            }
            case 9: {
                return "import";
            }
            case 11: {
                return "interface";
            }
            case 12: {
                return "inst";
            }
            case 13: {
                return "portal";
            }
            case 14: {
                return "provide";
            }
            case 15: {
                return "require";
            }
            case 16: {
                return "spec";
            }
            case 18: {
                return "to";
            }
            case 19: {
                return "when";
            }
            case 101: {
                return "false";
            }
            case 102: {
                return "true";
            }
            case 3: {
                return "boolean";
            }
            case 5: {
                return "double";
            }
            case 10: {
                return "int";
            }
            case 17: {
                return "string";
            }
            case 103: {
                return "unknown";
            }
            case 20: {
                return this.string;
            }
            case 21: {
                return String.valueOf(this.longValue);
            }
            case 22: {
                return String.valueOf(this.doubleValue);
            }
            case 23: {
                return "\"" + this.string + "\"";
            }
            case 28: {
                return "-";
            }
            case 29: {
                return "+";
            }
            case 30: {
                return "+";
            }
            case 31: {
                return "-";
            }
            case 32: {
                return "*";
            }
            case 33: {
                return "/";
            }
            case 34: {
                return "%";
            }
            case 35: {
                return "^";
            }
            case 36: {
                return "~";
            }
            case 37: {
                return "?";
            }
            case 38: {
                return ":";
            }
            case 39: {
                return ",";
            }
            case 40: {
                return "||";
            }
            case 41: {
                return "|";
            }
            case 42: {
                return "&&";
            }
            case 43: {
                return "&";
            }
            case 44: {
                return "!=";
            }
            case 45: {
                return "!";
            }
            case 46: {
                return "<=";
            }
            case 47: {
                return "<";
            }
            case 48: {
                return "<<";
            }
            case 49: {
                return ">=";
            }
            case 50: {
                return ">";
            }
            case 51: {
                return ">>";
            }
            case 52: {
                return "==";
            }
            case 53: {
                return "(";
            }
            case 54: {
                return ")";
            }
            case 60: {
                return "{";
            }
            case 61: {
                return "}";
            }
            case 62: {
                return "[";
            }
            case 63: {
                return "]";
            }
            case 64: {
                return "=";
            }
            case 65: {
                return ";";
            }
            case 66: {
                return ".";
            }
            case 67: {
                return "..";
            }
            case 68: {
                return "@";
            }
            case 69: {
                return "--";
            }
            case 70: {
                return this.string;
            }
            case 99: {
                return "EOF";
            }
        }
        return "ERROR";
    }
}

