/*
 * Decompiled with CFR 0.152.
 */
package syntaxHighlight.jeditSyntax;

import java.awt.Toolkit;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import syntaxHighlight.jeditSyntax.TokenMarker;

public class SyntaxDocument
extends PlainDocument {
    protected TokenMarker tokenMarker;
    private static final int CLOSED = 0;
    private static final int LOADING = 1;
    private static final int SAVING = 2;
    private static final int NEW_FILE = 3;
    private static final int UNTITLED = 4;
    private static final int AUTOSAVE_DIRTY = 5;
    private static final int DIRTY = 6;
    private static final int READ_ONLY = 7;
    private static final int SYNTAX = 8;
    private static final int UNDO_IN_PROGRESS = 9;
    private static final int TEMPORARY = 10;
    private int flags;
    private MyUndoManager undo = new MyUndoManager();
    private UndoableEdit saveUndo;
    private CompoundEdit compoundEdit;
    private boolean compoundEditNonEmpty;
    private int compoundEditCount;
    private Toolkit mToolKit = null;

    public SyntaxDocument() {
        this.addUndoableEditListener(new UndoHandler());
        try {
            this.mToolKit = Toolkit.getDefaultToolkit();
        }
        catch (Exception e) {
            System.err.println("Unable to get default toolkit");
            this.mToolKit = null;
        }
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tm) {
        this.tokenMarker = tm;
        if (tm == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int start, int len) {
        if (this.tokenMarker == null || !this.tokenMarker.supportsMultilineTokens()) {
            return;
        }
        Segment lineSegment = new Segment();
        Element map = this.getDefaultRootElement();
        len += start;
        try {
            int i = start;
            while (i < len) {
                Element lineElement = map.getElement(i);
                int lineStart = lineElement.getStartOffset();
                this.getText(lineStart, lineElement.getEndOffset() - lineStart - 1, lineSegment);
                this.tokenMarker.markTokens(lineSegment, i);
                ++i;
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
    }

    public boolean undo() {
        if (this.undo == null) {
            return false;
        }
        try {
            try {
                this.setFlag(9, true);
                if (this.undo.canUndo()) {
                    this.undo.undo();
                } else if (this.mToolKit != null) {
                    this.mToolKit.beep();
                }
            }
            catch (CannotUndoException cu) {
                cu.printStackTrace();
                this.setFlag(9, false);
                return false;
            }
        }
        finally {
            this.setFlag(9, false);
        }
        UndoableEdit toUndo = this.undo.editToBeUndone();
        return true;
    }

    public boolean redo() {
        if (this.undo == null) {
            return false;
        }
        try {
            try {
                this.setFlag(9, true);
                if (this.undo.canRedo()) {
                    this.undo.redo();
                } else if (this.mToolKit != null) {
                    this.mToolKit.beep();
                }
            }
            catch (CannotRedoException cr) {
                cr.printStackTrace();
                this.setFlag(9, false);
                return false;
            }
        }
        finally {
            this.setFlag(9, false);
        }
        UndoableEdit toUndo = this.undo.editToBeUndone();
        return true;
    }

    public void addUndoableEdit(UndoableEdit edit) {
        if (this.undo == null || this.getFlag(9) || this.getFlag(1)) {
            return;
        }
        if (this.undo.canRedo() && !edit.isSignificant()) {
            return;
        }
        if (this.compoundEdit != null) {
            this.compoundEditNonEmpty = true;
            this.compoundEdit.addEdit(edit);
        } else {
            this.undo.addEdit(edit);
        }
    }

    public void beginCompoundEdit() {
        if (this.getFlag(10)) {
            return;
        }
        ++this.compoundEditCount;
        if (this.compoundEdit == null) {
            this.compoundEditNonEmpty = false;
            this.compoundEdit = new CompoundEdit();
        }
    }

    public void endCompoundEdit() {
        if (this.getFlag(10)) {
            return;
        }
        if (this.compoundEditCount == 0) {
            return;
        }
        --this.compoundEditCount;
        if (this.compoundEditCount == 0) {
            this.compoundEdit.end();
            if (this.compoundEditNonEmpty && this.compoundEdit.canUndo()) {
                this.undo.addEdit(this.compoundEdit);
            }
            this.compoundEdit = null;
        }
    }

    protected void fireInsertUpdate(DocumentEvent evt) {
        DocumentEvent.ElementChange ch;
        if (this.tokenMarker != null && (ch = evt.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.insertLines(ch.getIndex() + 1, ch.getChildrenAdded().length - ch.getChildrenRemoved().length);
        }
        super.fireInsertUpdate(evt);
    }

    protected void fireRemoveUpdate(DocumentEvent evt) {
        DocumentEvent.ElementChange ch;
        if (this.tokenMarker != null && (ch = evt.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.deleteLines(ch.getIndex() + 1, ch.getChildrenRemoved().length - ch.getChildrenAdded().length);
        }
        super.fireRemoveUpdate(evt);
    }

    private void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= 1 << flag) : (this.flags &= ~(1 << flag));
    }

    private boolean getFlag(int flag) {
        int mask = 1 << flag;
        return (this.flags & mask) == mask;
    }

    class MyUndoManager
    extends UndoManager {
        MyUndoManager() {
        }

        public UndoableEdit editToBeUndone() {
            return super.editToBeUndone();
        }

        public UndoableEdit editToBeRedone() {
            return super.editToBeRedone();
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent evt) {
            SyntaxDocument.this.addUndoableEdit(evt.getEdit());
        }
    }
}

