/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import mscedit.BMSC;
import mscedit.Input;
import mscedit.InputOrOutput;
import mscedit.Instance;
import mscedit.Link;
import mscedit.Output;
import mscedit.Specification;
import mscedit.XMLUtil;

public class Convertor {
    private Specification o_spec;

    public Convertor(String p_file) {
        File x_file = null;
        try {
            x_file = new File(p_file);
        }
        catch (Exception e) {
            System.err.println("Error converting file " + p_file + "\n" + e.getMessage());
        }
        this.o_spec = new Specification(XMLUtil.loadFromFile(x_file));
        List x_bmscs = this.o_spec.getBMSCs();
        Iterator i = x_bmscs.iterator();
        while (i.hasNext()) {
            BMSC x_bmsc = (BMSC)i.next();
            List x_links = x_bmsc.getLinks();
            Iterator j = x_links.iterator();
            while (j.hasNext()) {
                Link x_link = (Link)j.next();
                String x_newname = String.valueOf(x_link.getFrom().toLowerCase()) + "," + x_link.getTo().toLowerCase() + "," + x_link.getName().replace('.', '_');
                x_bmsc.changeLinkName(String.valueOf(x_link.getName()) + x_link.getTimeIndex(), x_newname);
            }
            List x_insts = x_bmsc.getInstances();
            Iterator j2 = x_insts.iterator();
            while (j2.hasNext()) {
                Instance x_inst = (Instance)j2.next();
                x_inst.setName(this.rename(x_inst.getName()));
                List x_inputs = x_inst.getInputs();
                Iterator k = x_inputs.iterator();
                while (k.hasNext()) {
                    Input x_input = (Input)k.next();
                    x_input.setFrom(this.rename(x_input.getFrom()));
                }
                List x_outputs = x_inst.getOutputs();
                Iterator k2 = x_outputs.iterator();
                while (k2.hasNext()) {
                    Output x_output = (Output)k2.next();
                    x_output.setTo(this.rename(x_output.getTo()));
                }
            }
        }
        XMLUtil.saveToFile(this.o_spec.asXML(), x_file);
        System.out.println("Converted file " + x_file.getName());
    }

    private void changeLinkName(String p_id, String p_to, BMSC p_bmsc) {
        List x_instances = p_bmsc.getInstances();
        Iterator i = x_instances.iterator();
        block0: while (i.hasNext()) {
            InputOrOutput x_child;
            Instance x_inst = (Instance)i.next();
            List x_children = x_inst.getInputs();
            Iterator j = x_children.iterator();
            while (j.hasNext()) {
                x_child = (Input)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                x_child.setName(p_to);
                break;
            }
            x_children = x_inst.getOutputs();
            j = x_children.iterator();
            while (j.hasNext()) {
                x_child = (Output)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                x_child.setName(p_to);
                continue block0;
            }
        }
    }

    private String rename(String p_old) {
        return String.valueOf(p_old.toLowerCase()) + ":" + p_old;
    }

    public static void main(String[] args) {
        new Convertor(args[0]);
    }
}

