/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import ic.doc.extension.Exportable;
import ic.doc.extension.LTSA;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mscedit.BMSC;
import mscedit.BMSCEditorCanvas;
import mscedit.BMSCGraphic;
import mscedit.CanvasMouseListener;
import mscedit.EditorCanvas;
import mscedit.ExampleFileFilter;
import mscedit.Glyph;
import mscedit.GuiEventListener;
import mscedit.HMSC;
import mscedit.HMSCCanvasMouseListener;
import mscedit.HMSCEditorCanvas;
import mscedit.Instance;
import mscedit.InstanceGraphic;
import mscedit.Link;
import mscedit.MessageGraphic;
import mscedit.Specification;
import mscedit.TransitionGraphic;
import mscedit.XMLUtil;

public class XMLGui
extends JPanel {
    private HMSCEditorCanvas o_hmsc_canvas;
    private Specification o_spec;
    private JTabbedPane o_tabbed_pane;
    private JToolBar o_toolbar;
    private JPopupMenu o_popup;
    private JPopupMenu o_hmsc_popup;
    private JPopupMenu o_ptransition_popup;
    private List o_editors = new ArrayList();
    private JButton o_pointer;
    private JButton o_delete;
    private JButton o_newmsc;
    private JButton o_newinst;
    private JButton o_newmsg;
    private JButton o_newtrans;
    private JButton o_newnegmsg;
    private JButton o_newdiv;
    private boolean o_positive = true;
    private boolean o_add_link_mode = false;
    private boolean o_add_divider_mode = false;
    private String o_link_name = "";
    private int o_neg_count = 0;
    private HashSet o_message_alphabet;
    private List o_instance_alphabet;
    private LTSA o_ltsa;

    public XMLGui() {
        this.o_spec = new Specification();
        this.o_tabbed_pane = new JTabbedPane();
        this.o_hmsc_canvas = new HMSCEditorCanvas(this);
        this.o_spec.addHMSC(this.o_hmsc_canvas.getHMSC());
        this.o_spec.addBMSC(new BMSC("init"));
        this.o_hmsc_canvas.addBMSC("init", 50, 30);
        this.o_hmsc_canvas.rebuild();
        HMSCCanvasMouseListener x_mouse_listener = new HMSCCanvasMouseListener(this.o_hmsc_canvas);
        this.o_hmsc_canvas.addMouseListener(x_mouse_listener);
        this.o_hmsc_canvas.addMouseMotionListener(x_mouse_listener);
        this.o_toolbar = new JToolBar("MSC Editor");
        this.populateMenus();
        this.populateToolBar();
        this.o_instance_alphabet = new ArrayList();
        this.o_message_alphabet = new HashSet();
        this.o_hmsc_canvas.setPreferredSize(new Dimension(500, 400));
        this.setLocation(150, 150);
        this.o_tabbed_pane.addTab("hMSC", null, new JScrollPane(this.o_hmsc_canvas), "High-Level Message Sequence Chart");
        this.o_editors.add(this.o_hmsc_canvas);
        this.o_tabbed_pane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent p_ce) {
                XMLGui.this.enableButtons();
            }
        });
        this.enableButtons();
        this.setLayout(new BorderLayout());
        this.add((Component)this.o_tabbed_pane, "Center");
        this.add((Component)this.o_toolbar, "South");
    }

    private void enableButtons() {
        if (this.o_tabbed_pane.getSelectedIndex() == 0) {
            this.o_newmsc.setEnabled(true);
            this.o_newtrans.setEnabled(true);
            this.o_newmsg.setEnabled(false);
            this.o_newnegmsg.setEnabled(false);
            this.o_newdiv.setEnabled(false);
            this.o_newinst.setEnabled(false);
        } else {
            this.o_newmsc.setEnabled(true);
            this.o_newtrans.setEnabled(false);
            this.o_newmsg.setEnabled(true);
            this.o_newnegmsg.setEnabled(true);
            this.o_newdiv.setEnabled(true);
            this.o_newinst.setEnabled(true);
        }
    }

    public Specification getSpecification() {
        return this.o_spec;
    }

    void populateMenus() {
        this.o_popup = new JPopupMenu("Message");
        this.o_hmsc_popup = new JPopupMenu("hmsc");
        this.o_ptransition_popup = new JPopupMenu("Transition");
        GuiEventListener xRenameListener = new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.rename();
            }
        };
        JMenuItem x_item = new JMenuItem("Rename");
        x_item.addActionListener(xRenameListener);
        this.o_popup.add(x_item);
        x_item = new JMenuItem("Rename");
        x_item.addActionListener(xRenameListener);
        this.o_hmsc_popup.add(x_item);
        x_item = new JMenuItem("Rename");
        x_item.addActionListener(xRenameListener);
        this.o_ptransition_popup.add(x_item);
        x_item = new JMenuItem("Reverse arrow");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.reverseLink();
            }
        });
        this.o_popup.add(x_item);
        GuiEventListener xDeleteListener = new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.deleteMessage();
            }
        };
        x_item = new JMenuItem("Delete");
        x_item.addActionListener(xDeleteListener);
        this.o_popup.add(x_item);
        x_item = new JMenuItem("Delete");
        x_item.addActionListener(xDeleteListener);
        this.o_hmsc_popup.add(x_item);
        x_item = new JMenuItem("Delete");
        x_item.addActionListener(xDeleteListener);
        this.o_ptransition_popup.add(x_item);
        x_item = new JMenuItem("Add Weight");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.addWeight();
            }
        });
        this.o_ptransition_popup.add(x_item);
        x_item = new JMenuItem("Tidy");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.tidyChart();
            }
        });
        this.o_popup.add(x_item);
        x_item = new JMenuItem("Duplicate Scenario");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.duplicateBMSC();
            }
        });
        this.o_popup.add(x_item);
    }

    protected void addWeight() {
        String x_weight = JOptionPane.showInputDialog(null, "Enter a weight for the transition:", "Set weight", 3);
        this.o_hmsc_canvas.addWeight(x_weight);
    }

    void setBigFont(boolean p_set) {
        if (p_set) {
            Glyph.setFont(new Font("Terminal", 1, 15));
            Glyph.setScale(1.5);
        } else {
            Glyph.setFont(new Font("Terminal", 0, 11));
            Glyph.setScale(1.0);
        }
        Iterator i = this.o_editors.iterator();
        while (i.hasNext()) {
            EditorCanvas x_canvas = (EditorCanvas)i.next();
            x_canvas.rebuild();
        }
    }

    void showToolBar(boolean p_show) {
        if (p_show) {
            this.add("South", this.o_toolbar);
        } else {
            this.remove(this.o_toolbar);
        }
    }

    void newMSC() {
        String x_name = JOptionPane.showInputDialog(null, "Enter a name for the MSC:", "New MSC", 3);
        if (x_name != null && !x_name.trim().equals("")) {
            if (this.existsMSCCalled(x_name) || x_name.trim().equals("init")) {
                JOptionPane.showMessageDialog(null, "MSC called " + x_name + " already exists.", "Duplicate name", 0);
                return;
            }
            x_name = this.capitalise(x_name);
            BMSCEditorCanvas x_canvas = new BMSCEditorCanvas(this, x_name);
            CanvasMouseListener x_mouse_listener = new CanvasMouseListener(x_canvas);
            x_canvas.addMouseListener(x_mouse_listener);
            x_canvas.addMouseMotionListener(x_mouse_listener);
            this.o_tabbed_pane.addTab(x_name, null, new JScrollPane(x_canvas), "Basic Message Sequence Chart");
            this.o_editors.add(x_canvas);
            this.o_tabbed_pane.setSelectedIndex(this.o_tabbed_pane.indexOfTab(x_name));
            Iterator i = this.o_instance_alphabet.iterator();
            while (i.hasNext()) {
                x_canvas.addInstance((String)i.next());
            }
            this.o_spec.addBMSC(x_canvas.getBMSC());
            x_canvas.rebuild();
            this.o_hmsc_canvas.addBMSC(x_name, (this.o_tabbed_pane.getTabCount() - 2) % 4 * 120 + 50, (this.o_tabbed_pane.getTabCount() - 2) / 4 * 100 + 130);
            this.o_hmsc_canvas.rebuild();
        }
    }

    public void addBMSC(BMSC p_bmsc) {
        BMSCEditorCanvas x_canvas = new BMSCEditorCanvas(this, p_bmsc);
        CanvasMouseListener x_mouse_listener = new CanvasMouseListener(x_canvas);
        x_canvas.addMouseListener(x_mouse_listener);
        x_canvas.addMouseMotionListener(x_mouse_listener);
        this.o_tabbed_pane.addTab(p_bmsc.getName(), null, new JScrollPane(x_canvas), "Implied Scenario");
        this.o_editors.add(x_canvas);
        this.o_tabbed_pane.setSelectedIndex(this.o_tabbed_pane.indexOfTab(p_bmsc.getName()));
        this.o_spec.addBMSC(x_canvas.getBMSC());
        x_canvas.rebuild();
    }

    public void addBMSCtoHMSC(BMSC p_bmsc) {
        this.o_hmsc_canvas.addBMSC(p_bmsc.getName(), (this.o_tabbed_pane.getTabCount() - 2) % 4 * 120 + 50, (this.o_tabbed_pane.getTabCount() - 2) / 4 * 100 + 130);
        this.o_hmsc_canvas.rebuild();
    }

    File fileChooser(String p_name) {
        JFileChooser x_filechooser = new JFileChooser(new File(this.o_ltsa.getCurrentDirectory()));
        ExampleFileFilter x_filter = new ExampleFileFilter();
        x_filter.addExtension("xml");
        x_filter.setDescription("XML files");
        x_filechooser.addChoosableFileFilter(x_filter);
        x_filechooser.setApproveButtonText(p_name);
        x_filechooser.setDialogTitle(p_name);
        int x_rv = x_filechooser.showOpenDialog(this);
        if (x_rv == 0) {
            this.o_ltsa.setCurrentDirectory(x_filechooser.getCurrentDirectory().getAbsolutePath());
            return x_filechooser.getSelectedFile();
        }
        return null;
    }

    void newSpec() {
        this.o_spec = new Specification();
        this.o_tabbed_pane.removeAll();
        this.o_editors.clear();
        this.o_hmsc_canvas = new HMSCEditorCanvas(this);
        this.o_spec.addHMSC(this.o_hmsc_canvas.getHMSC());
        this.o_spec.addBMSC(new BMSC("init"));
        this.o_hmsc_canvas.addBMSC("init", 50, 30);
        this.o_hmsc_canvas.rebuild();
        HMSCCanvasMouseListener x_mouse_listener = new HMSCCanvasMouseListener(this.o_hmsc_canvas);
        this.o_hmsc_canvas.addMouseListener(x_mouse_listener);
        this.o_hmsc_canvas.addMouseMotionListener(x_mouse_listener);
        this.o_tabbed_pane.addTab("hMSC", null, new JScrollPane(this.o_hmsc_canvas), "High-Level Message Sequence Chart");
        this.o_editors.add(this.o_hmsc_canvas);
        this.enableButtons();
        this.o_neg_count = 0;
        this.o_message_alphabet = new HashSet();
        this.o_instance_alphabet = new ArrayList();
    }

    void openFile(File p_file) {
        if (p_file != null) {
            this.o_spec = new Specification(XMLUtil.loadFromFile(p_file));
            this.o_tabbed_pane.removeAll();
            this.o_editors.clear();
            HMSC x_hmsc = this.o_spec.getHMSC();
            this.o_hmsc_canvas = new HMSCEditorCanvas(this, x_hmsc);
            HMSCCanvasMouseListener x_mouse_listener = new HMSCCanvasMouseListener(this.o_hmsc_canvas);
            this.o_hmsc_canvas.addMouseListener(x_mouse_listener);
            this.o_hmsc_canvas.addMouseMotionListener(x_mouse_listener);
            this.o_tabbed_pane.addTab("hMSC", null, new JScrollPane(this.o_hmsc_canvas), "High-Level Message Sequence Chart");
            this.o_editors.add(this.o_hmsc_canvas);
            this.o_neg_count = 0;
            List x_bmscs = this.o_spec.getBMSCs();
            this.o_instance_alphabet = new ArrayList();
            this.o_message_alphabet = new HashSet();
            Iterator i = x_bmscs.iterator();
            while (i.hasNext()) {
                BMSC x_bmsc = (BMSC)i.next();
                if (x_bmsc.getName().equals("init")) continue;
                if (x_bmsc.isNegative()) {
                    ++this.o_neg_count;
                }
                BMSCEditorCanvas x_editor = new BMSCEditorCanvas(this, x_bmsc);
                CanvasMouseListener x_listener = new CanvasMouseListener(x_editor);
                x_editor.addMouseListener(x_listener);
                x_editor.addMouseMotionListener(x_listener);
                this.o_tabbed_pane.addTab(x_bmsc.getName(), null, new JScrollPane(x_editor), "Basic Message Sequence Chart");
                this.o_editors.add(x_editor);
                List x_instances = x_bmsc.getInstances();
                Iterator j = x_instances.iterator();
                while (j.hasNext()) {
                    String x_name = ((Instance)j.next()).getName();
                    if (this.o_instance_alphabet.contains(x_name)) continue;
                    this.o_instance_alphabet.add(x_name);
                }
                List x_links = x_bmsc.getLinks();
                Iterator j2 = x_links.iterator();
                while (j2.hasNext()) {
                    this.o_message_alphabet.add(((Link)j2.next()).getName());
                }
            }
        }
        this.o_hmsc_canvas.rebuild();
        this.updateTitleBar();
    }

    void saveFile() {
        File x_file = this.fileChooser("Save");
        if (x_file != null) {
            XMLUtil.saveToFile(this.o_spec.asXML(), x_file);
        }
    }

    void saveFile(FileOutputStream p_fos) {
        if (p_fos != null) {
            XMLUtil.saveToFile(this.o_spec.asXML(), p_fos);
        }
    }

    void newInstance() {
        if (this.o_tabbed_pane.getTabCount() == 0) {
            this.newMSC();
        }
        Object[] x_possibilities = new Object[this.o_instance_alphabet.toArray().length + 1];
        System.arraycopy(this.o_instance_alphabet.toArray(), 0, x_possibilities, 1, this.o_instance_alphabet.toArray().length);
        Arrays.sort(x_possibilities, 1, x_possibilities.length);
        x_possibilities[0] = "New...";
        String x_name = (String)JOptionPane.showInputDialog(null, "Select instance name:", "New Instance", 3, null, x_possibilities, "New...");
        if (x_name != null && x_name.equals("New...")) {
            x_name = JOptionPane.showInputDialog(null, "Enter instance name:", "New Instance", 3);
        }
        if (x_name != null && !x_name.trim().equals("") && x_name.indexOf(":") != 0) {
            BMSCEditorCanvas x_current = (BMSCEditorCanvas)this.getCurrentEditor();
            Iterator i = x_current.getBMSC().getInstances().iterator();
            while (i.hasNext()) {
                if (!((Instance)i.next()).getName().equals(x_name)) continue;
                JOptionPane.showMessageDialog(null, "Instance called " + x_name + " already exists.", "Duplicate name", 0);
                return;
            }
            if (!this.o_instance_alphabet.contains(x_name = this.capitalise(x_name))) {
                this.o_instance_alphabet.add(x_name);
            }
            x_current.addInstance(x_name);
            x_current.rebuild();
        }
    }

    void newMessage(boolean p_positive) {
        if (this.o_tabbed_pane.getSelectedIndex() > 0) {
            Object[] x_possibilities = new Object[this.o_message_alphabet.toArray().length + 1];
            System.arraycopy(this.o_message_alphabet.toArray(), 0, x_possibilities, 1, this.o_message_alphabet.toArray().length);
            Arrays.sort(x_possibilities, 1, x_possibilities.length);
            x_possibilities[0] = "New...";
            String x_name = (String)JOptionPane.showInputDialog(null, "Select link name:", "New Link", 3, null, x_possibilities, "New...");
            if (x_name != null && x_name.equals("New...")) {
                x_name = JOptionPane.showInputDialog(null, "Enter link name:", "New Link", 3);
            }
            if (x_name != null && !x_name.trim().equals("")) {
                if (this.o_message_alphabet.contains(x_name = this.smallCaps(x_name))) {
                    List x_all_links = this.getSpecification().getAllLinks();
                    String x_from = "";
                    String x_to = "";
                    Iterator i = x_all_links.iterator();
                    while (i.hasNext()) {
                        Link x_l = (Link)i.next();
                        if (!x_l.getName().equals(x_name)) continue;
                        x_from = x_l.getFrom();
                        x_to = x_l.getTo();
                        break;
                    }
                    BMSCEditorCanvas x_current = (BMSCEditorCanvas)this.getCurrentEditor();
                    int x_ti = x_current.getBMSC().getLastTimeIndex() + 1;
                    x_current.addLink(x_from, x_to, "@@" + x_name, x_ti);
                    x_current.rebuild();
                    return;
                }
                this.o_positive = p_positive;
                this.o_add_link_mode = true;
                this.o_link_name = x_name;
            }
            this.setCursor(new Cursor(1));
        }
    }

    public void addMessageToAlphabet(String p_name) {
        this.o_message_alphabet.add(p_name);
    }

    void newTransition() {
        if (this.o_tabbed_pane.getSelectedIndex() == 0) {
            this.o_add_link_mode = true;
            this.setCursor(new Cursor(1));
        }
    }

    void newDivider() {
        this.o_add_link_mode = false;
        this.o_add_divider_mode = true;
        this.setCursor(new Cursor(1));
    }

    void deleteMessage() {
        EditorCanvas x_current = this.getCurrentEditor();
        x_current.delete();
        x_current.rebuild();
    }

    void deleteBMSC(String p_name) {
        if (p_name.equals("init")) {
            return;
        }
        this.getSpecification().deleteBMSC(p_name);
        HMSCEditorCanvas x_hmsc_edit = (HMSCEditorCanvas)this.o_editors.get(0);
        x_hmsc_edit.deleteBMSC(p_name);
        x_hmsc_edit.rebuild();
        if (this.o_tabbed_pane.indexOfTab(p_name) > -1) {
            this.o_editors.remove(this.o_tabbed_pane.indexOfTab(p_name));
            this.o_tabbed_pane.removeTabAt(this.o_tabbed_pane.indexOfTab(p_name));
        }
    }

    void rename() {
        EditorCanvas x_current = this.getCurrentEditor();
        Glyph x_selection = x_current.getSelection();
        if (x_selection instanceof InstanceGraphic) {
            String x_name = JOptionPane.showInputDialog(null, "Enter new name:", "Rename instance globally", 3);
            this.renameInstance(x_current.getSelectionId(), x_name);
        } else if (x_selection instanceof BMSCGraphic) {
            String x_oldname = x_selection.getName();
            if (x_oldname.equals("init")) {
                return;
            }
            String x_newname = JOptionPane.showInputDialog(null, "Enter new name:", "Rename bMSC", 3);
            if (x_newname == null || x_newname.trim().equals("")) {
                return;
            }
            if (this.existsMSCCalled(x_newname) || x_newname.trim().equals("init")) {
                JOptionPane.showMessageDialog(null, "MSC called " + x_newname + " already exists.", "Duplicate name", 0);
                return;
            }
            x_newname = this.capitalise(x_newname);
            HMSC x_hmsc = this.o_spec.getHMSC();
            x_hmsc.renameBMSC(x_oldname, x_newname);
            this.o_spec.renameBMSC(x_oldname, x_newname);
            this.renameTab(x_oldname, x_newname);
            x_current.rebuild();
        } else if (x_selection instanceof MessageGraphic) {
            String x_name = JOptionPane.showInputDialog(null, "Enter new name:", "Rename Message", 3);
            x_current.changeLinkName(x_current.getSelectionId(), x_name);
            x_current.rebuild();
        }
    }

    void reverseLink() {
        EditorCanvas x_current = this.getCurrentEditor();
        x_current.reverseSelectedLink();
        x_current.rebuild();
    }

    void negateMessage() {
        EditorCanvas x_current = this.getCurrentEditor();
        x_current.negateSelectedLink();
        x_current.rebuild();
    }

    void tidyChart() {
        EditorCanvas x_current = this.getCurrentEditor();
        x_current.tidy();
        x_current.rebuild();
    }

    private String prefix(String p_str) {
        return p_str.substring(0, p_str.indexOf(":"));
    }

    void renameInstance(String p_oldname, String p_newname) {
        List x_bmscs = this.o_spec.getBMSCs();
        Iterator i = x_bmscs.iterator();
        while (i.hasNext()) {
            BMSC x_bmsc = (BMSC)i.next();
            List x_instances = x_bmsc.getInstances();
            Iterator j = x_instances.iterator();
            while (j.hasNext()) {
                Instance x_inst = (Instance)j.next();
                if (!x_inst.getName().equals(p_oldname)) continue;
                x_inst.setName(p_newname);
            }
            List x_msgs = x_bmsc.getLinks();
            Iterator j2 = x_msgs.iterator();
            while (j2.hasNext()) {
                Link x_link = (Link)j2.next();
                String x_name = x_link.getName();
                this.o_message_alphabet.remove(x_name);
                if (x_link.getTo().equals(p_oldname)) {
                    x_bmsc.deleteLink(x_link.getId());
                    x_link.setTo(p_newname);
                    x_link.setName(x_name.replaceAll("," + this.prefix(p_oldname) + ",", "," + this.prefix(p_newname) + ","));
                    x_bmsc.addLink(x_link);
                }
                if (x_link.getFrom().equals(p_oldname)) {
                    x_bmsc.deleteLink(x_link.getId());
                    x_link.setFrom(p_newname);
                    x_link.setName(x_name.replaceAll(String.valueOf(this.prefix(p_oldname)) + ",", String.valueOf(this.prefix(p_newname)) + ","));
                    x_bmsc.addLink(x_link);
                }
                this.o_message_alphabet.add(x_link.getName());
            }
        }
        i = this.o_editors.iterator();
        while (i.hasNext()) {
            EditorCanvas x_canvas = (EditorCanvas)i.next();
            x_canvas.rebuild();
        }
    }

    void duplicateBMSC() {
        EditorCanvas x_current = this.getCurrentEditor();
        if (x_current instanceof BMSCEditorCanvas) {
            BMSCEditorCanvas x_canvas = (BMSCEditorCanvas)x_current;
            BMSC x_bmsc = x_canvas.getBMSC();
            String x_name = JOptionPane.showInputDialog(null, "Name for new scenario:", "Duplicate Scenario", 3);
            BMSC x_copy = x_bmsc.duplicate();
            x_copy.setName(x_name);
            this.addBMSC(x_copy);
        }
    }

    void removeFromMsgAlphabet(String p_name) {
        this.o_message_alphabet.remove(p_name);
    }

    public boolean inAddLinkMode() {
        return this.o_add_link_mode;
    }

    public boolean inAddDividerMode() {
        return this.o_add_divider_mode;
    }

    public void setAddDividerMode(boolean p_set) {
        this.o_add_divider_mode = p_set;
    }

    public boolean addPositive() {
        return this.o_positive;
    }

    public void setAddLinkMode(boolean p_addlink) {
        this.o_add_link_mode = p_addlink;
    }

    public String getLinkName() {
        return this.o_link_name;
    }

    public List getInstanceAlphabet() {
        return this.o_instance_alphabet;
    }

    public void addLink(String p_from, String p_to, int p_timeindex) {
        EditorCanvas x_current = this.getCurrentEditor();
        x_current.addLink(p_from, p_to, this.o_link_name, p_timeindex);
        this.o_add_link_mode = false;
        this.setCursor(new Cursor(0));
        x_current.rebuild();
    }

    public void addNegativeLink(String p_from, String p_to, int p_timeindex) {
        EditorCanvas x_current = this.getCurrentEditor();
        x_current.addNegativeLink(p_from, p_to, this.o_link_name, p_timeindex);
        this.o_add_link_mode = false;
        this.o_positive = true;
        x_current.rebuild();
    }

    int getNegCount() {
        return this.o_neg_count;
    }

    void setNegCount(int p_count) {
        this.o_neg_count = p_count;
    }

    void updateTitleBar() {
    }

    public void redrawCurrentCanvas() {
        EditorCanvas x_current = this.getCurrentEditor();
        x_current.rebuild();
    }

    public void showPopup(MouseEvent p_me, Glyph p_selection) {
        if (p_me.getComponent() == this.o_hmsc_canvas) {
            if (p_selection instanceof BMSCGraphic) {
                this.o_hmsc_popup.show(p_me.getComponent(), p_me.getX(), p_me.getY());
            }
            if (p_selection instanceof TransitionGraphic) {
                this.o_ptransition_popup.show(p_me.getComponent(), p_me.getX(), p_me.getY());
            }
        } else {
            this.o_popup.show(p_me.getComponent(), p_me.getX(), p_me.getY());
        }
    }

    private void populateToolBar() {
        this.o_pointer = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/pointer.gif")));
        this.o_pointer.setToolTipText("Select");
        this.o_pointer.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                XMLGui.this.o_add_link_mode = false;
                XMLGui.this.o_add_divider_mode = false;
                EditorCanvas x_current = XMLGui.this.getCurrentEditor();
                x_current.setSelection(null);
                x_current.setOldSelection(null);
                x_current.rebuild();
                XMLGui.this.setCursor(new Cursor(0));
            }
        });
        this.o_toolbar.add(this.o_pointer);
        this.o_delete = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/delete.gif")));
        this.o_delete.setToolTipText("Delete");
        this.o_delete.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.deleteMessage();
            }
        });
        this.o_toolbar.add(this.o_delete);
        this.o_newmsc = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/newmsc.gif")));
        this.o_newmsc.setToolTipText("New bMSC");
        this.o_newmsc.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newMSC();
            }
        });
        this.o_toolbar.add(this.o_newmsc);
        this.o_newtrans = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/newlink.gif")));
        this.o_newtrans.setToolTipText("New transition");
        this.o_newtrans.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newTransition();
            }
        });
        this.o_toolbar.add(this.o_newtrans);
        this.o_newinst = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/newinst.gif")));
        this.o_newinst.setToolTipText("New instance");
        this.o_newinst.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newInstance();
            }
        });
        this.o_toolbar.add(this.o_newinst);
        this.o_newmsg = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/newmsg.gif")));
        this.o_newmsg.setToolTipText("New message");
        this.o_newmsg.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newMessage(true);
            }
        });
        this.o_toolbar.add(this.o_newmsg);
        this.o_newnegmsg = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/negmsg.gif")));
        this.o_newnegmsg.setToolTipText("New negative message");
        this.o_newnegmsg.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newMessage(false);
            }
        });
        this.o_toolbar.add(this.o_newnegmsg);
        this.o_newdiv = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/div.gif")));
        this.o_newdiv.setToolTipText("New divider");
        this.o_newdiv.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newDivider();
            }
        });
        this.o_toolbar.add(this.o_newdiv);
    }

    public void populateMSCMenus(JMenuBar p_menubar, LTSA p_ltsa) {
        this.o_ltsa = p_ltsa;
        JMenu x_file_menu = new JMenu("File");
        JMenu x_edit_menu = new JMenu("Edit");
        JMenu x_insert_menu = new JMenu("Insert");
        JMenu x_option_menu = new JMenu("Options");
        JMenuItem x_item = new JMenuItem("New...");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newSpec();
            }
        });
        x_file_menu.add(x_item);
        x_item = new JMenuItem("Save as...");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.saveFile();
            }
        });
        x_file_menu.add(x_item);
        x_item = new JMenuItem("Export graphics...");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                EditorCanvas x_current = XMLGui.this.getCurrentEditor();
                XMLGui.this.o_ltsa.exportGraphic((Exportable)x_current);
            }
        });
        x_file_menu.add(x_item);
        x_item = new JMenuItem("Rename");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.rename();
            }
        });
        x_edit_menu.add(x_item);
        x_item = new JMenuItem("Reverse arrow");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.reverseLink();
            }
        });
        x_edit_menu.add(x_item);
        x_item = new JMenuItem("Delete");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.deleteMessage();
            }
        });
        x_edit_menu.add(x_item);
        x_item = new JMenuItem("Negate message");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.negateMessage();
            }
        });
        x_edit_menu.add(x_item);
        x_item = new JMenuItem("Tidy");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.tidyChart();
            }
        });
        x_edit_menu.add(x_item);
        x_item = new JMenuItem("New bMSC");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newMSC();
            }
        });
        x_insert_menu.add(x_item);
        x_item = new JMenuItem("New instance");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newInstance();
            }
        });
        x_insert_menu.add(x_item);
        x_item = new JMenuItem("New transition");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newTransition();
            }
        });
        x_insert_menu.add(x_item);
        x_item = new JMenuItem("New message");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newMessage(true);
            }
        });
        x_insert_menu.add(x_item);
        x_item = new JMenuItem("New negative message");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newMessage(false);
            }
        });
        x_insert_menu.add(x_item);
        x_item = new JMenuItem("New divider");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.newDivider();
            }
        });
        x_insert_menu.add(x_item);
        x_item = new JCheckBoxMenuItem("Large display");
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.setBigFont(((JCheckBoxMenuItem)p_e.getSource()).isSelected());
            }
        });
        x_option_menu.add(x_item);
        x_item = new JCheckBoxMenuItem("Show toolbar");
        x_item.setSelected(true);
        x_item.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent p_e) {
                this.o_gui.showToolBar(((JCheckBoxMenuItem)p_e.getSource()).isSelected());
            }
        });
        x_option_menu.add(x_item);
        p_menubar.add(x_file_menu);
        p_menubar.add(x_edit_menu);
        p_menubar.add(x_insert_menu);
        p_menubar.add(x_option_menu);
    }

    public void renameTab(String p_from, String p_to) {
        this.o_tabbed_pane.setTitleAt(this.o_tabbed_pane.indexOfTab(p_from), p_to);
    }

    public void swapToTab(String p_name) {
        if (this.o_tabbed_pane.indexOfTab(p_name) > -1) {
            this.o_tabbed_pane.setSelectedIndex(this.o_tabbed_pane.indexOfTab(p_name));
        }
    }

    public void rebuildTab(String p_name) {
        EditorCanvas x_tab = (EditorCanvas)this.o_editors.get(this.o_tabbed_pane.indexOfTab(p_name));
        x_tab.rebuild();
    }

    EditorCanvas getCurrentEditor() {
        EditorCanvas x_current = (EditorCanvas)this.o_editors.get(this.o_tabbed_pane.getSelectedIndex());
        return x_current;
    }

    private boolean existsMSCCalled(String p_name) {
        return this.o_tabbed_pane.indexOfTab(p_name) > -1 || this.o_tabbed_pane.indexOfTab(this.capitalise(p_name)) > -1;
    }

    private String capitalise(String p_str) {
        StringBuffer x_str_buf = this.removeSpaces(p_str);
        int c = x_str_buf.indexOf(":");
        if (c < 0) {
            x_str_buf.setCharAt(0, Character.toUpperCase(x_str_buf.charAt(0)));
        } else {
            x_str_buf = x_str_buf.replace(0, c, x_str_buf.substring(0, c).toLowerCase());
            x_str_buf.setCharAt(c + 1, Character.toUpperCase(x_str_buf.charAt(c + 1)));
        }
        return x_str_buf.toString();
    }

    private String smallCaps(String p_str) {
        StringBuffer x_str_buf = this.removeSpaces(p_str);
        x_str_buf.setCharAt(0, Character.toLowerCase(x_str_buf.charAt(0)));
        return x_str_buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer removeSpaces(String p_str) {
        x_str = p_str.replace('.', '_');
        x_str_buf = new StringBuffer(x_str);
        i = 0;
        while (i < x_str_buf.length()) {
            if (x_str_buf.charAt(i) == ' ') {
                x_str_buf.setCharAt(i + 1, Character.toUpperCase(x_str_buf.charAt(i + 1)));
            }
            ++i;
        }
        i = 0;
        ** GOTO lbl16
        {
            x_str_buf.deleteCharAt(i);
            do {
                if (x_str_buf.charAt(i) == ' ') continue block1;
                ++i;
lbl16:
                // 2 sources

            } while (i < x_str_buf.length());
        }
        return x_str_buf;
    }
}

