/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.common.iface.LTSOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.AbstractNegScenario;
import synthesis.AfterUntilNegScenario;
import synthesis.BasicMSC;
import synthesis.BasicNegScenario;
import synthesis.FSPLabel;
import synthesis.MyOutput;
import synthesis.NegScenario;
import synthesis.Pair;
import synthesis.Specification;
import synthesis.StringSet;
import synthesis.Trace;

public class ConstraintSynthesiser {
    public boolean printConstraints(MyOutput Output2, Specification S, String ConstraintName, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("PrintConstraints");
        }
        if (S.getNegbMSCs().size() > 0) {
            String line = "";
            boolean first = true;
            Iterator J = S.getNegbMSCs().iterator();
            while (J.hasNext()) {
                NegScenario n;
                String CName = (String)J.next();
                if (dbg) {
                    o.outln("Processing " + CName);
                }
                if ((n = S.getNegbMSC(CName)) instanceof AfterUntilNegScenario) {
                    this.PrintConstraint(S.alphabet(), (AfterUntilNegScenario)n, Output2, o);
                } else if (n instanceof AbstractNegScenario) {
                    this.PrintConstraint(S.alphabet(), (AbstractNegScenario)n, Output2, o);
                } else if (n instanceof BasicNegScenario) {
                    this.PrintConstraint(S.alphabet(), (BasicNegScenario)n, Output2, o);
                }
                if (first) {
                    first = false;
                } else {
                    line = String.valueOf(line) + " || ";
                }
                line = String.valueOf(line) + CName;
            }
            line = "||" + ConstraintName + " = (" + line + ").";
            Output2.println(line);
        } else {
            Output2.println(String.valueOf(ConstraintName) + " = STOP.");
        }
        return S.getNegbMSCs().size() > 0;
    }

    private void PrintConstraint(StringSet Alphabet, BasicNegScenario n, MyOutput Output2, LTSOutput o) throws Exception {
        HashMap PTransitions;
        Trace PInit;
        boolean dbg = false;
        String name = n.name();
        String disallowed = n.disallowed();
        BasicMSC P = n.precondition();
        if (dbg) {
            o.outln("Printing Constraint " + name);
        }
        P.name = String.valueOf(name) + "_Precondition";
        if (dbg) {
            o.outln("Building Complete Alphabet ");
        }
        if (!P.empty()) {
            if (dbg) {
                o.outln("Precondition is not empty.");
            }
            if (dbg) {
                o.outln("Building Prefixes.");
            }
            Set PTraces = P.getAllTraces(o);
            HashSet<Trace> PPrefixes = new HashSet<Trace>();
            HashSet Pends = new HashSet();
            PInit = this.getPrefixes(PTraces, Pends, PPrefixes, o);
            if (dbg) {
                o.outln("Adding prefix extending transitions.");
            }
            PTransitions = new HashMap();
            this.PrefixExtendingTransitions(PPrefixes, PTransitions, o);
            if (dbg) {
                o.outln("Create Final State");
            }
            Iterator I = Pends.iterator();
            Trace Final = ((Trace)I.next()).myClone();
            Final.add("ThisIsFinal");
            PPrefixes.add(Final);
            if (dbg) {
                o.outln("Adding undefined transitions to Final state");
            }
            this.AddUndefinedTransitions(PPrefixes, PTransitions, Alphabet, Final, o);
            if (dbg) {
                o.outln("Removing constrained transition");
            }
            Iterator J = Pends.iterator();
            while (J.hasNext()) {
                Trace From = (Trace)J.next();
                this.removeTransition(PTransitions, From, disallowed, Final, o);
            }
        } else {
            o.outln("Empty Precondition is not allowed in " + name);
            throw new Error();
        }
        this.printLTS(PInit, P.name, PTransitions.keySet(), PTransitions, Output2, o);
        Output2.println("||" + name + " = " + P.name + ".");
    }

    private void PrintConstraint(StringSet UniversalAlphabet, AbstractNegScenario n, MyOutput Output2, LTSOutput o) throws Exception {
        HashMap PTransitions;
        Trace PInit;
        HashSet Pends;
        boolean dbg = false;
        String name = n.name();
        String disallowed = n.disallowed();
        BasicMSC P = n.precondition();
        StringSet Alphabet = n.Alphabet();
        if (Alphabet == null) {
            Alphabet = new StringSet();
            Alphabet.addAll(UniversalAlphabet);
        }
        if (dbg) {
            o.outln("Building Ignore");
        }
        StringSet IgnoreAlphabet = new StringSet();
        if (!Alphabet.contains(disallowed)) {
            IgnoreAlphabet.add(disallowed);
        }
        if (dbg) {
            IgnoreAlphabet.print(o);
        }
        if (dbg) {
            o.outln("Printing Constraint " + name);
        }
        P.name = String.valueOf(name) + "_Precondition";
        if (!P.empty()) {
            if (dbg) {
                o.outln("a");
            }
            Set PTraces = P.getAllTraces(o);
            HashSet PPrefixes = new HashSet();
            Pends = new HashSet();
            PInit = this.getPrefixes(PTraces, Pends, PPrefixes, o);
            if (dbg) {
                o.outln("Adding prefix extending transitions.");
            }
            PTransitions = new HashMap();
            this.PrefixExtendingTransitions(PPrefixes, PTransitions, o);
            if (dbg) {
                o.outln("Adding undefined transitions to suffixes");
            }
            this.AddUndefinedTransitionsToSuffixes(PPrefixes, PTransitions, Alphabet, o);
            if (dbg) {
                o.outln("Adding undefined transitions as loops ");
            }
            this.AddUndefinedTransitionsToSelf(PPrefixes, PTransitions, IgnoreAlphabet, o);
            if (dbg) {
                o.outln("Removing disallowed transitions from Ending states");
            }
        } else {
            o.outln("Empty Precondition is not allowed in " + name);
            throw new Error();
        }
        this.RemoveTransitionsStartingAt_andLabelledWith_(PTransitions, Pends, disallowed, o);
        this.printLTS(PInit, P.name, PTransitions.keySet(), PTransitions, Output2, o);
        Output2.println("||" + name + " = " + P.name + ".");
    }

    private void PrintConstraint(StringSet UniversalAlphabet, AfterUntilNegScenario n, MyOutput Output2, LTSOutput o) throws Exception {
        HashMap AllTransitions;
        Trace AInit;
        StringSet UAlphabet;
        boolean dbg = false;
        boolean printLTS = false;
        String name = n.name();
        BasicMSC A = n.after();
        String disallowed = n.disallowed();
        BasicMSC U = n.until();
        StringSet AAlphabet = n.afterAlphabet();
        if (AAlphabet == null) {
            AAlphabet = new StringSet();
            AAlphabet.addAll(UniversalAlphabet);
        }
        if ((UAlphabet = n.untilAlphabet()) == null) {
            UAlphabet = new StringSet();
            UAlphabet.addAll(UniversalAlphabet);
        } else if (UAlphabet.contains(disallowed)) {
            o.outln("Disallowed action '" + disallowed + "' included in until condition");
            throw new Error();
        }
        if (dbg) {
            o.outln("Printing Constraint " + name);
        }
        A.name = String.valueOf(name) + "_After";
        U.name = String.valueOf(name) + "_Until";
        if (dbg) {
            o.outln("Building Complete Alphabet ");
        }
        StringSet CompleteAlphabet = new StringSet();
        CompleteAlphabet.addAll(AAlphabet);
        CompleteAlphabet.addAll(UAlphabet);
        CompleteAlphabet.add(disallowed);
        if (dbg) {
            CompleteAlphabet.print(o);
        }
        if (dbg) {
            o.outln("Building AIgnore");
        }
        StringSet AIgnoreAlphabet = new StringSet();
        AIgnoreAlphabet.addAll(CompleteAlphabet);
        AIgnoreAlphabet.removeAll(AAlphabet);
        if (dbg) {
            AIgnoreAlphabet.print(o);
        }
        if (dbg) {
            o.outln("Building UIgnore ");
        }
        StringSet UIgnoreAlphabet = new StringSet();
        UIgnoreAlphabet.addAll(CompleteAlphabet);
        UIgnoreAlphabet.removeAll(UAlphabet);
        UIgnoreAlphabet.remove(disallowed);
        if (dbg) {
            UIgnoreAlphabet.print(o);
        }
        if (dbg) {
            o.outln("Removing " + disallowed + " from UAlphabet");
        }
        if (dbg) {
            UAlphabet.print(o);
        }
        if (UAlphabet.contains(disallowed)) {
            UAlphabet.remove(disallowed);
            if (dbg) {
                UAlphabet.print(o);
            }
        } else if (dbg) {
            o.outln("not found");
        }
        if (!A.empty() && !U.empty()) {
            if (dbg) {
                o.outln("a");
            }
            Set ATraces = A.getAllTraces(o);
            HashSet APrefixes = new HashSet();
            HashSet Aends = new HashSet();
            AInit = this.getPrefixes(ATraces, Aends, APrefixes, o);
            Set UTraces = U.getAllTraces(o);
            HashSet UPrefixes = new HashSet();
            HashSet Uends = new HashSet();
            Trace UInit = this.getPrefixes(UTraces, Uends, UPrefixes, o);
            if (dbg) {
                o.outln("Adding prefix extending transitions.");
            }
            HashMap ATransitions = new HashMap();
            this.PrefixExtendingTransitions(APrefixes, ATransitions, o);
            if (dbg) {
                o.outln("Adding undefined transitions to Final state");
            }
            this.AddUndefinedTransitionsToSuffixes(APrefixes, ATransitions, AAlphabet, o);
            if (dbg) {
                o.outln("Adding undefined transitions as loops ");
            }
            this.AddUndefinedTransitionsToSelf(APrefixes, ATransitions, AIgnoreAlphabet, o);
            if (dbg) {
                o.outln("Adding prefix extending transitions.");
            }
            HashMap UTransitions = new HashMap();
            this.PrefixExtendingTransitions(UPrefixes, UTransitions, o);
            if (dbg) {
                o.outln("Adding undefined transitions to Final state");
            }
            this.AddUndefinedTransitionsToSuffixes(UPrefixes, UTransitions, UAlphabet, o);
            if (dbg) {
                o.outln("Adding undefined transitions as loops ");
            }
            this.AddUndefinedTransitionsToSelf(UPrefixes, UTransitions, UIgnoreAlphabet, o);
            if (printLTS) {
                this.printLTS(AInit, "AfterLTS", ATransitions.keySet(), ATransitions, Output2, o);
            }
            if (printLTS) {
                this.printLTS(UInit, "UntilLTS", UTransitions.keySet(), UTransitions, Output2, o);
            }
            HashMap CombTxs = new HashMap();
            Pair Init = this.CrossProduct(APrefixes, ATransitions, UPrefixes, UTransitions, CombTxs, o);
            if (printLTS) {
                this.printLTS(Init, "CrossLTS", CombTxs.keySet(), CombTxs, Output2, o);
            }
            this.LinkUntilWithAfter(Aends, ATransitions, AAlphabet, UInit, Uends, UTransitions, CombTxs, o);
            this.LinkAfterWithUntil(Aends, ATransitions, UInit, CombTxs.keySet(), o);
            AllTransitions = CombTxs;
            AllTransitions.putAll(ATransitions);
            if (printLTS) {
                this.printLTS(AInit, "WithUnreachable", AllTransitions.keySet(), AllTransitions, Output2, o);
            }
        } else {
            o.outln("Empty After or Until is not allowed in " + name);
            throw new Error();
        }
        this.printLTS(AInit, A.name, this.Reachable(AllTransitions, AInit, o), AllTransitions, Output2, o);
        Output2.println("||" + name + " = " + A.name + ".");
    }

    private void LinkUntilWithAfter(Set Aends, Map ATransitions, Set AAlphabet, Trace UInit, Set Uends, Map UTransitions, Map CombTxs, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("LinkUntilWithAfter");
        }
        HashSet ToAdd = new HashSet();
        HashSet<Pair> ToRemove = new HashSet<Pair>();
        Iterator I = CombTxs.keySet().iterator();
        while (I.hasNext()) {
            Pair CombFrom = (Pair)I.next();
            if (dbg) {
                o.outln("CombFrom: A:" + CombFrom.After.getString() + " B:" + CombFrom.Until.getString());
            }
            if (Uends.contains(CombFrom.Until)) {
                ToRemove.add(CombFrom);
                if (!dbg) continue;
                o.outln("Removed");
                continue;
            }
            Iterator J = ((Set)CombTxs.get(CombFrom)).iterator();
            while (J.hasNext()) {
                Pair auxP;
                Vector v = (Vector)J.next();
                Pair CombTo = (Pair)v.get(0);
                String lbl = (String)v.get(1);
                Vector<Object> w = new Vector<Object>();
                w.add(0, CombFrom);
                w.add(1, lbl);
                if (dbg) {
                    o.outln("lbl " + lbl);
                }
                if (dbg) {
                    o.outln("CombTo: A:" + CombTo.After.getString() + " B:" + CombTo.Until.getString());
                }
                if (Aends.contains(CombTo.After) && Uends.contains(CombTo.Until)) {
                    if (dbg) {
                        o.outln("CombTo.A is END!! and CombTo.B is END!!");
                    }
                    if (!AAlphabet.contains(lbl)) {
                        if (dbg) {
                            o.outln("Send CombFrom to state in After which is maximal proper suffix of CombTo.A");
                        }
                        Trace BestTo = this.getMaximalSuffixOf(CombTo.After, ATransitions.keySet(), o);
                        if (dbg) {
                            o.outln("BestTo: A:" + BestTo.getString());
                        }
                        w.add(2, BestTo);
                        ToAdd.add(w);
                        continue;
                    }
                    if (dbg) {
                        o.outln("Force CombTo.B to reset: Send it to Init");
                    }
                    auxP = new Pair();
                    auxP.After = CombTo.After;
                    auxP.Until = UInit;
                    w.add(2, this.getPair(auxP, CombTxs.keySet(), o));
                    ToAdd.add(w);
                    continue;
                }
                if (!Aends.contains(CombTo.After) && Uends.contains(CombTo.Until)) {
                    if (dbg) {
                        o.outln("CombTo.A is not End!! and CombTo.B is END!!");
                    }
                    if (dbg) {
                        o.outln("Take CombFrom to state CombTo.A in A");
                    }
                    w.add(2, CombTo.After);
                    ToAdd.add(w);
                    continue;
                }
                if (Aends.contains(CombTo.After) && !Uends.contains(CombTo.Until)) {
                    if (dbg) {
                        o.outln("CombTo.A is END!! and CombTo.B is not END!!");
                    }
                    if (dbg) {
                        o.outln("Force CombTo.B to reset: Send it to Init");
                    }
                    auxP = new Pair();
                    auxP.After = CombTo.After;
                    auxP.Until = UInit;
                    w.add(2, this.getPair(auxP, CombTxs.keySet(), o));
                    ToAdd.add(w);
                    continue;
                }
                if (!dbg) continue;
                o.outln("CombTo.A is not END!! and CombTo.B is not END!!");
            }
        }
        Iterator J = ToAdd.iterator();
        while (J.hasNext()) {
            Vector v = (Vector)J.next();
            this.addTransitions(CombTxs, (Pair)v.get(0), (String)v.get(1), v.get(2), "Override", o);
        }
        J = ToRemove.iterator();
        while (J.hasNext()) {
            CombTxs.remove(J.next());
        }
    }

    private void LinkAfterWithUntil(Set Aends, Map ATransitions, Trace UInit, Set CombStates, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("LinkAfterWithUntil");
        }
        HashSet ToAdd = new HashSet();
        HashSet<Trace> ToRemove = new HashSet<Trace>();
        Iterator I = ATransitions.keySet().iterator();
        while (I.hasNext()) {
            Trace From = (Trace)I.next();
            if (dbg) {
                o.outln("From: " + From.getString() + "------------------");
            }
            if (Aends.contains(From)) {
                ToRemove.add(From);
                continue;
            }
            Iterator J = ((Set)ATransitions.get(From)).iterator();
            while (J.hasNext()) {
                Vector v = (Vector)J.next();
                Trace To = (Trace)v.get(0);
                String lbl = (String)v.get(1);
                if (dbg) {
                    o.outln("To: " + To.getString());
                }
                if (dbg) {
                    o.outln("Lbl: " + lbl);
                }
                if (Aends.contains(To)) {
                    if (dbg) {
                        o.outln("To is an ending trace");
                    }
                    Pair auxP = new Pair();
                    auxP.After = To;
                    auxP.Until = UInit;
                    Vector<Object> w = new Vector<Object>();
                    w.add(0, From);
                    w.add(1, lbl);
                    w.add(2, this.getPair(auxP, CombStates, o));
                    ToAdd.add(w);
                    continue;
                }
                if (!dbg) continue;
                o.outln("To is not an ending trace");
            }
        }
        Iterator J = ToAdd.iterator();
        while (J.hasNext()) {
            Vector v = (Vector)J.next();
            this.addTransitions(ATransitions, (Trace)v.get(0), (String)v.get(1), (Pair)v.get(2), "Override", o);
        }
        J = ToRemove.iterator();
        while (J.hasNext()) {
            ATransitions.remove(J.next());
        }
    }

    private Pair GetCombStateWithFixedUntilAndAfterIsAProperPrefixOf(Trace After, Set AStates, Trace Until, Set CombStates, LTSOutput o) {
        boolean dbg = false;
        if (dbg) {
            o.outln("Search for pair in CombStates that has B =" + Until.getString());
        }
        if (dbg) {
            o.outln("           A is maximal proper suffix og =" + After.getString());
        }
        Pair Candidate = new Pair();
        Candidate.After = this.getMaximalSuffixOf(After, AStates, o);
        Candidate.Until = Until;
        return this.getPair(Candidate, CombStates, o);
    }

    private Trace getMaximalSuffixOf(Trace T, Set States, LTSOutput o) {
        boolean dbg = false;
        if (dbg) {
            o.outln("Looking for maximal suffix of " + T.getString() + " in set of " + States.size() + " States");
        }
        Iterator K = States.iterator();
        Trace Best = null;
        int BestSize = -1;
        while (K.hasNext()) {
            Trace Candidate = (Trace)K.next();
            if (dbg) {
                o.outln("We have a candidate " + Candidate.getString());
            }
            if (T.size() > Candidate.size()) {
                if (dbg) {
                    o.outln("Could be a proper suffix");
                }
                if (Candidate.size() > BestSize) {
                    if (dbg) {
                        o.outln("And could be a longer suffix than previous");
                    }
                    if (Candidate.equals(T.subtrace(T.size() - Candidate.size()))) {
                        if (dbg) {
                            o.outln("Equal!");
                        }
                        Best = Candidate;
                        BestSize = Candidate.size();
                        continue;
                    }
                    if (!dbg) continue;
                    o.outln("NotEqual!");
                    continue;
                }
                if (!dbg) continue;
                o.outln("Can't improve previous suffix");
                continue;
            }
            if (!dbg) continue;
            o.outln("Can't be PROPER suffix");
        }
        return Best;
    }

    private Pair CrossProduct(Set AStates, Map ATxs, Set UStates, Map UTxs, Map Transitions, LTSOutput o) {
        boolean dbg = false;
        boolean dbg2 = false;
        if (dbg) {
            o.outln("Get Initial states of When and Until Constraints");
        }
        Trace AInit = this.getInit(AStates);
        Trace UInit = this.getInit(UStates);
        Pair InitialPair = null;
        if (dbg) {
            o.outln("Initialise recursion");
        }
        HashSet<Pair> Rest = new HashSet<Pair>();
        Iterator I = AStates.iterator();
        while (I.hasNext()) {
            Pair aux = new Pair();
            aux.After = (Trace)I.next();
            aux.Until = UInit;
            Rest.add(aux);
            if (aux.After != AInit) continue;
            InitialPair = aux;
        }
        if (dbg2) {
            o.outln("Building cross product");
        }
        while (Rest.size() != 0) {
            Pair p = null;
            if (dbg2) {
                o.outln("Get a state to process");
            }
            Iterator Iaux = Rest.iterator();
            p = (Pair)Iaux.next();
            Transitions.put(p, new HashSet());
            Trace FromU = p.Until;
            if (dbg2) {
                o.outln("U in state " + FromU.getString());
            }
            Trace FromA = p.After;
            if (dbg2) {
                o.outln("A is in state " + FromA.getString());
            }
            if (dbg) {
                o.outln("Get possible moves from A State...");
            }
            Iterator J = ((Set)ATxs.get(FromA)).iterator();
            while (J.hasNext()) {
                Vector t = (Vector)J.next();
                String lbl = (String)t.get(1);
                Trace ToA = (Trace)t.get(0);
                if (dbg2) {
                    o.outln("Got ToA " + ToA.getString());
                }
                if (dbg2) {
                    o.outln("Get move for " + lbl + " from U state");
                }
                Iterator K = ((Set)UTxs.get(FromU)).iterator();
                boolean found = false;
                Trace ToU = null;
                while (K.hasNext() && !found) {
                    Vector v = (Vector)K.next();
                    found = lbl.equals((String)v.get(1));
                    ToU = (Trace)v.get(0);
                }
                if (!found) {
                    if (dbg2) {
                        o.outln("U state has not move for label " + lbl);
                    }
                    if (!dbg2) continue;
                    o.outln("It should be the disallowed, thus no transition should be created");
                    continue;
                }
                if (dbg2) {
                    o.outln("Found ToU " + ToU.getString());
                }
                if (AStates.contains(ToA) && UStates.contains(ToU)) {
                    Pair Existing;
                    if (dbg2) {
                        o.outln("New state: ToA: " + ToA.getString() + " ToU: " + ToU.getString());
                    }
                    Pair np = new Pair(ToA, ToU);
                    if (dbg) {
                        o.outln("getting equiv object if new state has already been reached...");
                    }
                    if ((Existing = this.getPair(np, Transitions.keySet(), o)) == null) {
                        Existing = this.getPair(np, Rest, o);
                        if (Existing == null) {
                            if (dbg2) {
                                o.outln("Its a new node...");
                            }
                            Rest.add(np);
                        } else {
                            np = Existing;
                        }
                    } else {
                        if (dbg2) {
                            o.outln("Its an old node...");
                        }
                        np = Existing;
                    }
                    if (dbg2) {
                        o.outln("adding transition...");
                    }
                    Vector<Object> v = new Vector<Object>();
                    v.add(0, np);
                    v.add(1, lbl);
                    ((Set)Transitions.get(p)).add(v);
                    continue;
                }
                if (!dbg) continue;
                o.outln("Pair does not belong to the corss product");
            }
            if (dbg) {
                o.outln("removing processed state");
            }
            Rest.remove(p);
            if (!dbg) continue;
            o.outln("removed");
        }
        if (dbg) {
            o.outln("Finished");
        }
        return InitialPair;
    }

    private Set Reachable(Map Transitions, Object Init, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("Initialise recursion");
        }
        HashSet<Object> Rest = new HashSet<Object>();
        Rest.add(Init);
        HashSet Reachables = new HashSet();
        while (Rest.size() != 0) {
            Object p = null;
            if (dbg) {
                o.outln("Get a state to process");
            }
            Iterator I = Rest.iterator();
            p = I.next();
            if (!Transitions.keySet().contains(p)) {
                if (p instanceof Trace) {
                    throw new Exception("Found Deadlock state!" + ((Trace)p).getString());
                }
                if (p instanceof Pair) {
                    throw new Exception("Found Deadlock state! a:" + ((Pair)p).After.getString() + " b:" + ((Pair)p).Until.getString());
                }
                throw new Exception("Found Deadlock state! And cant figure out the type!");
            }
            I = ((Set)Transitions.get(p)).iterator();
            while (I.hasNext()) {
                Vector t = (Vector)I.next();
                String lbl = (String)t.get(1);
                Object To = t.get(0);
                if (Reachables.contains(To)) continue;
                Rest.add(To);
            }
            Reachables.add(p);
            Rest.remove(p);
        }
        return Reachables;
    }

    private Trace getInit(Set Nodes) {
        Trace Init = null;
        Iterator I = Nodes.iterator();
        while (I.hasNext() && Init == null) {
            Trace t = (Trace)I.next();
            if (t.size() != 0) continue;
            Init = t;
        }
        return Init;
    }

    private void PrefixExtendingTransitions(Set Prefixes, Map Transitions, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("PrefixExtendingTransitions");
        }
        Iterator I = Prefixes.iterator();
        while (I.hasNext()) {
            Trace From = (Trace)I.next();
            if (dbg) {
                o.outln("Analysing From state:");
                From.print(o);
            }
            Iterator J = Prefixes.iterator();
            while (J.hasNext()) {
                Trace To = (Trace)J.next();
                if (dbg) {
                    o.outln("Looking at possible To state:");
                    To.print(o);
                }
                if (To.size() != From.size() + 1 || !From.isPrefixOf(To)) continue;
                String lbl = To.get(To.size() - 1);
                if (dbg) {
                    o.outln("This pair requires a transition labelled: " + lbl);
                }
                this.addTransitions(Transitions, From, lbl, To, "Determinisitic", o);
            }
        }
    }

    private void AddUndefinedTransitions(Set States, Map Transitions, StringSet Alphabet, Trace T, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("AddUndefinedTransitions");
        }
        Iterator I = States.iterator();
        while (I.hasNext()) {
            Trace From = (Trace)I.next();
            if (dbg) {
                o.outln("Analysing From state:");
                From.print(o);
            }
            Iterator J = Alphabet.iterator();
            while (J.hasNext()) {
                String lbl = (String)J.next();
                if (dbg) {
                    o.outln("Looking at label :" + lbl);
                }
                if (this.existsTransition(Transitions, From, lbl, o)) continue;
                if (dbg) {
                    o.outln("Found undefined label");
                }
                this.addTransitions(Transitions, From, lbl, T, "Determinisitic", o);
            }
        }
    }

    private void AddUndefinedTransitionsToSuffixes(Set States, Map Transitions, StringSet Alphabet, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("AddUndefinedTransitionsToSuffixes");
        }
        Iterator I = States.iterator();
        while (I.hasNext()) {
            Trace From = (Trace)I.next();
            if (dbg) {
                o.outln("Analysing From state:");
                From.print(o);
            }
            Iterator J = Alphabet.iterator();
            while (J.hasNext()) {
                String lbl = (String)J.next();
                if (dbg) {
                    o.outln("Looking at label :" + lbl);
                }
                if (this.existsTransition(Transitions, From, lbl, o)) continue;
                Trace From_lbl = From.myClone();
                From_lbl.add(lbl);
                if (dbg) {
                    o.outln("From_lbl:");
                    From_lbl.print(o);
                }
                Trace BestTo = null;
                int BestToSize = -1;
                Iterator K = States.iterator();
                while (K.hasNext()) {
                    Trace To = (Trace)K.next();
                    if (dbg) {
                        o.outln("Analysing To state:");
                        To.print(o);
                    }
                    if (dbg) {
                        o.outln("From_lbl size = " + From_lbl.size() + ", To size =" + To.size());
                    }
                    if (From_lbl.size() <= To.size() || To.size() <= BestToSize) continue;
                    if (dbg) {
                        o.outln("Comparing with:");
                        From_lbl.subtrace(From_lbl.size() - To.size()).print(o);
                    }
                    if (To.equals(From_lbl.subtrace(From_lbl.size() - To.size()))) {
                        if (dbg) {
                            o.outln("Equal!");
                        }
                        BestTo = To;
                        BestToSize = To.size();
                        continue;
                    }
                    if (!dbg) continue;
                    o.outln("NotEqual!");
                }
                if (BestTo == null) {
                    if (!dbg) continue;
                    o.outln("No Suffix:");
                    continue;
                }
                if (dbg) {
                    o.outln("Found Suffix:");
                    BestTo.print(o);
                }
                this.addTransitions(Transitions, From, lbl, BestTo, "Determinisitic", o);
            }
        }
    }

    private void AddUndefinedTransitionsToSelf(Set States, Map Transitions, StringSet Alphabet, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("AddUndefinedTransitionsToSelf");
        }
        Iterator I = States.iterator();
        while (I.hasNext()) {
            Trace From = (Trace)I.next();
            if (dbg) {
                o.outln("Analysing From state:");
                From.print(o);
            }
            Iterator J = Alphabet.iterator();
            while (J.hasNext()) {
                String lbl = (String)J.next();
                if (dbg) {
                    o.outln("Looking at label :" + lbl);
                }
                if (this.existsTransition(Transitions, From, lbl, o)) continue;
                if (dbg) {
                    o.outln("Found undefined label");
                }
                this.addTransitions(Transitions, From, lbl, From, "Determinisitic", o);
            }
        }
    }

    private boolean existsTransition(Map Transitions, Trace From, String lbl, LTSOutput o) {
        boolean dbg = false;
        if (!Transitions.keySet().contains(From)) {
            return false;
        }
        Set Tx = (Set)Transitions.get(From);
        if (dbg) {
            o.outln("Check if there is a transition From---" + lbl + "--->");
        }
        boolean found = false;
        Iterator I = Tx.iterator();
        Vector vAux = null;
        while (I.hasNext() && !found) {
            vAux = (Vector)I.next();
            if (dbg) {
                o.outln("Comparing with -" + (String)vAux.get(1) + "-");
            }
            found = lbl.equals((String)vAux.get(1));
        }
        return found;
    }

    private boolean removeTransition(Map Transitions, Trace From, String lbl, Trace To, LTSOutput o) {
        boolean dbg = false;
        if (!Transitions.keySet().contains(From)) {
            return false;
        }
        Set Tx = (Set)Transitions.get(From);
        if (dbg) {
            o.outln("Check if there is a transition From---" + lbl + "--->");
        }
        boolean found = false;
        Iterator I = Tx.iterator();
        Vector vAux = null;
        while (I.hasNext()) {
            vAux = (Vector)I.next();
            if (dbg) {
                o.outln("Comparing with " + (String)vAux.get(1));
            }
            if (!lbl.equals((String)vAux.get(1)) || !To.equals((Trace)vAux.get(0))) continue;
            Tx.remove(vAux);
            I = Tx.iterator();
            found = true;
        }
        return found;
    }

    private boolean removeTransition(Map Transitions, Trace From, String lbl, LTSOutput o) {
        boolean dbg = false;
        if (!Transitions.keySet().contains(From)) {
            return false;
        }
        Set Tx = (Set)Transitions.get(From);
        if (dbg) {
            o.outln("Check if there is a transition From---" + lbl + "--->");
        }
        boolean found = false;
        Iterator I = Tx.iterator();
        Vector vAux = null;
        while (I.hasNext()) {
            vAux = (Vector)I.next();
            if (dbg) {
                o.outln("Comparing with " + (String)vAux.get(1));
            }
            if (!lbl.equals((String)vAux.get(1))) continue;
            Tx.remove(vAux);
            I = Tx.iterator();
            found = true;
        }
        return found;
    }

    private void RemoveTransitionsStartingAt_andLabelledWith_(Map Transitions, Set ends, String disallowed, LTSOutput o) {
        Iterator I = ends.iterator();
        while (I.hasNext()) {
            Trace From = (Trace)I.next();
            this.removeTransition(Transitions, From, disallowed, o);
        }
    }

    private void addTransitions(Map Transitions, Object From, String lbl, Object To, String Mode, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (!Transitions.keySet().contains(From)) {
            Transitions.put(From, new HashSet());
        }
        Set Tx = (Set)Transitions.get(From);
        if (dbg) {
            o.outln("Check if there is a transition From---" + lbl + "--->");
        }
        boolean found = false;
        Iterator I = Tx.iterator();
        Vector vAux = null;
        while (I.hasNext() && !found) {
            vAux = (Vector)I.next();
            if (dbg) {
                o.outln("Comparing with " + (String)vAux.get(1));
            }
            found = lbl.equals((String)vAux.get(1));
        }
        Vector<Object> v = new Vector<Object>();
        v.add(0, To);
        v.add(1, lbl);
        if (Mode == "Determinisitic") {
            if (found) {
                throw new Exception("Mode is determinisitic but there is a transition already!");
            }
            if (dbg) {
                o.outln("Add new transition");
            }
            Tx.add(v);
        } else if (Mode == "Override") {
            if (found) {
                if (dbg) {
                    o.outln("Delete existing and add current");
                }
                Tx.remove(vAux);
                Tx.add(v);
            } else {
                if (dbg) {
                    o.outln("Add new transition");
                }
                Tx.add(v);
            }
        } else {
            throw new Exception("Unknown mode!");
        }
    }

    private Trace getPrefixes(Set Traces, Set ends, Set Prefexis, LTSOutput o) {
        boolean dbg = false;
        if (dbg) {
            o.outln("getPrefixes");
        }
        Iterator I = Traces.iterator();
        while (I.hasNext()) {
            if (dbg) {
                o.outln("gettingTrace");
            }
            Trace t = (Trace)I.next();
            if (dbg) {
                o.outln("gotTrace");
            }
            this.addPrefexis(Prefexis, t, ends, o);
        }
        Trace Init = new Trace();
        Prefexis.add(Init);
        return Init;
    }

    private void addPrefexis(Set P, Trace t, Set ends, LTSOutput o) {
        boolean dbg = false;
        if (dbg) {
            o.outln("addPrefexis");
        }
        Object Init = null;
        boolean found = false;
        int i = t.size() - 1;
        while (i >= 0 && !found) {
            Trace subtrace = t.subtrace(0, i);
            Iterator I = P.iterator();
            while (I.hasNext() && !found) {
                Trace aux = (Trace)I.next();
                found = subtrace.equals(aux);
            }
            if (!found) {
                P.add(subtrace);
            }
            if (i == t.size() - 1) {
                ends.add(subtrace);
            }
            --i;
        }
    }

    private void printLTS(Object Init, String Name, Set States, Map Transitions, MyOutput Output2, LTSOutput o) throws Exception {
        boolean dbg = false;
        boolean printmapping = true;
        HashMap Ids = new HashMap();
        if (dbg) {
            o.outln("BuildMapping");
        }
        if (printmapping) {
            Output2.println("/*");
        }
        Iterator I = States.iterator();
        int Id = 1;
        while (I.hasNext()) {
            Object t = I.next();
            if (t != Init) {
                Ids.put(t, new Integer(Id));
                if (printmapping) {
                    if (t instanceof Trace) {
                        Output2.println(String.valueOf(Id) + "->" + ((Trace)t).getString());
                    } else if (t instanceof Pair) {
                        Output2.println(String.valueOf(Id) + "-> (A:" + ((Pair)t).After.getString() + ", B:" + ((Pair)t).Until.getString() + ")");
                    }
                }
                ++Id;
                continue;
            }
            Ids.put(t, new Integer(0));
            if (!printmapping) continue;
            if (t instanceof Trace) {
                Output2.println("0->" + ((Trace)t).getString());
                continue;
            }
            if (!(t instanceof Pair)) continue;
            Output2.println("0-> (A:" + ((Pair)t).After.getString() + ", B:" + ((Pair)t).Until.getString() + ")");
        }
        if (printmapping) {
            Output2.println("*/");
        }
        if (dbg) {
            o.outln("Initial declaration for When");
        }
        Output2.println(Name + " = N0,");
        if (dbg) {
            o.outln("Other declarations for When ");
        }
        I = States.iterator();
        while (I.hasNext()) {
            Object From = I.next();
            Integer FromId = (Integer)Ids.get(From);
            Output2.print("N" + FromId + "=");
            Iterator J = ((Set)Transitions.get(From)).iterator();
            boolean first = true;
            boolean end = false;
            FSPLabel l = new FSPLabel();
            while (J.hasNext()) {
                Vector v = (Vector)J.next();
                String lbl = (String)v.get(1);
                Object To = v.get(0);
                Integer ToId = (Integer)Ids.get(To);
                if (ToId == null) {
                    o.outln("Node not found:");
                }
                if (first) {
                    Output2.print("(");
                    first = false;
                } else {
                    Output2.print(" | ");
                }
                l.setMessageLabel(lbl, null, null);
                Output2.print(String.valueOf(l.getLabel()) + " -> N" + ToId);
            }
            if (!end) {
                Output2.print(")");
            }
            if (I.hasNext()) {
                Output2.println(",");
                continue;
            }
            Output2.println(".");
        }
        if (dbg) {
            o.outln("Finished");
        }
    }

    private Trace getLoop(Map Tx, LTSOutput o) {
        Trace Loop = null;
        Iterator I = Tx.keySet().iterator();
        while (I.hasNext() && Loop == null) {
            Trace t = (Trace)I.next();
            if (!this.isEnd(t, Tx, o)) continue;
            Set Traces = (Set)Tx.get(t);
            Iterator J = Traces.iterator();
            Vector v = (Vector)J.next();
            Loop = (Trace)v.get(2);
        }
        return Loop;
    }

    private boolean isEnd(Trace T, Map Txs, LTSOutput o) {
        Iterator I;
        boolean dbg = false;
        if (dbg) {
            o.outln("In isEnd");
        }
        if ((I = ((Set)Txs.get(T)).iterator()).hasNext()) {
            Vector t = (Vector)I.next();
            String lbl = (String)t.get(1);
            if (dbg) {
                o.outln("Out isEnd");
            }
            return lbl.equals("END");
        }
        if (dbg) {
            o.outln("Out isEnd");
        }
        return false;
    }

    private Pair getPair(Pair p, Set S, LTSOutput o) {
        boolean dbg = false;
        if (dbg) {
            o.outln("In pairIn");
        }
        Iterator J = S.iterator();
        boolean found = false;
        while (J.hasNext()) {
            Pair np = (Pair)J.next();
            if (np.After != p.After || np.Until != p.Until) continue;
            return np;
        }
        if (dbg) {
            o.outln("out pairIn");
        }
        return null;
    }
}

